<?xml version='1.0'?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:output method="html"/>
<xsl:key name="FixNumber-Key" match="/Patches/PatchInfo/FixNumber" use="."/>
<xsl:template match="/">
<html>
<head>
<link type="text/css" rel="stylesheet" href="castylesr1\castylesr1.css" />

</head>
<body bgcolor="#ffffff">
<!--
Logo  table.
This table contains the Logo and the Product name CA Arcserve Backup
-->

<table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="white" >
		<tr> 
			<td width="5%" align="left">
				<img src="castylesr1/cssimages/circleca1.png" border="0" alt="Arcserve" width="57" height="38"/>
			</td>
			<td width="95%" align="right" >
				<div align="left"><span class="product_name">Unified Data Protection</span></div>
			</td>			
		</tr>
	</table>
<!--
Page Header table.
This table contains the heading  "patch History for the server xxxx" and also "number of Patches applied"
-->
<table width="99%" border="0" cellpadding="0" cellspacing="0" align="center">
 <tr> 
      <td colspan="6"> 
           <table cellSpacing="0" cellPadding="0" width="100%" border="0">
            <tr>
			
             <td width="4" height="22" class="page_section_header_left">
              <IMG src="castylesr1/prototypeimages/spacer.png" width="4" height="22" border="0"/>
             </td>
			 
               <td  class="page_Section_header_center" align="left" > 
                <span  class="page_section_header_text">Current State of the Server <xsl:value-of select="//@Server" />  </span>
               </td>	
               <td width="4" height="22" class="page_Section_header_right">
                <img src="castylesr1/prototypeimages/spacer.png" alt="" width="4" height="22" border="0"/>
               </td>
            </tr>
        </table>
       </td>
      </tr>
	  <xsl:if test="count(/Patches/PatchInfo/Files) = 0">
	  <tr class="page_section_instruction_area">
       <td class="page_section_instructions_text">
      Total Number of Patches Applied are : <xsl:value-of select="count(/Patches/PatchInfo/FixNumber[generate-id()=generate-id(key('FixNumber-Key',.)[1])])" />
       </td>
      </tr>
	  </xsl:if>
	  </table>
	  <br/>
  
<!--
This is the content table
For each PatchInfo node in the xml , one table will be generated
-->
<xsl:for-each select="Patches/PatchInfo">


<table width="99%" border="0" cellpadding="0" cellspacing="0" align="center">
 <!-- Fix Number Header -->
 <tr > 
      <td colspan="6"> 
           <table cellSpacing="0" cellPadding="0" width="100%" border="0">
            <tr>
			
             <td width="4" height="22" class="page_section_header_left">
              <IMG src="castylesr1/prototypeimages/spacer.png" width="4" height="22" border="0"/>
             </td>
			 
               <td  class="page_Section_header_center" align="left" > 
                <span  class="page_Section_header_text">Patch : <xsl:value-of select="FixNumber" />  </span>
               </td>	
               <td width="4" height="22" class="page_section_header_right">
                <img src="castylesr1/prototypeimages/spacer.png" alt="" width="4" height="22" border="0"/>
               </td>
            </tr>
        </table>
       </td>
      </tr>

<!-- Product Name -->
<tr class="page_section">
<td class="data">
<p>Product: <xsl:value-of select="Product" /> <xsl:value-of select="Release" /></p>
</td>
</tr>

<!-- Applied time -->
<tr class="page_section">
<td class="data">
<p>	Applied on : <xsl:value-of select="TimeStamp" /></p>
</td>
</tr>

</table>

<br/>
 
</xsl:for-each>

</body>
</html>
 </xsl:template>
</xsl:stylesheet>