<?xml version='1.0'?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:output method="html"></xsl:output>
<xsl:template match="/">
<html>
<head>
<link type="text/css" rel="stylesheet" href="castylesr1\castylesr1.css"></link>

<xsl:text disable-output-escaping="yes">

<![CDATA[
<script>
function ChangeDisplay(divId)
{       
        var innerDiv = divId+"_inner";
        var imageId = divId+"_image";   
        var hideDiv = document.getElementById(innerDiv);        
        var image =   document.getElementById(imageId); 
        
        if(hideDiv.style.display == "none")
        {
                hideDiv.style.display="block";
                image.src="castylesr1/prototypeimages/arrow_down.png";
        }
        else
        {
                hideDiv.style.display="none";
                image.src="castylesr1/prototypeimages/arrow_up.png";
        }
}

</script>
]]>

</xsl:text>


</head>
<body bgcolor="#ffffff">
<!--Logo  table.
This table contains the CA Logo and the Product name ARCServe Backup
-->
<table width="100%" border="0" cellspacing="0" cellpadding="0" bgcolor="white">
		<tr> 
			<td width="5%" align="left">
				<img src="castylesr1/cssimages/calogo_45.png" border="0" alt="CA" width="57" height="38"></img>
			</td>
			<td width="95%" align="right">
				<div align="left"><span class="product_name">Unified Data Protection</span></div>
			</td>			
		</tr>
	</table>
<!--
Page Header table.
This table contains the heading  "patch History for the server xxxx" and also "number of Patches applied"
-->
<table width="99%" border="0" cellpadding="0" cellspacing="0" align="center">
 <tr> 
      <td colspan="6"> 
           <table cellSpacing="0" cellPadding="0" width="100%" border="0">
            <tr>
			
             <td width="4" height="22" class="page_section_header_left">
              <IMG src="castylesr1/prototypeimages/spacer.png" width="4" height="22" border="0"></IMG>
             </td>
			 
               <td class="page_Section_header_center" align="left"> 
                <span class="page_section_header_text">Historial de parches para el servidor <xsl:value-of select="//@Server"></xsl:value-of>  </span>
               </td>	
               <td width="4" height="22" class="page_Section_header_right">
                <img src="castylesr1/prototypeimages/spacer.png" alt="" width="4" height="22" border="0"></img>
               </td>
            </tr>
           </table>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" align="left">            
            <tr class="page_section_instruction_area">
              <td class="page_section_instructions_text">
                     <a href="PatchStatus.xml">Ver archivo del estado del parche</a>
              </td>
            </tr>            
        </table>
       </td>
      </tr>
	 
	  </table>
	  <br></br>
  
<!--
This is the content table
For each PatchInfo node in the xml , one table will be generated
-->
<xsl:for-each select="Patches/PatchInfo">
 <xsl:variable name="DivId" select="generate-id()"></xsl:variable>
 <xsl:variable name="InnerDiv" select="concat($DivId,'_inner')"></xsl:variable>
 <xsl:variable name="Image" select="concat($DivId,'_image')"></xsl:variable>
<div>
<table width="99%" border="0" cellpadding="0" cellspacing="0" align="center">
 <!-- Fix Number Header -->
 
 <tr> 
      <td colspan="6"> 
           <table cellSpacing="0" cellPadding="0" width="100%" border="0">
            <tr>
			
             <td width="4" height="22" class="page_section_header_left">
              <IMG src="castylesr1/prototypeimages/spacer.png" width="4" height="22" border="0"></IMG>
             </td>
			 
               <td id="{$DivId}" class="page_section_header_center" align="left" OnClick="ChangeDisplay(this.id)">
			<img id="{$Image}" width="14" height="14" class="hide_show_button" src="castylesr1/prototypeimages/arrow_down.png"></img>
                        <span class="page_section_header_text">Parche :<xsl:value-of select="FixNumber"></xsl:value-of></span>
		        <img src="castylesr1/prototypeimages/spacer.png" alt="" width="4" height="22" border="0"></img>
                        <span  class="page_section_header_text"><xsl:value-of select="State" /></span>
               </td>	
               <td width="4" height="22" class="page_section_header_right">
                <img src="castylesr1/prototypeimages/spacer.png" alt="" width="4" height="22" border="0"></img>
               </td>			   
            </tr>
        </table>
       </td>
      </tr>
</table>
<div id="{$InnerDiv}">	  
<table width="99%" border="0" cellpadding="0" cellspacing="0" align="center">
<!-- Product Name -->
<tr class="page_section">
<td class="data">
<p>Producto: <xsl:value-of select="Product"></xsl:value-of> <xsl:value-of select="Release"></xsl:value-of></p>
</td>
</tr>

<!-- Applied time -->
<tr class="page_section">
<td class="data">
<p>
		 <xsl:choose>
		<xsl:when test="State='Uninstalled'">
        Desinstalado en : <xsl:value-of select="TimeStamp"></xsl:value-of>
	</xsl:when>
	<xsl:otherwise>
        Aplicado en :<xsl:value-of select="TimeStamp"></xsl:value-of>
	</xsl:otherwise>
	</xsl:choose>
	</p>
</td>
</tr>
<!--
This is commented as the State is being moved to the header. Please uncomment this if you want to show the state information also.
-->
<!-- State of the Patch
<tr class="page_section">
<td class="data">
<p>Current State of the Patch: <b><xsl:value-of select="State" /></b> </p>
</td>
</tr>
 -->

<!-- Patch Description kappr01  -->

  <tr class="page_section">
     <td class="data">
       <p>Descripción: <xsl:value-of select="PatchDesc"></xsl:value-of></p> 
     </td>
  </tr>

<!-- End Patch Description  -->

<!-- Files Information -->
<tr class="page_section">
<td class="data">
<!--Populate a table here -->
<!--Table Header Files Information -->
<xsl:if test="count(Files) > 0">
<table width="100%" border="0" cellpadding="0" cellspacing="0" align="left">
 <tr> 
      <td colspan="6"> 
           <table cellSpacing="0" cellPadding="0" width="100%" border="0">
            <tr>
			
             <td width="4" height="22" class="groupbox_header_left">
              <IMG src="castylesr1/prototypeimages/spacer.png" width="4" height="22" border="0"></IMG>
             </td>
			 
               <td class="groupbox_header_center" align="left"> 
                <span class="groupbox_header_text">Información del archivo reemplazado</span>
               </td>	
               <td width="4" height="22" class="groupbox_header_right">
                <img src="castylesr1/prototypeimages/spacer.png" alt="" width="4" height="22" border="0"></img>
               </td>
            </tr>
        </table>
       </td>
      </tr>
	  <!-- Headers row for the Files table -->
	   
	<tr>            
            <td><span class="table_column_header_text">Nombre del archivo</span></td>
            <td><span class="table_column_header_text">Tamaño del archivo nuevo</span></td>       
                        <td><span class="table_column_header_text">Tamaño del archivo antiguo</span></td>      
            <td><span class="table_column_header_text">Fecha de modificación del archivo nuevo</span></td>
            <td><span class="table_column_header_text">Fecha de modificación del archivo antiguo</span></td>
            <td><span class="table_column_header_text">Ruta</span></td>
          </tr>
		  
	<!-- Data -->
	
	<xsl:for-each select="Files/File">
	<tr class="table_row">
            <td class="table_data" align="left"><xsl:value-of select="."></xsl:value-of></td>
            <td class="table_data" align="left"><xsl:value-of select="@NewFileSize"></xsl:value-of>bytes</td>
                        <td class="table_data" align="left"><xsl:value-of select="@OldFileSize"></xsl:value-of>bytes</td>
            <td class="table_data" align="left"><xsl:value-of select="@DateReplaced"></xsl:value-of></td>
            <td class="table_data" align="left"><xsl:value-of select="@OldFileDate"></xsl:value-of></td>
            <td class="table_data" align="left"><xsl:value-of select="@Path"></xsl:value-of></td>            
          </tr>
	</xsl:for-each>
	
	  </table>
 
</xsl:if>  
</td>
</tr>
</table>

<br></br>
</div> 
</div> 
<br></br>
</xsl:for-each>

</body>
</html>
 </xsl:template>
</xsl:stylesheet>