/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.PrivateLinkResourceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ResolvePrivateLinkServiceIdsInner {
    private ResolvePrivateLinkServiceIdsService service;
    private ContainerServiceManagementClientImpl client;

    public ResolvePrivateLinkServiceIdsInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (ResolvePrivateLinkServiceIdsService)retrofit.create(ResolvePrivateLinkServiceIdsService.class);
        this.client = client;
    }

    public PrivateLinkResourceInner pOST(String resourceGroupName, String resourceName, PrivateLinkResourceInner parameters) {
        return (PrivateLinkResourceInner)((ServiceResponse)this.pOSTWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateLinkResourceInner> pOSTAsync(String resourceGroupName, String resourceName, PrivateLinkResourceInner parameters, ServiceCallback<PrivateLinkResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.pOSTWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<PrivateLinkResourceInner> pOSTAsync(String resourceGroupName, String resourceName, PrivateLinkResourceInner parameters) {
        return this.pOSTWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<PrivateLinkResourceInner>, PrivateLinkResourceInner>(){

            public PrivateLinkResourceInner call(ServiceResponse<PrivateLinkResourceInner> response) {
                return (PrivateLinkResourceInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkResourceInner>> pOSTWithServiceResponseAsync(String resourceGroupName, String resourceName, PrivateLinkResourceInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2020-09-01";
        return this.service.pOST(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceInner>>>(){

            public Observable<ServiceResponse<PrivateLinkResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResolvePrivateLinkServiceIdsInner.this.pOSTDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkResourceInner> pOSTDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ResolvePrivateLinkServiceIdsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ResolvePrivateLinkServiceIds pOST"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resolvePrivateLinkServiceId")
        public Observable<Response<ResponseBody>> pOST(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body PrivateLinkResourceInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

