/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.PrivateEndpointConnectionInner;
import com.microsoft.azure.management.containerservice.implementation.PrivateEndpointConnectionListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PrivateEndpointConnectionsInner {
    private PrivateEndpointConnectionsService service;
    private ContainerServiceManagementClientImpl client;

    public PrivateEndpointConnectionsInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (PrivateEndpointConnectionsService)retrofit.create(PrivateEndpointConnectionsService.class);
        this.client = client;
    }

    public PrivateEndpointConnectionListResultInner list(String resourceGroupName, String resourceName) {
        return (PrivateEndpointConnectionListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<PrivateEndpointConnectionListResultInner> listAsync(String resourceGroupName, String resourceName, ServiceCallback<PrivateEndpointConnectionListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionListResultInner> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionListResultInner>, PrivateEndpointConnectionListResultInner>(){

            public PrivateEndpointConnectionListResultInner call(ServiceResponse<PrivateEndpointConnectionListResultInner> response) {
                return (PrivateEndpointConnectionListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionListResultInner>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionListResultInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointConnectionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateEndpointConnectionInner get(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointConnectionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateEndpointConnectionInner update(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return (PrivateEndpointConnectionInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, parameters), serviceCallback);
    }

    public Observable<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName, parameters).map((Func1)new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>(){

            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return (PrivateEndpointConnectionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-09-01";
        return this.service.update(this.client.subscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>(){

            public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointConnectionsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateEndpointConnectionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, privateEndpointConnectionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, resourceName, privateEndpointConnectionName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateEndpointConnectionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateEndpointConnectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.PrivateEndpointConnections list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/privateEndpointConnections")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.PrivateEndpointConnections get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.PrivateEndpointConnections update"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Body PrivateEndpointConnectionInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.PrivateEndpointConnections delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.PrivateEndpointConnections beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="privateEndpointConnectionName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

