/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.OperationValueInner;
import com.microsoft.azure.management.containerservice.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class OperationsInner {
    private OperationsService service;
    private ContainerServiceManagementClientImpl client;

    public OperationsInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (OperationsService)retrofit.create(OperationsService.class);
        this.client = client;
    }

    public List<OperationValueInner> list() {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<OperationValueInner>> listAsync(ServiceCallback<List<OperationValueInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<OperationValueInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<OperationValueInner>>, List<OperationValueInner>>(){

            public List<OperationValueInner> call(ServiceResponse<List<OperationValueInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<OperationValueInner>>> listWithServiceResponseAsync() {
        String apiVersion = "2020-09-01";
        return this.service.list("2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<OperationValueInner>>>>(){

            public Observable<ServiceResponse<List<OperationValueInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OperationsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<OperationValueInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<OperationValueInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface OperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.Operations list"})
        @GET(value="providers/Microsoft.ContainerService/operations")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

