/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerservice.ManagedClusterAADProfile;
import com.microsoft.azure.management.containerservice.ManagedClusterServicePrincipalProfile;
import com.microsoft.azure.management.containerservice.TagsObject;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.CredentialResultsInner;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterAccessProfileInner;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterUpgradeProfileInner;
import com.microsoft.azure.management.containerservice.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedClustersInner
implements InnerSupportsGet<ManagedClusterInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ManagedClusterInner> {
    private ManagedClustersService service;
    private ContainerServiceManagementClientImpl client;

    public ManagedClustersInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (ManagedClustersService)retrofit.create(ManagedClustersService.class);
        this.client = client;
    }

    public PagedList<ManagedClusterInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ManagedClusterInner>((Page)response.body()){

            public Page<ManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedClusterInner>> listAsync(ListOperationCallback<ManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(String nextPageLink) {
                return ManagedClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedClusterInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Page<ManagedClusterInner>>(){

            public Page<ManagedClusterInner> call(ServiceResponse<Page<ManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(ServiceResponse<Page<ManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.list(this.client.subscriptionId(), "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedClustersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagedClusterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedClusterInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ManagedClusterInner>((Page)response.body()){

            public Page<ManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedClusterInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(String nextPageLink) {
                return ManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedClusterInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Page<ManagedClusterInner>>(){

            public Page<ManagedClusterInner> call(ServiceResponse<Page<ManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(ServiceResponse<Page<ManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedClustersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagedClusterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedClusterUpgradeProfileInner getUpgradeProfile(String resourceGroupName, String resourceName) {
        return (ManagedClusterUpgradeProfileInner)((ServiceResponse)this.getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<ManagedClusterUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName, ServiceCallback<ManagedClusterUpgradeProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ManagedClusterUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName) {
        return this.getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ManagedClusterUpgradeProfileInner>, ManagedClusterUpgradeProfileInner>(){

            public ManagedClusterUpgradeProfileInner call(ServiceResponse<ManagedClusterUpgradeProfileInner> response) {
                return (ManagedClusterUpgradeProfileInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterUpgradeProfileInner>> getUpgradeProfileWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.getUpgradeProfile(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedClusterUpgradeProfileInner>>>(){

            public Observable<ServiceResponse<ManagedClusterUpgradeProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.getUpgradeProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedClusterUpgradeProfileInner> getUpgradeProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedClusterUpgradeProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedClusterAccessProfileInner getAccessProfile(String resourceGroupName, String resourceName, String roleName) {
        return (ManagedClusterAccessProfileInner)((Object)((ServiceResponse)this.getAccessProfileWithServiceResponseAsync(resourceGroupName, resourceName, roleName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedClusterAccessProfileInner> getAccessProfileAsync(String resourceGroupName, String resourceName, String roleName, ServiceCallback<ManagedClusterAccessProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAccessProfileWithServiceResponseAsync(resourceGroupName, resourceName, roleName), serviceCallback);
    }

    public Observable<ManagedClusterAccessProfileInner> getAccessProfileAsync(String resourceGroupName, String resourceName, String roleName) {
        return this.getAccessProfileWithServiceResponseAsync(resourceGroupName, resourceName, roleName).map((Func1)new Func1<ServiceResponse<ManagedClusterAccessProfileInner>, ManagedClusterAccessProfileInner>(){

            public ManagedClusterAccessProfileInner call(ServiceResponse<ManagedClusterAccessProfileInner> response) {
                return (ManagedClusterAccessProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterAccessProfileInner>> getAccessProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, String roleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("Parameter roleName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.getAccessProfile(this.client.subscriptionId(), resourceGroupName, resourceName, roleName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedClusterAccessProfileInner>>>(){

            public Observable<ServiceResponse<ManagedClusterAccessProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.getAccessProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedClusterAccessProfileInner> getAccessProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedClusterAccessProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CredentialResultsInner listClusterAdminCredentials(String resourceGroupName, String resourceName) {
        return (CredentialResultsInner)((ServiceResponse)this.listClusterAdminCredentialsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<CredentialResultsInner> listClusterAdminCredentialsAsync(String resourceGroupName, String resourceName, ServiceCallback<CredentialResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listClusterAdminCredentialsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<CredentialResultsInner> listClusterAdminCredentialsAsync(String resourceGroupName, String resourceName) {
        return this.listClusterAdminCredentialsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<CredentialResultsInner>, CredentialResultsInner>(){

            public CredentialResultsInner call(ServiceResponse<CredentialResultsInner> response) {
                return (CredentialResultsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CredentialResultsInner>> listClusterAdminCredentialsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.listClusterAdminCredentials(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CredentialResultsInner>>>(){

            public Observable<ServiceResponse<CredentialResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.listClusterAdminCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CredentialResultsInner> listClusterAdminCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CredentialResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CredentialResultsInner listClusterUserCredentials(String resourceGroupName, String resourceName) {
        return (CredentialResultsInner)((ServiceResponse)this.listClusterUserCredentialsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<CredentialResultsInner> listClusterUserCredentialsAsync(String resourceGroupName, String resourceName, ServiceCallback<CredentialResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listClusterUserCredentialsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<CredentialResultsInner> listClusterUserCredentialsAsync(String resourceGroupName, String resourceName) {
        return this.listClusterUserCredentialsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<CredentialResultsInner>, CredentialResultsInner>(){

            public CredentialResultsInner call(ServiceResponse<CredentialResultsInner> response) {
                return (CredentialResultsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CredentialResultsInner>> listClusterUserCredentialsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.listClusterUserCredentials(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CredentialResultsInner>>>(){

            public Observable<ServiceResponse<CredentialResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.listClusterUserCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CredentialResultsInner> listClusterUserCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CredentialResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CredentialResultsInner listClusterMonitoringUserCredentials(String resourceGroupName, String resourceName) {
        return (CredentialResultsInner)((ServiceResponse)this.listClusterMonitoringUserCredentialsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<CredentialResultsInner> listClusterMonitoringUserCredentialsAsync(String resourceGroupName, String resourceName, ServiceCallback<CredentialResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listClusterMonitoringUserCredentialsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<CredentialResultsInner> listClusterMonitoringUserCredentialsAsync(String resourceGroupName, String resourceName) {
        return this.listClusterMonitoringUserCredentialsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<CredentialResultsInner>, CredentialResultsInner>(){

            public CredentialResultsInner call(ServiceResponse<CredentialResultsInner> response) {
                return (CredentialResultsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CredentialResultsInner>> listClusterMonitoringUserCredentialsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.listClusterMonitoringUserCredentials(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CredentialResultsInner>>>(){

            public Observable<ServiceResponse<CredentialResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.listClusterMonitoringUserCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CredentialResultsInner> listClusterMonitoringUserCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CredentialResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedClusterInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedClusterInner>>>(){

            public Observable<ServiceResponse<ManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedClusterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedClusterInner createOrUpdate(String resourceGroupName, String resourceName, ManagedClusterInner parameters) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, ManagedClusterInner parameters, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<ManagedClusterInner> createOrUpdateAsync(String resourceGroupName, String resourceName, ManagedClusterInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, ManagedClusterInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedClusterInner>(){}.getType());
    }

    public ManagedClusterInner beginCreateOrUpdate(String resourceGroupName, String resourceName, ManagedClusterInner parameters) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, ManagedClusterInner parameters, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<ManagedClusterInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, ManagedClusterInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, ManagedClusterInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-09-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedClusterInner>>>(){

            public Observable<ServiceResponse<ManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedClusterInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedClusterInner>(){}.getType()).register(201, new TypeToken<ManagedClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedClusterInner updateTags(String resourceGroupName, String resourceName) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedClusterInner>(){}.getType());
    }

    public ManagedClusterInner updateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    public Observable<ManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2020-09-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedClusterInner>(){}.getType());
    }

    public ManagedClusterInner beginUpdateTags(String resourceGroupName, String resourceName) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedClusterInner>>>(){

            public Observable<ServiceResponse<ManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ManagedClusterInner beginUpdateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return (ManagedClusterInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, ServiceCallback<ManagedClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    public Observable<ManagedClusterInner> beginUpdateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map((Func1)new Func1<ServiceResponse<ManagedClusterInner>, ManagedClusterInner>(){

            public ManagedClusterInner call(ServiceResponse<ManagedClusterInner> response) {
                return (ManagedClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedClusterInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2020-09-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedClusterInner>>>(){

            public Observable<ServiceResponse<ManagedClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedClusterInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resetServicePrincipalProfile(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters) {
        ((ServiceResponse)this.resetServicePrincipalProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> resetServicePrincipalProfileAsync(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetServicePrincipalProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<Void> resetServicePrincipalProfileAsync(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters) {
        return this.resetServicePrincipalProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetServicePrincipalProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.resetServicePrincipalProfile(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginResetServicePrincipalProfile(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters) {
        ((ServiceResponse)this.beginResetServicePrincipalProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginResetServicePrincipalProfileAsync(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginResetServicePrincipalProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<Void> beginResetServicePrincipalProfileAsync(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters) {
        return this.beginResetServicePrincipalProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginResetServicePrincipalProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2020-09-01";
        return this.service.beginResetServicePrincipalProfile(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginResetServicePrincipalProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginResetServicePrincipalProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resetAADProfile(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters) {
        ((ServiceResponse)this.resetAADProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> resetAADProfileAsync(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetAADProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<Void> resetAADProfileAsync(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters) {
        return this.resetAADProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resetAADProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.resetAADProfile(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginResetAADProfile(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters) {
        ((ServiceResponse)this.beginResetAADProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginResetAADProfileAsync(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginResetAADProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters), serviceCallback);
    }

    public Observable<Void> beginResetAADProfileAsync(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters) {
        return this.beginResetAADProfileWithServiceResponseAsync(resourceGroupName, resourceName, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginResetAADProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, ManagedClusterAADProfile parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2020-09-01";
        return this.service.beginResetAADProfile(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginResetAADProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginResetAADProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void rotateClusterCertificates(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.rotateClusterCertificatesWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> rotateClusterCertificatesAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.rotateClusterCertificatesWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> rotateClusterCertificatesAsync(String resourceGroupName, String resourceName) {
        return this.rotateClusterCertificatesWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> rotateClusterCertificatesWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.rotateClusterCertificates(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginRotateClusterCertificates(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.beginRotateClusterCertificatesWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginRotateClusterCertificatesAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRotateClusterCertificatesWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> beginRotateClusterCertificatesAsync(String resourceGroupName, String resourceName) {
        return this.beginRotateClusterCertificatesWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginRotateClusterCertificatesWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.beginRotateClusterCertificates(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginRotateClusterCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginRotateClusterCertificatesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void stop(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.stopWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> stopAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.stopWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> stopAsync(String resourceGroupName, String resourceName) {
        return this.stopWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> stopWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.stop(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginStop(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.beginStopWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStopAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStopWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> beginStopAsync(String resourceGroupName, String resourceName) {
        return this.beginStopWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStopWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.beginStop(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginStopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStopDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void start(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.startWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> startAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.startWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> startAsync(String resourceGroupName, String resourceName) {
        return this.startWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> startWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        Observable<Response<ResponseBody>> observable = this.service.start(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginStart(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.beginStartWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginStartAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> beginStartAsync(String resourceGroupName, String resourceName) {
        return this.beginStartWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginStartWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-09-01";
        return this.service.beginStart(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedClustersInner.this.beginStartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginStartDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedClusterInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedClusterInner>((Page)response.body()){

            public Page<ManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedClusterInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ManagedClusterInner>> serviceFuture, ListOperationCallback<ManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(String nextPageLink) {
                return ManagedClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedClusterInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Page<ManagedClusterInner>>(){

            public Page<ManagedClusterInner> call(ServiceResponse<Page<ManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(ServiceResponse<Page<ManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedClustersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagedClusterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedClusterInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedClusterInner>((Page)response.body()){

            public Page<ManagedClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedClusterInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ManagedClusterInner>> serviceFuture, ListOperationCallback<ManagedClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(String nextPageLink) {
                return ManagedClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedClusterInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Page<ManagedClusterInner>>(){

            public Page<ManagedClusterInner> call(ServiceResponse<Page<ManagedClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedClusterInner>>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(ServiceResponse<Page<ManagedClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedClusterInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedClustersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ManagedClusterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ManagedClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedClustersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerService/managedClusters")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters getUpgradeProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/upgradeProfiles/default")
        public Observable<Response<ResponseBody>> getUpgradeProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters getAccessProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/accessProfiles/{roleName}/listCredential")
        public Observable<Response<ResponseBody>> getAccessProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="roleName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters listClusterAdminCredentials"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/listClusterAdminCredential")
        public Observable<Response<ResponseBody>> listClusterAdminCredentials(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters listClusterUserCredentials"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/listClusterUserCredential")
        public Observable<Response<ResponseBody>> listClusterUserCredentials(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters listClusterMonitoringUserCredentials"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/listClusterMonitoringUserCredential")
        public Observable<Response<ResponseBody>> listClusterMonitoringUserCredentials(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ManagedClusterInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ManagedClusterInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters resetServicePrincipalProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resetServicePrincipalProfile")
        public Observable<Response<ResponseBody>> resetServicePrincipalProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ManagedClusterServicePrincipalProfile var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginResetServicePrincipalProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resetServicePrincipalProfile")
        public Observable<Response<ResponseBody>> beginResetServicePrincipalProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ManagedClusterServicePrincipalProfile var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters resetAADProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resetAADProfile")
        public Observable<Response<ResponseBody>> resetAADProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ManagedClusterAADProfile var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginResetAADProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/resetAADProfile")
        public Observable<Response<ResponseBody>> beginResetAADProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ManagedClusterAADProfile var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters rotateClusterCertificates"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/rotateClusterCertificates")
        public Observable<Response<ResponseBody>> rotateClusterCertificates(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginRotateClusterCertificates"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/rotateClusterCertificates")
        public Observable<Response<ResponseBody>> beginRotateClusterCertificates(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters stop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/stop")
        public Observable<Response<ResponseBody>> stop(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginStop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/stop")
        public Observable<Response<ResponseBody>> beginStop(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters start"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/start")
        public Observable<Response<ResponseBody>> start(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters beginStart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/start")
        public Observable<Response<ResponseBody>> beginStart(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.ManagedClusters listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

