/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerservice.AgentPoolMode;
import com.microsoft.azure.management.containerservice.AgentPoolType;
import com.microsoft.azure.management.containerservice.ContainerServiceVMSizeTypes;
import com.microsoft.azure.management.containerservice.KubernetesClusterAgentPool;
import com.microsoft.azure.management.containerservice.ManagedClusterAgentPoolProfile;
import com.microsoft.azure.management.containerservice.OSType;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.containerservice.implementation.AgentPoolInner;
import com.microsoft.azure.management.containerservice.implementation.KubernetesClusterImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ChildResourceImpl;

@LangDefinition
public class KubernetesClusterAgentPoolImpl
extends ChildResourceImpl<ManagedClusterAgentPoolProfile, KubernetesClusterImpl, OrchestratorServiceBase>
implements KubernetesClusterAgentPool,
KubernetesClusterAgentPool.Definition<KubernetesClusterImpl>,
KubernetesClusterAgentPool.Update<KubernetesClusterImpl> {
    private String subnetName;

    KubernetesClusterAgentPoolImpl(ManagedClusterAgentPoolProfile inner, KubernetesClusterImpl parent) {
        super((Object)inner, (Object)parent);
        String subnetId = inner != null ? ((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID() : null;
        this.subnetName = ResourceUtils.nameFromResourceId((String)subnetId);
    }

    public String name() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).name();
    }

    @Override
    public int count() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).count();
    }

    @Override
    public ContainerServiceVMSizeTypes vmSize() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).vmSize();
    }

    @Override
    public int osDiskSizeInGB() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).osDiskSizeGB();
    }

    @Override
    public OSType osType() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).osType();
    }

    @Override
    public AgentPoolType type() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).type();
    }

    @Override
    public String subnetName() {
        if (this.subnetName != null) {
            return this.subnetName;
        }
        return ResourceUtils.nameFromResourceId((String)((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID());
    }

    @Override
    public String networkId() {
        String subnetId = this.inner() != null ? ((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID() : null;
        return subnetId != null ? ResourceUtils.parentResourceIdFromResourceId((String)subnetId) : null;
    }

    @Override
    public AgentPoolMode mode() {
        return ((ManagedClusterAgentPoolProfile)this.inner()).mode();
    }

    public KubernetesClusterAgentPoolImpl withVirtualMachineSize(ContainerServiceVMSizeTypes param0) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withVmSize(param0);
        if (((ManagedClusterAgentPoolProfile)this.inner()).count() == null) {
            ((ManagedClusterAgentPoolProfile)this.inner()).withCount(1);
        }
        return this;
    }

    public KubernetesClusterAgentPoolImpl withOSType(OSType osType) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withOsType(osType);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withOSDiskSizeInGB(int osDiskSizeInGB) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withOsDiskSizeGB(osDiskSizeInGB);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolType(AgentPoolType agentPoolType) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withType(agentPoolType);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolTypeName(String agentPoolTypeName) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withType(AgentPoolType.fromString(agentPoolTypeName));
        return this;
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolVirtualMachineCount(int count) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withCount(count);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withMaxPodsCount(int podsCount) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withMaxPods(podsCount);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withVirtualNetwork(String virtualNetworkId, String subnetName) {
        String vnetSubnetId = virtualNetworkId + "/subnets/" + subnetName;
        this.subnetName = subnetName;
        ((ManagedClusterAgentPoolProfile)this.inner()).withVnetSubnetID(vnetSubnetId);
        return this;
    }

    public KubernetesClusterAgentPoolImpl withMode(AgentPoolMode mode) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withMode(mode);
        return this;
    }

    public KubernetesClusterImpl attach() {
        return ((KubernetesClusterImpl)this.parent()).addNewAgentPool(this);
    }

    public KubernetesClusterAgentPoolImpl withAgentPoolMode(AgentPoolMode agentPoolMode) {
        ((ManagedClusterAgentPoolProfile)this.inner()).withMode(agentPoolMode);
        return this;
    }

    AgentPoolInner getAgentPoolInner() {
        AgentPoolInner agentPoolInner = new AgentPoolInner();
        agentPoolInner.withCount(((ManagedClusterAgentPoolProfile)this.inner()).count());
        agentPoolInner.withVmSize(((ManagedClusterAgentPoolProfile)this.inner()).vmSize());
        agentPoolInner.withOsDiskSizeGB(((ManagedClusterAgentPoolProfile)this.inner()).osDiskSizeGB());
        agentPoolInner.withVnetSubnetID(((ManagedClusterAgentPoolProfile)this.inner()).vnetSubnetID());
        agentPoolInner.withMaxPods(((ManagedClusterAgentPoolProfile)this.inner()).maxPods());
        agentPoolInner.withOsType(((ManagedClusterAgentPoolProfile)this.inner()).osType());
        agentPoolInner.withMaxCount(((ManagedClusterAgentPoolProfile)this.inner()).maxCount());
        agentPoolInner.withMinCount(((ManagedClusterAgentPoolProfile)this.inner()).minCount());
        agentPoolInner.withEnableAutoScaling(((ManagedClusterAgentPoolProfile)this.inner()).enableAutoScaling());
        agentPoolInner.withAgentPoolType(((ManagedClusterAgentPoolProfile)this.inner()).type());
        agentPoolInner.withMode(((ManagedClusterAgentPoolProfile)this.inner()).mode());
        agentPoolInner.withOrchestratorVersion(((ManagedClusterAgentPoolProfile)this.inner()).orchestratorVersion());
        agentPoolInner.withUpgradeSettings(((ManagedClusterAgentPoolProfile)this.inner()).upgradeSettings());
        agentPoolInner.withAvailabilityZones(((ManagedClusterAgentPoolProfile)this.inner()).availabilityZones());
        agentPoolInner.withEnableNodePublicIP(((ManagedClusterAgentPoolProfile)this.inner()).enableNodePublicIP());
        agentPoolInner.withScaleSetPriority(((ManagedClusterAgentPoolProfile)this.inner()).scaleSetPriority());
        agentPoolInner.withScaleSetEvictionPolicy(((ManagedClusterAgentPoolProfile)this.inner()).scaleSetEvictionPolicy());
        agentPoolInner.withSpotMaxPrice(((ManagedClusterAgentPoolProfile)this.inner()).spotMaxPrice());
        agentPoolInner.withTags(((ManagedClusterAgentPoolProfile)this.inner()).tags());
        agentPoolInner.withNodeLabels(((ManagedClusterAgentPoolProfile)this.inner()).nodeLabels());
        agentPoolInner.withNodeTaints(((ManagedClusterAgentPoolProfile)this.inner()).nodeTaints());
        agentPoolInner.withProximityPlacementGroupID(((ManagedClusterAgentPoolProfile)this.inner()).proximityPlacementGroupID());
        return agentPoolInner;
    }
}

