/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.CorsRules;
import com.microsoft.azure.management.storage.implementation.ListQueueServicesInner;
import com.microsoft.azure.management.storage.implementation.QueueServicePropertiesInner;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class QueueServicesInner {
    private QueueServicesService service;
    private StorageManagementClientImpl client;

    public QueueServicesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (QueueServicesService)retrofit.create(QueueServicesService.class);
        this.client = client;
    }

    public ListQueueServicesInner list(String resourceGroupName, String accountName) {
        return (ListQueueServicesInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<ListQueueServicesInner> listAsync(String resourceGroupName, String accountName, ServiceCallback<ListQueueServicesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<ListQueueServicesInner> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<ListQueueServicesInner>, ListQueueServicesInner>(){

            public ListQueueServicesInner call(ServiceResponse<ListQueueServicesInner> response) {
                return (ListQueueServicesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ListQueueServicesInner>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ListQueueServicesInner>>>(){

            public Observable<ServiceResponse<ListQueueServicesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueueServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ListQueueServicesInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ListQueueServicesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public QueueServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName) {
        return (QueueServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<QueueServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<QueueServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<QueueServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<QueueServicePropertiesInner>, QueueServicePropertiesInner>(){

            public QueueServicePropertiesInner call(ServiceResponse<QueueServicePropertiesInner> response) {
                return (QueueServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<QueueServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String queueServiceName = "default";
        Object cors = null;
        QueueServicePropertiesInner parameters = new QueueServicePropertiesInner();
        parameters.withCors(null);
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueueServicePropertiesInner>>>(){

            public Observable<ServiceResponse<QueueServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueueServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public QueueServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName, CorsRules cors) {
        return (QueueServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors).toBlocking().single()).body());
    }

    public ServiceFuture<QueueServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors, ServiceCallback<QueueServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors), serviceCallback);
    }

    public Observable<QueueServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, CorsRules cors) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, cors).map((Func1)new Func1<ServiceResponse<QueueServicePropertiesInner>, QueueServicePropertiesInner>(){

            public QueueServicePropertiesInner call(ServiceResponse<QueueServicePropertiesInner> response) {
                return (QueueServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<QueueServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName, CorsRules cors) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)cors);
        String queueServiceName = "default";
        QueueServicePropertiesInner parameters = new QueueServicePropertiesInner();
        parameters.withCors(cors);
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueueServicePropertiesInner>>>(){

            public Observable<ServiceResponse<QueueServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueueServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<QueueServicePropertiesInner> setServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<QueueServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public QueueServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName) {
        return (QueueServicePropertiesInner)((Object)((ServiceResponse)this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<QueueServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<QueueServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<QueueServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<QueueServicePropertiesInner>, QueueServicePropertiesInner>(){

            public QueueServicePropertiesInner call(ServiceResponse<QueueServicePropertiesInner> response) {
                return (QueueServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<QueueServicePropertiesInner>> getServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String queueServiceName = "default";
        return this.service.getServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueueServicePropertiesInner>>>(){

            public Observable<ServiceResponse<QueueServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueueServicesInner.this.getServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<QueueServicePropertiesInner> getServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<QueueServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface QueueServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.QueueServices list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.QueueServices setServiceProperties"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/{queueServiceName}")
        public Observable<Response<ResponseBody>> setServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="queueServiceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body QueueServicePropertiesInner var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.QueueServices getServiceProperties"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/{queueServiceName}")
        public Observable<Response<ResponseBody>> getServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="queueServiceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

