/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.storage.ErrorResponseException;
import com.microsoft.azure.management.storage.implementation.EncryptionScopeInner;
import com.microsoft.azure.management.storage.implementation.PageImpl1;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class EncryptionScopesInner {
    private EncryptionScopesService service;
    private StorageManagementClientImpl client;

    public EncryptionScopesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (EncryptionScopesService)retrofit.create(EncryptionScopesService.class);
        this.client = client;
    }

    public EncryptionScopeInner put(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return (EncryptionScopeInner)((Object)((ServiceResponse)this.putWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).toBlocking().single()).body());
    }

    public ServiceFuture<EncryptionScopeInner> putAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, ServiceCallback<EncryptionScopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.putWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope), serviceCallback);
    }

    public Observable<EncryptionScopeInner> putAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return this.putWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).map((Func1)new Func1<ServiceResponse<EncryptionScopeInner>, EncryptionScopeInner>(){

            public EncryptionScopeInner call(ServiceResponse<EncryptionScopeInner> response) {
                return (EncryptionScopeInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EncryptionScopeInner>> putWithServiceResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (encryptionScopeName == null) {
            throw new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (encryptionScope == null) {
            throw new IllegalArgumentException("Parameter encryptionScope is required and cannot be null.");
        }
        Validator.validate((Object)((Object)encryptionScope));
        return this.service.put(resourceGroupName, accountName, this.client.subscriptionId(), encryptionScopeName, this.client.apiVersion(), encryptionScope, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionScopeInner>>>(){

            public Observable<ServiceResponse<EncryptionScopeInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EncryptionScopesInner.this.putDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EncryptionScopeInner> putDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EncryptionScopeInner>(){}.getType()).register(201, new TypeToken<EncryptionScopeInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EncryptionScopeInner patch(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return (EncryptionScopeInner)((Object)((ServiceResponse)this.patchWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).toBlocking().single()).body());
    }

    public ServiceFuture<EncryptionScopeInner> patchAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope, ServiceCallback<EncryptionScopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.patchWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope), serviceCallback);
    }

    public Observable<EncryptionScopeInner> patchAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        return this.patchWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName, encryptionScope).map((Func1)new Func1<ServiceResponse<EncryptionScopeInner>, EncryptionScopeInner>(){

            public EncryptionScopeInner call(ServiceResponse<EncryptionScopeInner> response) {
                return (EncryptionScopeInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EncryptionScopeInner>> patchWithServiceResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName, EncryptionScopeInner encryptionScope) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (encryptionScopeName == null) {
            throw new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (encryptionScope == null) {
            throw new IllegalArgumentException("Parameter encryptionScope is required and cannot be null.");
        }
        Validator.validate((Object)((Object)encryptionScope));
        return this.service.patch(resourceGroupName, accountName, this.client.subscriptionId(), encryptionScopeName, this.client.apiVersion(), encryptionScope, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionScopeInner>>>(){

            public Observable<ServiceResponse<EncryptionScopeInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EncryptionScopesInner.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EncryptionScopeInner> patchDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EncryptionScopeInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EncryptionScopeInner get(String resourceGroupName, String accountName, String encryptionScopeName) {
        return (EncryptionScopeInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName).toBlocking().single()).body());
    }

    public ServiceFuture<EncryptionScopeInner> getAsync(String resourceGroupName, String accountName, String encryptionScopeName, ServiceCallback<EncryptionScopeInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName), serviceCallback);
    }

    public Observable<EncryptionScopeInner> getAsync(String resourceGroupName, String accountName, String encryptionScopeName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, encryptionScopeName).map((Func1)new Func1<ServiceResponse<EncryptionScopeInner>, EncryptionScopeInner>(){

            public EncryptionScopeInner call(ServiceResponse<EncryptionScopeInner> response) {
                return (EncryptionScopeInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EncryptionScopeInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String encryptionScopeName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (encryptionScopeName == null) {
            throw new IllegalArgumentException("Parameter encryptionScopeName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, this.client.subscriptionId(), encryptionScopeName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EncryptionScopeInner>>>(){

            public Observable<ServiceResponse<EncryptionScopeInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EncryptionScopesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EncryptionScopeInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EncryptionScopeInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EncryptionScopeInner> list(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<EncryptionScopeInner>((Page)response.body()){

            public Page<EncryptionScopeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EncryptionScopesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EncryptionScopeInner>> listAsync(String resourceGroupName, String accountName, ListOperationCallback<EncryptionScopeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(String nextPageLink) {
                return EncryptionScopesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EncryptionScopeInner>> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Page<EncryptionScopeInner>>(){

            public Page<EncryptionScopeInner> call(ServiceResponse<Page<EncryptionScopeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(ServiceResponse<Page<EncryptionScopeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EncryptionScopesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listSinglePageAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EncryptionScopesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<EncryptionScopeInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<EncryptionScopeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<EncryptionScopeInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EncryptionScopeInner>((Page)response.body()){

            public Page<EncryptionScopeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EncryptionScopesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EncryptionScopeInner>> listNextAsync(String nextPageLink, ServiceFuture<List<EncryptionScopeInner>> serviceFuture, ListOperationCallback<EncryptionScopeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(String nextPageLink) {
                return EncryptionScopesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EncryptionScopeInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Page<EncryptionScopeInner>>(){

            public Page<EncryptionScopeInner> call(ServiceResponse<Page<EncryptionScopeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EncryptionScopeInner>>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(ServiceResponse<Page<EncryptionScopeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EncryptionScopesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EncryptionScopeInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EncryptionScopeInner>>>>(){

            public Observable<ServiceResponse<Page<EncryptionScopeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EncryptionScopesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<EncryptionScopeInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<EncryptionScopeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface EncryptionScopesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes put"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        public Observable<Response<ResponseBody>> put(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="encryptionScopeName") String var4, @Query(value="api-version") String var5, @Body EncryptionScopeInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes patch"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        public Observable<Response<ResponseBody>> patch(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="encryptionScopeName") String var4, @Query(value="api-version") String var5, @Body EncryptionScopeInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="encryptionScopeName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.EncryptionScopes listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

