/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.storage.implementation.BlobServicePropertiesInner;
import com.microsoft.azure.management.storage.implementation.PageImpl;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class BlobServicesInner {
    private BlobServicesService service;
    private StorageManagementClientImpl client;

    public BlobServicesInner(Retrofit retrofit, StorageManagementClientImpl client) {
        this.service = (BlobServicesService)retrofit.create(BlobServicesService.class);
        this.client = client;
    }

    public List<BlobServicePropertiesInner> list(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<BlobServicePropertiesInner>> listAsync(String resourceGroupName, String accountName, ServiceCallback<List<BlobServicePropertiesInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<BlobServicePropertiesInner>> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<BlobServicePropertiesInner>>, List<BlobServicePropertiesInner>>(){

            public List<BlobServicePropertiesInner> call(ServiceResponse<List<BlobServicePropertiesInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<BlobServicePropertiesInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<BlobServicePropertiesInner>>>>(){

            public Observable<ServiceResponse<List<BlobServicePropertiesInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BlobServicesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BlobServicePropertiesInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<BlobServicePropertiesInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BlobServicePropertiesInner setServiceProperties(String resourceGroupName, String accountName, BlobServicePropertiesInner parameters) {
        return (BlobServicePropertiesInner)((Object)((ServiceResponse)this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<BlobServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, BlobServicePropertiesInner parameters, ServiceCallback<BlobServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<BlobServicePropertiesInner> setServicePropertiesAsync(String resourceGroupName, String accountName, BlobServicePropertiesInner parameters) {
        return this.setServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<BlobServicePropertiesInner>, BlobServicePropertiesInner>(){

            public BlobServicePropertiesInner call(ServiceResponse<BlobServicePropertiesInner> response) {
                return (BlobServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobServicePropertiesInner>> setServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName, BlobServicePropertiesInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String blobServicesName = "default";
        return this.service.setServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobServicePropertiesInner>>>(){

            public Observable<ServiceResponse<BlobServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobServicesInner.this.setServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BlobServicePropertiesInner> setServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BlobServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BlobServicePropertiesInner getServiceProperties(String resourceGroupName, String accountName) {
        return (BlobServicePropertiesInner)((Object)((ServiceResponse)this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body());
    }

    public ServiceFuture<BlobServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName, ServiceCallback<BlobServicePropertiesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<BlobServicePropertiesInner> getServicePropertiesAsync(String resourceGroupName, String accountName) {
        return this.getServicePropertiesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<BlobServicePropertiesInner>, BlobServicePropertiesInner>(){

            public BlobServicePropertiesInner call(ServiceResponse<BlobServicePropertiesInner> response) {
                return (BlobServicePropertiesInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<BlobServicePropertiesInner>> getServicePropertiesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String blobServicesName = "default";
        return this.service.getServiceProperties(resourceGroupName, accountName, this.client.subscriptionId(), "default", this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BlobServicePropertiesInner>>>(){

            public Observable<ServiceResponse<BlobServicePropertiesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BlobServicesInner.this.getServicePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BlobServicePropertiesInner> getServicePropertiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BlobServicePropertiesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BlobServicesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobServices list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobServices setServiceProperties"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/{BlobServicesName}")
        public Observable<Response<ResponseBody>> setServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="BlobServicesName") String var4, @Query(value="api-version") String var5, @Body BlobServicePropertiesInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.storage.BlobServices getServiceProperties"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/{BlobServicesName}")
        public Observable<Response<ResponseBody>> getServiceProperties(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Path(value="BlobServicesName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

