/*
 * Decompiled with CFR 0.152.
 */
package mergetool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MergeProperties {
    public static void main(String[] stringArray) throws IOException {
        MergeProperties mergeProperties = new MergeProperties();
        mergeProperties.mergeNewUrlstoPropertiesFile(stringArray);
    }

    private void mergeNewUrlstoPropertiesFile(String[] stringArray) {
        try {
            int n = stringArray.length;
            String[] stringArray2 = new String[4];
            for (int i = 0; i < n && i < 4; ++i) {
                stringArray2[i] = stringArray[i];
            }
            this.mergeNewUrlstoPropertiesFile(stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mergeNewUrlstoPropertiesFile(String string, String string2, String string3, String string4) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        File file = null;
        boolean bl = false;
        String string5 = "";
        try {
            Object object;
            Serializable serializable;
            Comparable<Date> comparable;
            CharSequence charSequence;
            if (string4 == null || string4.equalsIgnoreCase("null") || string4.length() == 0) {
                charSequence = System.getProperty("user.dir");
                if (charSequence == null) return;
                if (((String)charSequence).equalsIgnoreCase("null")) return;
                if (((String)charSequence).length() == 0) {
                    return;
                }
                File file2 = new File((String)charSequence);
                if (!file2.isDirectory()) {
                    return;
                }
                comparable = new Date();
                serializable = new SimpleDateFormat("yyyy-MM-dd");
                object = ((DateFormat)serializable).format((Date)comparable);
                String string6 = File.separator;
                string4 = (String)charSequence + string6 + "PropertiesFileMerge-" + (String)object + ".log";
            }
            outputStreamWriter = new FileWriter(string4, true);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            string5 = "The name of the log file is:" + string4;
            this.writeLogMessage(string5, bufferedWriter);
            charSequence = new StringBuilder();
            boolean bl2 = this.checkParametersPassedProperlyOrNot(string, string2, string3, (StringBuilder)charSequence, bufferedWriter);
            if (!bl2) {
                string5 = "The files names have not been passed correctly. Hence, not proceeding further and returning from the method.";
                this.writeLogMessage(string5, bufferedWriter);
                return;
            }
            comparable = new File(string);
            serializable = new File(string2);
            if (((StringBuilder)charSequence).length() > 0) {
                string3 = ((StringBuilder)charSequence).toString();
            }
            if (!((File)serializable).exists() || ((File)serializable).length() == 0L) {
                string5 = "The properties file with new urls does not exist or it is empty with 0 bytes. Hence, not processing further and returning from method.";
                this.writeLogMessage(string5, bufferedWriter);
                return;
            }
            object = this.loadPropertiesFile(string2, bufferedWriter);
            if (object == null || ((Properties)object).isEmpty()) {
                string5 = "The properties ( key-value pairs ) are not present in the file with new urls or not loaded properly.";
                this.writeLogMessage(string5, bufferedWriter);
                return;
            }
            boolean bl3 = true;
            if (!((File)comparable).exists()) {
                bl3 = false;
                string5 = "The properties file does not exist in the product. Hence, copying the content from file with new urls.";
                this.writeLogMessage(string5, bufferedWriter);
                this.copyContentFromNewUrlsFileToPropertiesFile((File)comparable, (Properties)object, bufferedWriter, bl3);
                return;
            }
            if (((File)comparable).length() == 0L) {
                string5 = "The properties file exists in the product but it is empty with 0 bytes. Hence, copying the content from file with new urls.";
                this.writeLogMessage(string5, bufferedWriter);
                this.copyContentFromNewUrlsFileToPropertiesFile((File)comparable, (Properties)object, bufferedWriter, bl3);
                return;
            }
            if (!((File)comparable).canWrite()) {
                string5 = "The propertiesfile in the product has no write permission. Hence not updating the file with new urls.";
                this.writeLogMessage(string5, bufferedWriter);
                return;
            }
            bl = this.copyTheContentToBackUpFile((File)comparable, string3, bufferedWriter);
            file = new File(string3);
            Properties properties = this.loadPropertiesFile(string, bufferedWriter);
            if (properties == null || properties.isEmpty()) {
                string5 = "The properties ( key-value pairs ) are not present in the current properties file in product or they have not loaded properly.";
                this.writeLogMessage(string5, bufferedWriter);
                return;
            }
            boolean bl4 = this.updatePropertiesFileWithNewUrls((File)comparable, file, properties, (Properties)object, bufferedWriter);
            if (!bl4 && bl) {
                string5 = "The properties file updation with the new urls got failed. As there is a back up copy of it, copying the content from the backup file to the properties file.";
                this.writeLogMessage(string5, bufferedWriter);
                if (file.exists() && file.length() > 0L) {
                    bl4 = this.copyContentFromBackupFileToPropertiesFile((File)comparable, file, bufferedWriter);
                }
            }
            if (!bl4) return;
            this.deleteFile(string3, file, bufferedWriter);
            this.deleteFile(string2, (File)serializable, bufferedWriter);
            return;
        }
        catch (Exception exception) {
            if (bufferedWriter == null) return;
            string5 = "Method mergeNewUrlstoPropertiesFile. Exception that occurred while processing the properties file updation process is:" + exception.getMessage();
            this.writeLogMessage(string5, bufferedWriter);
            return;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void deleteFile(String string, File file, BufferedWriter bufferedWriter) throws IOException {
        String string2 = "";
        try {
            if (file.exists()) {
                boolean bl = file.delete();
                if (bl) {
                    string2 = "File:" + string + " is deleted successfully.";
                    this.writeLogMessage(string2, bufferedWriter);
                } else {
                    string2 = "Failed to delete the file:" + string;
                    this.writeLogMessage(string2, bufferedWriter);
                }
                return;
            }
            string2 = "The file:" + string + " does not exists.";
            this.writeLogMessage(string2, bufferedWriter);
        }
        catch (Exception exception) {
            string2 = "Method: deleteFile. Exception that occurred while deleting the file:" + string + " is:" + exception.getMessage();
            this.writeLogMessage(string2, bufferedWriter);
        }
    }

    private void copyContentFromNewUrlsFileToPropertiesFile(File file, Properties properties, BufferedWriter bufferedWriter, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = null;
        String string = "";
        try {
            string = "Method copyContentFromNewUrlsFileToPropertiesFile to copy the content from the file with new urls to the properties file in product.";
            this.writeLogMessage(string, bufferedWriter);
            if (!bl) {
                boolean bl2 = file.createNewFile();
                if (!bl2) {
                    string = "Method copyContentFromNewUrlsFileToPropertiesFile. The properties file creation failed.";
                    this.writeLogMessage(string, bufferedWriter);
                    return;
                }
                string = "properties file created successfully.";
                this.writeLogMessage(string, bufferedWriter);
            }
            fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "Saving Registration details");
            fileOutputStream.close();
            if (file.length() == 0L) {
                string = "Copying the content from the file with new urls to the properties file failed.";
                this.writeLogMessage(string, bufferedWriter);
            } else {
                string = "Successfully updated the properties file with the content in the files with new urls.";
                this.writeLogMessage(string, bufferedWriter);
            }
        }
        catch (Exception exception) {
            string = "Method copyContentFromNewUrlsFileToPropertiesFile. Copying content from the file with new urls to the properties file in product failed due to exception:" + exception.getMessage();
            this.writeLogMessage(string, bufferedWriter);
        }
    }

    private boolean updatePropertiesFileWithNewUrls(File file, File file2, Properties properties, Properties properties2, BufferedWriter bufferedWriter) throws IOException {
        boolean bl;
        block16: {
            bl = false;
            boolean bl2 = false;
            FileOutputStream fileOutputStream = null;
            String string = "";
            try {
                String string2;
                Object object;
                String string3 = "SERVERNAME,REQUEST_PROTOCOL,PORTNUMBER,AERP_CLIENTCERTIFICATE,ISUPLOAD_TOCLOUD,AERP_WEBSERVICE_RETRYTIME,OFFLINE_ACTIVATION_URL,OFFLINE_DEACTIVATION_URL";
                String string4 = "REQUEST_PROTOCOL,PORTNUMBER,AERP_CLIENTCERTIFICATE,ISUPLOAD_TOCLOUD,AERP_WEBSERVICE_RETRYTIME";
                Set set = Stream.of(string3.trim().split(",")).collect(Collectors.toSet());
                Set set2 = Stream.of(string4.trim().split(",")).collect(Collectors.toSet());
                String string5 = System.getProperty("line.separator");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("The following keys and values are NULL/EMPTY. Hence, ignoring them.");
                boolean bl3 = false;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (Map.Entry<Object, Object> object22 : properties2.entrySet()) {
                    object = object22.getKey();
                    Iterator iterator = object22.getValue();
                    Map.Entry entry = String.valueOf(object);
                    string2 = String.valueOf(iterator);
                    if (!this.isValueProper((String)((Object)entry), bufferedWriter)) {
                        bl3 = true;
                        stringBuilder.append(string5);
                        stringBuilder.append("Found values as NULL/EMPTY for the key. The key value is:" + entry + " Hence, ignoring this.");
                        continue;
                    }
                    if (!this.isValueProper(string2, bufferedWriter)) {
                        bl3 = true;
                        stringBuilder.append(string5);
                        stringBuilder.append("For the key:" + entry + " the value is NULL/EMPTY. The value retrieved is:" + string2 + " Hence, ignorning this.");
                        continue;
                    }
                    bl2 = true;
                    hashMap.put((String)((Object)entry), string2);
                }
                if (bl3) {
                    this.writeLogMessage(stringBuilder.toString(), bufferedWriter);
                }
                if (!bl2) {
                    string = "Not updating the properties file as no proper key/values found in the file with new URLs.";
                    this.writeLogMessage(string, bufferedWriter);
                    bl = true;
                    return bl;
                }
                boolean bl4 = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                object = this.getOSType(bufferedWriter);
                bl2 = false;
                if (((String)object).equals("LINUX")) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        string2 = (String)entry.getKey();
                        String string7 = (String)entry.getValue();
                        if (!properties.containsKey(string2)) {
                            bl4 = true;
                            bl2 = true;
                            stringBuilder2.append("The Key:" + string2 + " is not present in the current properties file. Adding it with the value:" + string7);
                            stringBuilder2.append(string5);
                            properties.setProperty(string2, string7);
                            continue;
                        }
                        if (set2.contains(string2)) continue;
                        bl2 = true;
                        properties.setProperty(string2, string7);
                    }
                } else {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        string2 = (String)entry.getKey();
                        String string6 = (String)entry.getValue();
                        if (!properties.containsKey(string2)) {
                            bl4 = true;
                            bl2 = true;
                            stringBuilder2.append("The Key:" + string2 + " is not present in the current properties file. Adding it with the value:" + string6);
                            stringBuilder2.append(string5);
                            properties.setProperty(string2, string6);
                            continue;
                        }
                        if (set.contains(string2)) continue;
                        bl2 = true;
                        properties.setProperty(string2, string6);
                    }
                }
                if (bl4) {
                    this.writeLogMessage(stringBuilder2.toString(), bufferedWriter);
                }
                if (!bl2) {
                    string = "Not updating the properties file as all the fields present in the properties file with new urls are the ones whos values should not be changed.";
                    this.writeLogMessage(string, bufferedWriter);
                    bl = true;
                    return bl;
                }
                fileOutputStream = new FileOutputStream(file);
                properties.store(fileOutputStream, "Saving Registration details");
                fileOutputStream.close();
                string = "The properties file updated successfully with new urls.";
                this.writeLogMessage(string, bufferedWriter);
                bl = true;
            }
            catch (Exception exception) {
                if (bufferedWriter != null) {
                    string = "Exception:" + exception.getMessage() + " occurred while updating the properties file with new urls.";
                    this.writeLogMessage(string, bufferedWriter);
                }
                if (!file.exists() || fileOutputStream == null) break block16;
                fileOutputStream.close();
            }
        }
        return bl;
    }

    private Properties loadPropertiesFile(String string, BufferedWriter bufferedWriter) throws IOException {
        Properties properties = null;
        String string2 = "";
        try {
            string2 = "Method loadPropertiesFile to load the key value pairs in the file:" + string;
            this.writeLogMessage(string2, bufferedWriter);
            FileInputStream fileInputStream = new FileInputStream(string);
            properties = new Properties();
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            string2 = "Method loadPropertiesFile. Exception occurred while loading the key value pairs from the file:" + string + exception.getMessage();
            this.writeLogMessage(string2, bufferedWriter);
        }
        return properties;
    }

    private boolean checkParametersPassedProperlyOrNot(String string, String string2, String string3, StringBuilder stringBuilder, BufferedWriter bufferedWriter) throws IOException {
        boolean bl = true;
        String string4 = "";
        try {
            if (!this.isValueProper(string, bufferedWriter)) {
                bl = false;
                string4 = "The parameter for the current properties file in the product has not been passed properly. The value passed is:" + string;
                this.writeLogMessage(string4, bufferedWriter);
                return bl;
            }
            if (!this.isValueProper(string2, bufferedWriter)) {
                bl = false;
                string4 = "The parameter for the properties file with new urls has not been passed properly. The value passed is:" + string2;
                this.writeLogMessage(string4, bufferedWriter);
                return bl;
            }
            if (!this.isValueProper(string3, bufferedWriter)) {
                bl = false;
                String string5 = System.getProperty("user.dir");
                if (!this.isValueProper(string5, bufferedWriter)) {
                    string4 = "The parameter for the back up file has not been passed properly and the directory where the application is running is also not retrieved properly.";
                    this.writeLogMessage(string4, bufferedWriter);
                    return bl;
                }
                File file = new File(string5);
                if (!file.isDirectory()) {
                    return bl;
                }
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String string6 = simpleDateFormat.format(date);
                String string7 = File.separator;
                string3 = string5 + string7 + "PropertiesFile-" + string6 + ".bak";
                File file2 = new File(string3);
                boolean bl2 = file2.createNewFile();
                if (!bl2) {
                    string4 = "The back up file parameter has not been passed properly and also creation of the file in the directory where the application is running also failed.";
                    this.writeLogMessage(string4, bufferedWriter);
                    return bl;
                }
                bl = true;
                stringBuilder.append(string3);
                string4 = "The backup file parameter has not been passed properly. Hence created a new file in the directory where application is running. The file name is:" + string3;
                this.writeLogMessage(string4, bufferedWriter);
            }
        }
        catch (Exception exception) {
            string4 = "Method checkParametersPassedProperlyOrNot. Exception occurred is:" + exception.getMessage();
            this.writeLogMessage(string4, bufferedWriter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyContentFromBackupFileToPropertiesFile(File file, File file2, BufferedWriter bufferedWriter) throws IOException {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = null;
        boolean bl = false;
        String string = "";
        try {
            boolean bl2;
            string = "In the method copyContentFromBackupFileToPropertiesFile to copy the content from bak file to properties file.";
            this.writeLogMessage(string, bufferedWriter);
            if (!file.exists()) {
                string = "The properties file does not exists. Hence creating it and copying the content from bak file.";
                this.writeLogMessage(string, bufferedWriter);
                bl2 = file.createNewFile();
                if (!bl2) {
                    string = "In the method copyContentFromBackupFileToPropertiesFile. The properties file creation failed.";
                    this.writeLogMessage(string, bufferedWriter);
                    boolean bl3 = bl;
                    return bl3;
                }
            }
            if (!file2.exists() || file2.length() == 0L) {
                string = "The back up copy of the properties file does not exist or is empty with 0 bytes.";
                this.writeLogMessage(string, bufferedWriter);
                bl2 = bl;
                return bl2;
            }
            fileInputStream = new FileInputStream(file2);
            fileOutputStream = new FileOutputStream(file);
            abstractInterruptibleChannel = fileOutputStream.getChannel();
            abstractInterruptibleChannel2 = fileInputStream.getChannel();
            ((FileChannel)abstractInterruptibleChannel2).transferTo(0L, ((FileChannel)abstractInterruptibleChannel2).size(), (WritableByteChannel)((Object)abstractInterruptibleChannel));
            long l = file.length();
            long l2 = file2.length();
            if (Long.compare(l, l2) == 0) {
                bl = true;
                string = "Successfully copied the content from bak file to properties file.";
                this.writeLogMessage(string, bufferedWriter);
            }
        }
        catch (Exception exception) {
            string = "In the method copyContentFromBackupFileToPropertiesFile. Exception:" + exception.getMessage() + " occurred while copying the content from backup file to properties file.";
            this.writeLogMessage(string, bufferedWriter);
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                if (abstractInterruptibleChannel2 != null) {
                    abstractInterruptibleChannel2.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                string = "Exception:" + exception.getMessage() + " occurred while closing the channels and streams of properties file and bak file.";
                this.writeLogMessage(string, bufferedWriter);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyTheContentToBackUpFile(File file, String string, BufferedWriter bufferedWriter) throws IOException {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        String string2 = "";
        try {
            boolean bl2;
            string2 = "Method copyTheContentToBackUpFile to copy the content from properties file to backup file.";
            this.writeLogMessage(string2, bufferedWriter);
            File file2 = new File(string);
            if (!file2.exists() && !(bl2 = file2.createNewFile())) {
                string2 = "Creating the backup file PropertiesFile.bak failed.";
                this.writeLogMessage(string2, bufferedWriter);
                boolean bl3 = bl;
                return bl3;
            }
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(string);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            abstractInterruptibleChannel2 = fileOutputStream.getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferTo(0L, ((FileChannel)abstractInterruptibleChannel).size(), (WritableByteChannel)((Object)abstractInterruptibleChannel2));
            long l = file.length();
            long l2 = file.length();
            if (Long.compare(l, l2) == 0) {
                bl = true;
                string2 = "Successfully copied the content from properties file to backup file.";
                this.writeLogMessage(string2, bufferedWriter);
            }
        }
        catch (Exception exception) {
            string2 = "In the method copyTheContentToBackUpFile. Exception:" + exception.getMessage() + " occurred while copying the content from properties file to back file.";
            this.writeLogMessage(string2, bufferedWriter);
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                if (abstractInterruptibleChannel2 != null) {
                    abstractInterruptibleChannel2.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                string2 = "Exception:" + exception.getMessage() + " occurred while closing the channels and streams of properties file and bak file.";
                this.writeLogMessage(string2, bufferedWriter);
            }
        }
        return bl;
    }

    private boolean isValueProper(String string, BufferedWriter bufferedWriter) throws IOException {
        boolean bl = false;
        try {
            if (string == null) {
                return bl;
            }
            if (string.equalsIgnoreCase("null")) {
                return bl;
            }
            if (string.isEmpty()) {
                return bl;
            }
            bl = true;
        }
        catch (Exception exception) {
            String string2 = "Exception:" + exception.getMessage() + " occurred while checking whether the value:" + string + " is NULL/EMPTY.";
            this.writeLogMessage(string2, bufferedWriter);
        }
        return bl;
    }

    private void writeLogMessage(String string, BufferedWriter bufferedWriter) throws IOException {
        block3: {
            try {
                if (bufferedWriter != null) {
                    Date date = new Date();
                    String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(date);
                    string = string2 + ":" + string;
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
            }
            catch (Exception exception) {
                if (bufferedWriter == null) break block3;
                Date date = new Date();
                String string3 = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss.SSS").format(date);
                String string4 = string3 + ".Exception:" + exception.getMessage() + " occurred while logging the message:" + string;
                bufferedWriter.write(string4);
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
        }
    }

    private String getOSType(BufferedWriter bufferedWriter) throws IOException {
        String string = "WINDOWS";
        String string2 = "";
        try {
            String string3 = System.getProperty("os.name").toLowerCase();
            if (!this.isValueProper(string3, bufferedWriter)) {
                string2 = "The Operating System value is received as NULL/EMPTY. Hence, returning the default value Windows. The value received is:" + string3;
                this.writeLogMessage(string2, bufferedWriter);
                return string;
            }
            if (string3.indexOf("win") >= 0) {
                string2 = "Windows machine. Operating System is:" + string3;
                this.writeLogMessage(string2, bufferedWriter);
                string = "WINDOWS";
            } else if (string3.indexOf("nix") >= 0 || string3.indexOf("nux") >= 0 || string3.indexOf("aix") > 0) {
                string2 = "Linux machine. Operating System is:" + string3;
                this.writeLogMessage(string2, bufferedWriter);
                string = "LINUX";
            } else {
                string2 = "The operating System is neither Windows nor Linux. Hence, returning default value Windows. The value received is:" + string3;
                this.writeLogMessage(string2, bufferedWriter);
            }
        }
        catch (Exception exception) {
            string2 = "In the method getOSType. Exception:" + exception.getMessage() + " occured while fetching the Operating System Value.s";
            this.writeLogMessage(string2, bufferedWriter);
        }
        return string;
    }
}

