/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.CacheHint;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class CacheFilter {
    private static final Rectangle TEMP_RECT = new Rectangle();
    private static final DirtyRegionContainer TEMP_CONTAINER = new DirtyRegionContainer(1);
    private static final Affine3D TEMP_CACHEFILTER_TRANSFORM = new Affine3D();
    private static final RectBounds TEMP_BOUNDS = new RectBounds();
    private static final double EPSILON = 1.0E-7;
    private RTTexture tempTexture;
    private double lastXDelta;
    private double lastYDelta;
    private ScrollCacheState scrollCacheState = ScrollCacheState.CHECKING_PRECONDITIONS;
    private ImageData cachedImageData;
    private Rectangle cacheBounds = new Rectangle();
    private final Affine2D cachedXform = new Affine2D();
    private double cachedScaleX;
    private double cachedScaleY;
    private double cachedRotate;
    private double cachedX;
    private double cachedY;
    private NGNode node;
    private final Affine2D screenXform = new Affine2D();
    private boolean scaleHint;
    private boolean rotateHint;
    private CacheHint cacheHint;
    private boolean wasUnsupported = false;

    private Rectangle computeDirtyRegionForTranslate() {
        if (this.lastXDelta != 0.0) {
            if (this.lastXDelta > 0.0) {
                TEMP_RECT.setBounds(0, 0, (int)this.lastXDelta, this.cacheBounds.height);
            } else {
                TEMP_RECT.setBounds(this.cacheBounds.width + (int)this.lastXDelta, 0, -((int)this.lastXDelta), this.cacheBounds.height);
            }
        } else if (this.lastYDelta > 0.0) {
            TEMP_RECT.setBounds(0, 0, this.cacheBounds.width, (int)this.lastYDelta);
        } else {
            TEMP_RECT.setBounds(0, this.cacheBounds.height + (int)this.lastYDelta, this.cacheBounds.width, -((int)this.lastYDelta));
        }
        return TEMP_RECT;
    }

    protected CacheFilter(NGNode node, CacheHint cacheHint) {
        this.node = node;
        this.scrollCacheState = ScrollCacheState.CHECKING_PRECONDITIONS;
        this.setHint(cacheHint);
    }

    public void setHint(CacheHint cacheHint) {
        this.cacheHint = cacheHint;
        this.scaleHint = cacheHint == CacheHint.SPEED || cacheHint == CacheHint.SCALE || cacheHint == CacheHint.SCALE_AND_ROTATE;
        this.rotateHint = cacheHint == CacheHint.SPEED || cacheHint == CacheHint.ROTATE || cacheHint == CacheHint.SCALE_AND_ROTATE;
    }

    final boolean isScaleHint() {
        return this.scaleHint;
    }

    final boolean isRotateHint() {
        return this.rotateHint;
    }

    boolean matchesHint(CacheHint cacheHint) {
        return this.cacheHint == cacheHint;
    }

    boolean unsupported(double[] xformInfo) {
        double scaleX = xformInfo[0];
        double scaleY = xformInfo[1];
        double rotate = xformInfo[2];
        return (rotate > 1.0E-7 || rotate < -1.0E-7) && (scaleX > scaleY + 1.0E-7 || scaleY > scaleX + 1.0E-7 || scaleX < scaleY - 1.0E-7 || scaleY < scaleX - 1.0E-7 || this.cachedScaleX > this.cachedScaleY + 1.0E-7 || this.cachedScaleY > this.cachedScaleX + 1.0E-7 || this.cachedScaleX < this.cachedScaleY - 1.0E-7 || this.cachedScaleY < this.cachedScaleX - 1.0E-7);
    }

    private boolean isXformScrollCacheCapable(double[] xformInfo) {
        if (this.unsupported(xformInfo)) {
            return false;
        }
        double rotate = xformInfo[2];
        return this.rotateHint || rotate == 0.0;
    }

    private boolean needToRenderCache(BaseTransform renderXform, double[] xformInfo, float pixelScale) {
        if (this.cachedImageData == null) {
            return true;
        }
        if (this.lastXDelta != 0.0 || this.lastYDelta != 0.0) {
            if (Math.abs(this.lastXDelta) >= (double)this.cacheBounds.width || Math.abs(this.lastYDelta) >= (double)this.cacheBounds.height || Math.rint(this.lastXDelta) != this.lastXDelta || Math.rint(this.lastYDelta) != this.lastYDelta) {
                this.node.clearDirtyTree();
                this.lastYDelta = 0.0;
                this.lastXDelta = 0.0;
                return true;
            }
            if (this.scrollCacheState == ScrollCacheState.CHECKING_PRECONDITIONS) {
                if (this.impl_scrollCacheCapable() && this.isXformScrollCacheCapable(xformInfo)) {
                    this.scrollCacheState = ScrollCacheState.ENABLED;
                } else {
                    this.scrollCacheState = ScrollCacheState.DISABLED;
                    return true;
                }
            }
        }
        if (this.cachedXform.getMxx() == renderXform.getMxx() && this.cachedXform.getMyy() == renderXform.getMyy() && this.cachedXform.getMxy() == renderXform.getMxy() && this.cachedXform.getMyx() == renderXform.getMyx()) {
            return false;
        }
        if (this.wasUnsupported || this.unsupported(xformInfo)) {
            return true;
        }
        double scaleX = xformInfo[0];
        double scaleY = xformInfo[1];
        double rotate = xformInfo[2];
        if (this.scaleHint) {
            if (this.cachedScaleX < (double)pixelScale || this.cachedScaleY < (double)pixelScale) {
                return true;
            }
            if (this.rotateHint) {
                return false;
            }
            return !(this.cachedRotate - 1.0E-7 < rotate) || !(rotate < this.cachedRotate + 1.0E-7);
        }
        if (this.rotateHint) {
            return !(this.cachedScaleX - 1.0E-7 < scaleX) || !(scaleX < this.cachedScaleX + 1.0E-7) || !(this.cachedScaleY - 1.0E-7 < scaleY) || !(scaleY < this.cachedScaleY + 1.0E-7);
        }
        return true;
    }

    void updateScreenXform(double[] xformInfo) {
        if (this.scaleHint) {
            if (this.rotateHint) {
                double screenScaleX = xformInfo[0] / this.cachedScaleX;
                double screenScaleY = xformInfo[1] / this.cachedScaleY;
                double screenRotate = xformInfo[2] - this.cachedRotate;
                this.screenXform.setToScale(screenScaleX, screenScaleY);
                this.screenXform.rotate(screenRotate);
            } else {
                double screenScaleX = xformInfo[0] / this.cachedScaleX;
                double screenScaleY = xformInfo[1] / this.cachedScaleY;
                this.screenXform.setToScale(screenScaleX, screenScaleY);
            }
        } else if (this.rotateHint) {
            double screenRotate = xformInfo[2] - this.cachedRotate;
            this.screenXform.setToRotation(screenRotate, 0.0, 0.0);
        } else {
            this.screenXform.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        }
    }

    public void invalidate() {
        if (this.scrollCacheState == ScrollCacheState.ENABLED) {
            this.scrollCacheState = ScrollCacheState.CHECKING_PRECONDITIONS;
        }
        this.imageDataUnref();
        this.lastYDelta = 0.0;
        this.lastXDelta = 0.0;
    }

    void imageDataUnref() {
        if (this.tempTexture != null) {
            this.tempTexture.dispose();
            this.tempTexture = null;
        }
        if (this.cachedImageData != null) {
            Filterable implImage = this.cachedImageData.getUntransformedImage();
            if (implImage != null) {
                implImage.lock();
            }
            this.cachedImageData.unref();
            this.cachedImageData = null;
        }
    }

    void invalidateByTranslation(double translateXDelta, double translateYDelta) {
        if (this.cachedImageData == null) {
            return;
        }
        if (this.scrollCacheState == ScrollCacheState.DISABLED) {
            this.imageDataUnref();
        } else if (translateXDelta != 0.0 && translateYDelta != 0.0) {
            this.imageDataUnref();
        } else {
            this.lastYDelta = translateYDelta;
            this.lastXDelta = translateXDelta;
        }
    }

    public void dispose() {
        this.invalidate();
        this.node = null;
    }

    double[] unmatrix(BaseTransform xform) {
        double[] retVal = new double[3];
        double[][] row = new double[][]{{xform.getMxx(), xform.getMxy()}, {xform.getMyx(), xform.getMyy()}};
        double xSignum = Math.signum(row[0][0]);
        double ySignum = Math.signum(row[1][1]);
        double scaleX = xSignum * this.v2length(row[0]);
        this.v2scale(row[0], xSignum);
        double shearXY = this.v2dot(row[0], row[1]);
        this.v2combine(row[1], row[0], row[1], 1.0, -shearXY);
        double scaleY = ySignum * this.v2length(row[1]);
        this.v2scale(row[1], ySignum);
        double sin = row[1][0];
        double cos = row[0][0];
        double angleRad = 0.0;
        angleRad = sin >= 0.0 ? Math.acos(cos) : (cos > 0.0 ? Math.PI * 2 + Math.asin(sin) : Math.PI + Math.acos(-cos));
        retVal[0] = scaleX;
        retVal[1] = scaleY;
        retVal[2] = angleRad;
        return retVal;
    }

    void v2combine(double[] v0, double[] v1, double[] result, double scalarA, double scalarB) {
        result[0] = scalarA * v0[0] + scalarB * v1[0];
        result[1] = scalarA * v0[1] + scalarB * v1[1];
    }

    double v2dot(double[] v0, double[] v1) {
        return v0[0] * v1[0] + v0[1] * v1[1];
    }

    void v2scale(double[] v, double newLen) {
        double len = this.v2length(v);
        if (len != 0.0) {
            v[0] = v[0] * (newLen / len);
            v[1] = v[1] * (newLen / len);
        }
    }

    double v2length(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1]);
    }

    void render(Graphics g) {
        Filterable implImage;
        float pixelScale;
        Filterable implImage2;
        BaseTransform xform = g.getTransformNoClone();
        PrFilterContext fctx = PrFilterContext.getInstance(g.getAssociatedScreen());
        double[] xformInfo = this.unmatrix(xform);
        boolean isUnsupported = this.unsupported(xformInfo);
        this.lastXDelta *= xformInfo[0];
        this.lastYDelta *= xformInfo[1];
        if (this.cachedImageData != null && (implImage2 = this.cachedImageData.getUntransformedImage()) != null) {
            implImage2.lock();
            if (!this.cachedImageData.validate(fctx)) {
                implImage2.unlock();
                this.invalidate();
            }
        }
        if (this.needToRenderCache(xform, xformInfo, pixelScale = g.getAssociatedScreen().getRenderScale())) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.incrementCounter("CacheFilter rebuilding");
            }
            if (this.cachedImageData != null) {
                implImage = this.cachedImageData.getUntransformedImage();
                if (implImage != null) {
                    implImage.unlock();
                }
                this.invalidate();
            }
            if (this.scaleHint) {
                this.cachedScaleX = Math.max((double)pixelScale, xformInfo[0]);
                this.cachedScaleY = Math.max((double)pixelScale, xformInfo[1]);
                this.cachedRotate = 0.0;
                this.cachedXform.setTransform(this.cachedScaleX, 0.0, 0.0, this.cachedScaleX, 0.0, 0.0);
                this.updateScreenXform(xformInfo);
            } else {
                this.cachedScaleX = xformInfo[0];
                this.cachedScaleY = xformInfo[1];
                this.cachedRotate = xformInfo[2];
                this.cachedXform.setTransform(xform.getMxx(), xform.getMyx(), xform.getMxy(), xform.getMyy(), 0.0, 0.0);
                this.screenXform.setTransform(BaseTransform.IDENTITY_TRANSFORM);
            }
            this.cacheBounds = this.impl_getCacheBounds(this.cacheBounds, this.cachedXform);
            this.cachedImageData = this.impl_createImageData(fctx, this.cacheBounds);
            this.impl_renderNodeToCache(this.cachedImageData, this.cacheBounds, this.cachedXform, null);
            Rectangle cachedBounds = this.cachedImageData.getUntransformedBounds();
            this.cachedX = cachedBounds.x;
            this.cachedY = cachedBounds.y;
        } else {
            if (this.scrollCacheState == ScrollCacheState.ENABLED && (this.lastXDelta != 0.0 || this.lastYDelta != 0.0)) {
                this.impl_moveCacheBy(this.cachedImageData, this.lastXDelta, this.lastYDelta);
                this.impl_renderNodeToCache(this.cachedImageData, this.cacheBounds, this.cachedXform, this.computeDirtyRegionForTranslate());
                this.lastYDelta = 0.0;
                this.lastXDelta = 0.0;
            }
            if (isUnsupported) {
                this.screenXform.setTransform(BaseTransform.IDENTITY_TRANSFORM);
            } else {
                this.updateScreenXform(xformInfo);
            }
        }
        this.wasUnsupported = isUnsupported;
        implImage = this.cachedImageData.getUntransformedImage();
        if (implImage == null) {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.incrementCounter("CacheFilter not used");
            }
            this.impl_renderNodeToScreen(g);
        } else {
            double mxt = xform.getMxt();
            double myt = xform.getMyt();
            this.impl_renderCacheToScreen(g, implImage, mxt, myt);
            implImage.unlock();
        }
    }

    ImageData impl_createImageData(FilterContext fctx, Rectangle bounds) {
        Filterable ret;
        try {
            ret = Effect.getCompatibleImage(fctx, bounds.width, bounds.height);
            Object cachedTex = ((PrDrawable)ret).getTextureObject();
            cachedTex.contentsUseful();
        }
        catch (Throwable e) {
            ret = null;
        }
        return new ImageData(fctx, ret, bounds);
    }

    void impl_renderNodeToCache(ImageData cacheData, Rectangle cacheBounds, BaseTransform xform, Rectangle dirtyBounds) {
        PrDrawable image = (PrDrawable)cacheData.getUntransformedImage();
        if (image != null) {
            Graphics g = image.createGraphics();
            TEMP_CACHEFILTER_TRANSFORM.setToIdentity();
            TEMP_CACHEFILTER_TRANSFORM.translate(-cacheBounds.x, -cacheBounds.y);
            if (xform != null) {
                TEMP_CACHEFILTER_TRANSFORM.concatenate(xform);
            }
            if (dirtyBounds != null) {
                TEMP_CONTAINER.deriveWithNewRegion((RectBounds)TEMP_BOUNDS.deriveWithNewBounds(dirtyBounds));
                this.node.doPreCulling(TEMP_CONTAINER, TEMP_CACHEFILTER_TRANSFORM, new GeneralTransform3D());
                g.setHasPreCullingBits(true);
                g.setClipRectIndex(0);
                g.setClipRect(dirtyBounds);
            }
            g.transform(TEMP_CACHEFILTER_TRANSFORM);
            if (this.node.getClipNode() != null) {
                this.node.renderClip(g);
            } else if (this.node.getEffectFilter() != null) {
                this.node.renderEffect(g);
            } else {
                this.node.renderContent(g);
            }
        }
    }

    void impl_renderNodeToScreen(Object implGraphics) {
        Graphics g = (Graphics)implGraphics;
        if (this.node.getEffectFilter() != null) {
            this.node.renderEffect(g);
        } else {
            this.node.renderContent(g);
        }
    }

    void impl_renderCacheToScreen(Object implGraphics, Filterable implImage, double mxt, double myt) {
        Graphics g = (Graphics)implGraphics;
        g.setTransform(this.screenXform.getMxx(), this.screenXform.getMyx(), this.screenXform.getMxy(), this.screenXform.getMyy(), mxt, myt);
        g.translate((float)this.cachedX, (float)this.cachedY);
        Object cachedTex = ((PrDrawable)implImage).getTextureObject();
        Rectangle cachedBounds = this.cachedImageData.getUntransformedBounds();
        g.drawTexture((Texture)cachedTex, 0.0f, 0.0f, cachedBounds.width, cachedBounds.height);
    }

    boolean impl_scrollCacheCapable() {
        if (!(this.node instanceof NGGroup)) {
            return false;
        }
        List<NGNode> children = ((NGGroup)this.node).getChildren();
        if (children.size() != 1) {
            return false;
        }
        NGNode child = children.get(0);
        if (!child.getTransform().is2D()) {
            return false;
        }
        NGNode clip = this.node.getClipNode();
        if (clip == null || !clip.isRectClip(BaseTransform.IDENTITY_TRANSFORM, false)) {
            return false;
        }
        if (this.node instanceof NGRegion) {
            NGRegion region = (NGRegion)this.node;
            if (!region.getBorder().isEmpty()) {
                return false;
            }
            Background background = region.getBackground();
            if (!background.isEmpty()) {
                if (!background.getImages().isEmpty() || background.getFills().size() != 1) {
                    return false;
                }
                BackgroundFill fill = background.getFills().get(0);
                Paint fillPaint = fill.getFill();
                BaseBounds clipBounds = clip.getCompleteBounds(TEMP_BOUNDS, BaseTransform.IDENTITY_TRANSFORM);
                return fillPaint.isOpaque() && fillPaint instanceof Color && fill.getInsets().equals(Insets.EMPTY) && clipBounds.getMinX() == 0.0f && clipBounds.getMinY() == 0.0f && clipBounds.getMaxX() == region.getWidth() && clipBounds.getMaxY() == region.getHeight();
            }
        }
        return true;
    }

    void impl_moveCacheBy(ImageData cachedImageData, double xDelta, double yDelta) {
        PrDrawable drawable = (PrDrawable)cachedImageData.getUntransformedImage();
        Rectangle r = cachedImageData.getUntransformedBounds();
        int x = (int)Math.max(0.0, -xDelta);
        int y = (int)Math.max(0.0, -yDelta);
        int destX = (int)Math.max(0.0, xDelta);
        int destY = (int)Math.max(0.0, yDelta);
        int w = r.width - (int)Math.abs(xDelta);
        int h = r.height - (int)Math.abs(yDelta);
        Graphics g = drawable.createGraphics();
        if (this.tempTexture != null) {
            this.tempTexture.lock();
            if (this.tempTexture.isSurfaceLost()) {
                this.tempTexture = null;
            }
        }
        if (this.tempTexture == null) {
            this.tempTexture = g.getResourceFactory().createRTTexture(drawable.getPhysicalWidth(), drawable.getPhysicalHeight(), Texture.WrapMode.CLAMP_NOT_NEEDED);
        }
        Graphics tempG = this.tempTexture.createGraphics();
        tempG.clear();
        tempG.drawTexture((Texture)drawable.getTextureObject(), 0.0f, 0.0f, w, h, x, y, x + w, y + h);
        tempG.sync();
        g.clear();
        g.drawTexture(this.tempTexture, destX, destY, destX + w, destY + h, 0.0f, 0.0f, w, h);
        this.tempTexture.unlock();
    }

    Rectangle impl_getCacheBounds(Rectangle bounds, BaseTransform xform) {
        BaseBounds b = this.node.getClippedBounds(TEMP_BOUNDS, xform);
        bounds.setBounds(b);
        return bounds;
    }

    BaseBounds computeDirtyBounds(BaseBounds region, BaseTransform tx, GeneralTransform3D pvTx) {
        region = !this.node.dirtyBounds.isEmpty() ? region.deriveWithNewBounds(this.node.dirtyBounds) : region.deriveWithNewBounds(this.node.transformedBounds);
        if (!region.isEmpty()) {
            region.roundOut();
            region = this.node.computePadding(region);
            region = tx.transform(region, region);
            region = pvTx.transform(region, region);
        }
        return region;
    }

    private static enum ScrollCacheState {
        CHECKING_PRECONDITIONS,
        ENABLED,
        DISABLED;

    }
}

