/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.FontFace;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.parser.CSSParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.StyleOrigin;

public class Stylesheet {
    static final int BINARY_CSS_VERSION = 5;
    private final String url;
    private StyleOrigin origin = StyleOrigin.AUTHOR;
    private final ObservableList<Rule> rules = new TrackableObservableList<Rule>(){

        @Override
        protected void onChanged(ListChangeListener.Change<Rule> c) {
            c.reset();
            while (c.next()) {
                if (c.wasAdded()) {
                    for (Rule rule : c.getAddedSubList()) {
                        rule.setStylesheet(Stylesheet.this);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                for (Rule rule : c.getRemoved()) {
                    if (rule.getStylesheet() != Stylesheet.this) continue;
                    rule.setStylesheet(null);
                }
            }
        }
    };
    private final List<FontFace> fontFaces = new ArrayList<FontFace>();
    private String[] stringStore;

    public String getUrl() {
        return this.url;
    }

    public StyleOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(StyleOrigin origin) {
        this.origin = origin;
    }

    public Stylesheet() {
        this(null);
    }

    public Stylesheet(String url) {
        this.url = url;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public List<FontFace> getFontFaces() {
        return this.fontFaces;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Stylesheet) {
            Stylesheet other = (Stylesheet)obj;
            if (this.url == null && other.url == null) {
                return true;
            }
            if (this.url == null || other.url == null) {
                return false;
            }
            return this.url.equals(other.url);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("/* ");
        if (this.url != null) {
            sbuf.append(this.url);
        }
        if (this.rules.isEmpty()) {
            sbuf.append(" */");
        } else {
            sbuf.append(" */\n");
            for (int r = 0; r < this.rules.size(); ++r) {
                sbuf.append(this.rules.get(r));
                sbuf.append('\n');
            }
        }
        return sbuf.toString();
    }

    final void writeBinary(DataOutputStream os, StringStore stringStore) throws IOException {
        int index = stringStore.addString(this.origin.name());
        os.writeShort(index);
        os.writeShort(this.rules.size());
        for (Rule r : this.rules) {
            r.writeBinary(os, stringStore);
        }
        List<FontFace> fontFaceList = this.getFontFaces();
        int nFontFaces = fontFaceList != null ? fontFaceList.size() : 0;
        os.writeShort(nFontFaces);
        for (int n = 0; n < nFontFaces; ++n) {
            FontFace fontFace = fontFaceList.get(n);
            fontFace.writeBinary(os, stringStore);
        }
    }

    final void readBinary(int bssVersion, DataInputStream is, String[] strings) throws IOException {
        this.stringStore = strings;
        short index = is.readShort();
        this.setOrigin(StyleOrigin.valueOf(strings[index]));
        int nRules = is.readShort();
        ArrayList<Rule> persistedRules = new ArrayList<Rule>(nRules);
        for (int n = 0; n < nRules; ++n) {
            persistedRules.add(Rule.readBinary(bssVersion, is, strings));
        }
        this.rules.addAll((Collection<Rule>)persistedRules);
        if (bssVersion >= 5) {
            List<FontFace> fontFaceList = this.getFontFaces();
            int nFontFaces = is.readShort();
            for (int n = 0; n < nFontFaces; ++n) {
                FontFace fontFace = FontFace.readBinary(bssVersion, is, strings);
                fontFaceList.add(fontFace);
            }
        }
    }

    final String[] getStringStore() {
        return this.stringStore;
    }

    public static Stylesheet loadBinary(URL url) throws IOException {
        Stylesheet stylesheet;
        block19: {
            if (url == null) {
                return null;
            }
            stylesheet = null;
            try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(url.openStream(), 40960));){
                short bssVersion = dataInputStream.readShort();
                if (bssVersion > 5) {
                    throw new IOException(url.toString() + " wrong binary CSS version: " + bssVersion + ". Expected version less than or equal to" + 5);
                }
                String[] strings = StringStore.readBinary(dataInputStream);
                stylesheet = new Stylesheet(url.toExternalForm());
                try {
                    dataInputStream.mark(Integer.MAX_VALUE);
                    stylesheet.readBinary(bssVersion, dataInputStream, strings);
                }
                catch (Exception e) {
                    stylesheet = new Stylesheet(url.toExternalForm());
                    dataInputStream.reset();
                    if (bssVersion == 2) {
                        stylesheet.readBinary(3, dataInputStream, strings);
                        break block19;
                    }
                    stylesheet.readBinary(5, dataInputStream, strings);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return stylesheet;
    }

    public static void convertToBinary(File source, File destination) throws IOException {
        if (source == null || destination == null) {
            throw new IllegalArgumentException("parameters may not be null");
        }
        if (source.getAbsolutePath().equals(destination.getAbsolutePath())) {
            throw new IllegalArgumentException("source and destination may not be the same");
        }
        if (!source.canRead()) {
            throw new IllegalArgumentException("cannot read source file");
        }
        if (destination.exists() ? !destination.canWrite() : !destination.createNewFile()) {
            throw new IllegalArgumentException("cannot write destination file");
        }
        URI sourceURI = source.toURI();
        Stylesheet stylesheet = new CSSParser().parse(sourceURI.toURL());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        StringStore stringStore = new StringStore();
        stylesheet.writeBinary(dos, stringStore);
        dos.flush();
        dos.close();
        FileOutputStream fos = new FileOutputStream(destination);
        DataOutputStream os = new DataOutputStream(fos);
        os.writeShort(5);
        stringStore.writeBinary(os);
        os.write(baos.toByteArray());
        os.flush();
        os.close();
    }

    public void importStylesheet(Stylesheet importedStylesheet) {
        if (importedStylesheet == null) {
            return;
        }
        List<Rule> rulesToImport = importedStylesheet.getRules();
        if (rulesToImport == null || rulesToImport.isEmpty()) {
            return;
        }
        ArrayList<Rule> importedRules = new ArrayList<Rule>(rulesToImport.size());
        for (Rule rule : rulesToImport) {
            ObservableList<Selector> selectors = rule.getSelectors();
            List<Declaration> declarations = rule.getUnobservedDeclarationList();
            importedRules.add(new Rule(selectors, declarations));
        }
        this.rules.addAll((Collection<Rule>)importedRules);
    }
}

