/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import java.lang.reflect.Field;
import java.security.Permission;
import java.util.Formatter;

class EGL {
    private static long eglWindowSurface = 0L;
    static final long EGL_DEFAULT_DISPLAY = 0L;
    static final long EGL_NO_CONTEXT = 0L;
    static final long EGL_NO_DISPLAY = 0L;
    static final long EGL_NO_SURFACE = 0L;
    static final int EGL_DONT_CARE = -1;
    static final int EGL_SUCCESS = 12288;
    static final int EGL_NOT_INITIALIZED = 12289;
    static final int EGL_BAD_ACCESS = 12290;
    static final int EGL_BAD_ALLOC = 12291;
    static final int EGL_BAD_ATTRIBUTE = 12292;
    static final int EGL_BAD_CONFIG = 12293;
    static final int EGL_BAD_CONTEXT = 12294;
    static final int EGL_BAD_CURRENT_SURFACE = 12295;
    static final int EGL_BAD_DISPLAY = 12296;
    static final int EGL_BAD_MATCH = 12297;
    static final int EGL_BAD_NATIVE_PIXMAP = 12298;
    static final int EGL_BAD_NATIVE_WINDOW = 12299;
    static final int EGL_BAD_PARAMETER = 12300;
    static final int EGL_BAD_SURFACE = 12301;
    static final int EGL_CONTEXT_LOST = 12302;
    static final int EGL_BUFFER_SIZE = 12320;
    static final int EGL_ALPHA_SIZE = 12321;
    static final int EGL_BLUE_SIZE = 12322;
    static final int EGL_GREEN_SIZE = 12323;
    static final int EGL_RED_SIZE = 12324;
    static final int EGL_DEPTH_SIZE = 12325;
    static final int EGL_STENCIL_SIZE = 12326;
    static final int EGL_CONFIG_CAVEAT = 12327;
    static final int EGL_CONFIG_ID = 12328;
    static final int EGL_LEVEL = 12329;
    static final int EGL_MAX_PBUFFER_HEIGHT = 12330;
    static final int EGL_MAX_PBUFFER_PIXELS = 12331;
    static final int EGL_MAX_PBUFFER_WIDTH = 12332;
    static final int EGL_NATIVE_RENDERABLE = 12333;
    static final int EGL_NATIVE_VISUAL_ID = 12334;
    static final int EGL_NATIVE_VISUAL_TYPE = 12335;
    static final int EGL_SAMPLES = 12337;
    static final int EGL_SAMPLE_BUFFERS = 12338;
    static final int EGL_SURFACE_TYPE = 12339;
    static final int EGL_TRANSPARENT_TYPE = 12340;
    static final int EGL_TRANSPARENT_BLUE_VALUE = 12341;
    static final int EGL_TRANSPARENT_GREEN_VALUE = 12342;
    static final int EGL_TRANSPARENT_RED_VALUE = 12343;
    static final int EGL_NONE = 12344;
    static final int EGL_BIND_TO_TEXTURE_RGB = 12345;
    static final int EGL_BIND_TO_TEXTURE_RGBA = 12346;
    static final int EGL_MIN_SWAP_INTERVAL = 12347;
    static final int EGL_MAX_SWAP_INTERVAL = 12348;
    static final int EGL_LUMINANCE_SIZE = 12349;
    static final int EGL_ALPHA_MASK_SIZE = 12350;
    static final int EGL_COLOR_BUFFER_TYPE = 12351;
    static final int EGL_RENDERABLE_TYPE = 12352;
    static final int EGL_MATCH_NATIVE_PIXMAP = 12353;
    static final int EGL_CONFORMANT = 12354;
    static final int EGL_SLOW_CONFIG = 12368;
    static final int EGL_NON_CONFORMANT_CONFIG = 12369;
    static final int EGL_TRANSPARENT_RGB = 12370;
    static final int EGL_RGB_BUFFER = 12430;
    static final int EGL_LUMINANCE_BUFFER = 12431;
    static final int EGL_NO_TEXTURE = 12380;
    static final int EGL_TEXTURE_RGB = 12381;
    static final int EGL_TEXTURE_RGBA = 12382;
    static final int EGL_TEXTURE_2D = 12383;
    static final int EGL_PBUFFER_BIT = 1;
    static final int EGL_PIXMAP_BIT = 2;
    static final int EGL_WINDOW_BIT = 4;
    static final int EGL_VG_COLORSPACE_LINEAR_BIT = 32;
    static final int EGL_VG_ALPHA_FORMAT_PRE_BIT = 64;
    static final int EGL_MULTISAMPLE_RESOLVE_BOX_BIT = 512;
    static final int EGL_SWAP_BEHAVIOR_PRESERVED_BIT = 1024;
    static final int EGL_OPENGL_ES_BIT = 1;
    static final int EGL_OPENVG_BIT = 2;
    static final int EGL_OPENGL_ES = 2;
    static final int EGL_OPENGL_BIT = 8;
    static final int EGL_VENDOR = 12371;
    static final int EGL_VERSION = 12372;
    static final int EGL_EXTENSIONS = 12373;
    static final int EGL_CLIENT_APIS = 12429;
    static final int EGL_HEIGHT = 12374;
    static final int EGL_WIDTH = 12375;
    static final int EGL_LARGEST_PBUFFER = 12376;
    static final int EGL_TEXTURE_FORMAT = 12416;
    static final int EGL_TEXTURE_TARGET = 12417;
    static final int EGL_MIPMAP_TEXTURE = 12418;
    static final int EGL_MIPMAP_LEVEL = 12419;
    static final int EGL_RENDER_BUFFER = 12422;
    static final int EGL_VG_COLORSPACE = 12423;
    static final int EGL_VG_ALPHA_FORMAT = 12424;
    static final int EGL_HORIZONTAL_RESOLUTION = 12432;
    static final int EGL_VERTICAL_RESOLUTION = 12433;
    static final int EGL_PIXEL_ASPECT_RATIO = 12434;
    static final int EGL_SWAP_BEHAVIOR = 12435;
    static final int EGL_MULTISAMPLE_RESOLVE = 12441;
    static final int EGL_BACK_BUFFER = 12420;
    static final int EGL_SINGLE_BUFFER = 12421;
    static final int EGL_VG_COLORSPACE_sRGB = 12425;
    static final int EGL_VG_COLORSPACE_LINEAR = 12426;
    static final int EGL_VG_ALPHA_FORMAT_NONPRE = 12427;
    static final int EGL_VG_ALPHA_FORMAT_PRE = 12428;
    static final int EGL_DISPLAY_SCALING = 10000;
    static final int EGL_UNKNOWN = -1;
    static final int EGL_BUFFER_PRESERVED = 12436;
    static final int EGL_BUFFER_DESTROYED = 12437;
    static final int EGL_OPENVG_IMAGE = 12438;
    static final int EGL_CONTEXT_CLIENT_TYPE = 12439;
    static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    static final int EGL_MULTISAMPLE_RESOLVE_DEFAULT = 12442;
    static final int EGL_MULTISAMPLE_RESOLVE_BOX = 12443;
    static final int EGL_OPENGL_ES_API = 12448;
    static final int EGL_OPENVG_API = 12449;
    static final int EGL_OPENGL_API = 12450;
    static final int EGL_DRAW = 12377;
    static final int EGL_READ = 12378;
    static final int EGL_CORE_NATIVE_ENGINE = 12379;
    private static Permission permission = new RuntimePermission("loadLibrary.*");
    private static EGL instance = new EGL();

    private EGL() {
    }

    static EGL getEGL() {
        EGL.checkPermissions();
        return instance;
    }

    private static void checkPermissions() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(permission);
        }
    }

    native void loadFunctions(long var1);

    native boolean eglBindAPI(int var1);

    native boolean eglChooseConfig(long var1, int[] var3, long[] var4, int var5, int[] var6);

    native long eglContextFromConfig(long var1, long var3);

    native long eglCreateContext(long var1, long var3, long var5, int[] var7);

    long eglCreateWindowSurface(long eglDisplay, long eglConfig, long nativeWindow, int[] attribs) {
        if (eglWindowSurface == 0L) {
            eglWindowSurface = this._eglCreateWindowSurface(eglDisplay, eglConfig, nativeWindow, attribs);
        }
        return eglWindowSurface;
    }

    native long _eglCreateWindowSurface(long var1, long var3, long var5, int[] var7);

    native boolean eglDestroyContext(long var1, long var3);

    native boolean eglGetConfigAttrib(long var1, long var3, int var5, int[] var6);

    native long eglGetDisplay(long var1);

    native int eglGetError();

    native boolean eglInitialize(long var1, int[] var3, int[] var4);

    native boolean eglMakeCurrent(long var1, long var3, long var5, long var7);

    native String eglQueryString(long var1, int var3);

    native String eglQueryVersion(long var1, int var3);

    native boolean eglSwapBuffers(long var1, long var3);

    String eglErrorToString(int errorCode) {
        if (errorCode >= 12288 && errorCode < 12320) {
            for (Field field : EGL.class.getFields()) {
                try {
                    if (field.getName().startsWith("EGL_") && field.getType() == Integer.TYPE && field.getInt(null) == errorCode) {
                        return field.getName();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return new Formatter().format("0x%04x", errorCode & 0xFFFF).out().toString();
    }
}

