/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionComponent;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import java.util.Map;

final class TopQueryExecutionComponent
extends QueryExecutionComponent {
    private int topCount;

    protected TopQueryExecutionComponent(QueryExecutionContext<Document> source, int top) {
        super(source);
        this.topCount = top;
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return this.source.getResponseHeaders();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext() && this.topCount > 0;
    }

    @Override
    protected Document next(Document document) {
        --this.topCount;
        if (this.topCount <= 0) {
            this.source.onNotifyStop();
        }
        return document;
    }
}

