/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.ServiceJNIWrapper;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfoInternal;
import com.microsoft.azure.documentdb.internal.query.QueryInfo;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryPartitionProvider {
    private static final List<Range<String>> singleFullRange = new ArrayList<Range<String>>(){
        {
            this.add(new Range<String>(PartitionKeyInternal.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternal.MaximumExclusiveEffectivePartitionKey, true, false));
        }
    };
    private final String queryEngineConfiguration;
    private volatile long serviceProvider;

    private static Map<String, Object> getQueryEngineConfiguration() {
        HashMap<String, Object> defaultConfigMap = new HashMap<String, Object>(){
            {
                this.put("maxSqlQueryInputLength", 30720);
                this.put("maxJoinsPerSqlQuery", 5);
                this.put("maxLogicalAndPerSqlQuery", 200);
                this.put("maxLogicalOrPerSqlQuery", 200);
                this.put("maxUdfRefPerSqlQuery", 2);
                this.put("maxInExpressionItemsCount", 8000);
                this.put("sqlAllowTop", true);
                this.put("sqlAllowSubQuery", false);
                this.put("allowNewKeywords", true);
                this.put("enableSpatialIndexing", true);
                this.put("maxSpatialQueryCells", 12);
                this.put("spatialMaxGeometryPointCount", 256);
            }
        };
        return defaultConfigMap;
    }

    public QueryPartitionProvider() {
        Map<String, Object> queryEngineConfiguration = QueryPartitionProvider.getQueryEngineConfiguration();
        if (queryEngineConfiguration == null) {
            throw new IllegalArgumentException("queryEngineConfiguration");
        }
        if (queryEngineConfiguration.size() == 0) {
            throw new IllegalArgumentException("queryEngineConfiguration cannot be empty.");
        }
        try {
            this.queryEngineConfiguration = Utils.getSimpleObjectMapper().writeValueAsString(queryEngineConfiguration);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        this.serviceProvider = 0L;
    }

    public PartitionedQueryExecutionInfo getPartitionQueryExcecutionInfo(SqlQuerySpec querySpec, PartitionKeyDefinition partitionKeyDefinition) {
        if (querySpec == null || partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            return new PartitionedQueryExecutionInfo(new QueryInfo(), singleFullRange);
        }
        this.initializeServiceProvider();
        PartitionedQueryExecutionInfoInternal partitionedQueryExecutionInfoInternal = ServiceJNIWrapper.getPartitionKeyRangesFromQuery(this.serviceProvider, querySpec, partitionKeyDefinition);
        ArrayList<Range<String>> effectiveRanges = new ArrayList<Range<String>>(partitionedQueryExecutionInfoInternal.getQueryRanges().size());
        for (Range<PartitionKeyInternal> internalRange : partitionedQueryExecutionInfoInternal.getQueryRanges()) {
            effectiveRanges.add(new Range<String>(internalRange.getMin().getEffectivePartitionKeyString(partitionKeyDefinition, false), internalRange.getMax().getEffectivePartitionKeyString(partitionKeyDefinition, false), internalRange.isMinInclusive(), internalRange.isMaxInclusive()));
        }
        Collections.sort(effectiveRanges, new Range.MinComparator());
        return new PartitionedQueryExecutionInfo(partitionedQueryExecutionInfoInternal.getQueryInfo(), effectiveRanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeServiceProvider() {
        if (this.serviceProvider == 0L) {
            QueryPartitionProvider queryPartitionProvider = this;
            synchronized (queryPartitionProvider) {
                if (this.serviceProvider == 0L) {
                    this.serviceProvider = ServiceJNIWrapper.createServiceProvider(this.queryEngineConfiguration);
                }
            }
        }
    }
}

