/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.ServiceJNIWrapper;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.DefaultQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.PipelinedQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.QueryPartitionProvider;
import com.microsoft.azure.documentdb.internal.routing.CollectionCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class ProxyQueryExecutionContext<T extends Resource>
implements QueryExecutionContext<T> {
    private final DocumentQueryClientInternal client;
    private final ResourceType resourceType;
    private final Class<T> classT;
    private final SqlQuerySpec querySpec;
    private final FeedOptions options;
    private final String resourceLink;
    private final QueryExecutionContext<T> queryExecutionContext;
    private T prefetchedResource;
    private volatile boolean hasPrefetchedResource;

    public ProxyQueryExecutionContext(DocumentQueryClientInternal client, ResourceType resourceType, Class<T> classT, SqlQuerySpec querySpec, FeedOptions options, String resourceLink) {
        this.client = client;
        this.resourceType = resourceType;
        this.classT = classT;
        this.querySpec = querySpec;
        this.options = options;
        this.resourceLink = resourceLink;
        QueryExecutionContext<T> currentQueryExecutionContext = null;
        PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = null;
        if (ServiceJNIWrapper.isServiceJNIAvailable() && Utils.isCollectionChild(resourceType) && resourceType.isPartitioned() && options != null && options.getEnableCrossPartitionQuery() != null && options.getEnableCrossPartitionQuery().booleanValue()) {
            QueryPartitionProvider queryPartitionProvider;
            DocumentCollection collection = null;
            if (Utils.isCollectionChild(resourceType)) {
                DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Query, resourceType, resourceLink, null);
                CollectionCache collectionCache = this.client.getCollectionCache();
                collection = collectionCache.resolveCollection(request);
            }
            if (ProxyQueryExecutionContext.shouldCreateSpecializedDocumentQueryExecutionContext(resourceType, options, partitionedQueryExecutionInfo = (queryPartitionProvider = this.client.getQueryPartitionProvider()).getPartitionQueryExcecutionInfo(querySpec, collection.getPartitionKey()))) {
                currentQueryExecutionContext = new PipelinedQueryExecutionContext(this.client, this.querySpec, this.options, this.resourceLink, partitionedQueryExecutionInfo);
            }
        }
        if (currentQueryExecutionContext == null) {
            currentQueryExecutionContext = new DefaultQueryExecutionContext<T>(client, resourceType, classT, querySpec, partitionedQueryExecutionInfo, options, resourceLink);
            try {
                if (currentQueryExecutionContext.hasNext()) {
                    this.prefetchedResource = (Resource)currentQueryExecutionContext.next();
                    if (this.prefetchedResource != null) {
                        this.hasPrefetchedResource = true;
                    }
                }
            }
            catch (IllegalStateException e) {
                DocumentClientException dce;
                if (!(e.getCause() instanceof DocumentClientException) || !this.shouldCreatePipelinedQueryExecutionContext(dce = (DocumentClientException)e.getCause())) {
                    throw e;
                }
                currentQueryExecutionContext = new PipelinedQueryExecutionContext(this.client, this.querySpec, this.options, this.resourceLink, new PartitionedQueryExecutionInfo(dce.getError().getPartitionedQueryExecutionInfo()));
            }
        }
        this.queryExecutionContext = currentQueryExecutionContext;
    }

    private static boolean shouldCreateSpecializedDocumentQueryExecutionContext(ResourceType resourceType, FeedOptions feedOptions, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        return ProxyQueryExecutionContext.isCrossPartitionQuery(resourceType, feedOptions, partitionedQueryExecutionInfo) && (ProxyQueryExecutionContext.isTopOrderByQuery(partitionedQueryExecutionInfo) || ProxyQueryExecutionContext.isParallelQuery(feedOptions));
    }

    private static boolean isParallelQuery(FeedOptions feedOptions) {
        return feedOptions.getMaxDegreeOfParallelism() != 0;
    }

    private static boolean isTopOrderByQuery(PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        return partitionedQueryExecutionInfo.getQueryInfo() != null && (partitionedQueryExecutionInfo.getQueryInfo().hasOrderBy() || partitionedQueryExecutionInfo.getQueryInfo().hasTop());
    }

    private static boolean isCrossPartitionQuery(ResourceType resourceType, FeedOptions feedOptions, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        return resourceType.isPartitioned() && feedOptions.getPartitionKey() == null && feedOptions.getEnableCrossPartitionQuery() != null && feedOptions.getEnableCrossPartitionQuery() != false && (partitionedQueryExecutionInfo.getQueryRanges().size() != 1 || !partitionedQueryExecutionInfo.getQueryRanges().get(0).isSingleValue());
    }

    @Override
    public boolean hasNext() {
        return this.hasPrefetchedResource || this.queryExecutionContext.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        Resource item = null;
        if (this.hasPrefetchedResource) {
            ProxyQueryExecutionContext proxyQueryExecutionContext = this;
            synchronized (proxyQueryExecutionContext) {
                if (this.hasPrefetchedResource) {
                    T result = this.prefetchedResource;
                    this.hasPrefetchedResource = false;
                    item = result;
                }
            }
        }
        while (item == null && this.queryExecutionContext.hasNext()) {
            item = (Resource)this.queryExecutionContext.next();
        }
        return (T)item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return this.queryExecutionContext.getResponseHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> fetchNextBlock() throws DocumentClientException {
        if (this.hasPrefetchedResource) {
            ProxyQueryExecutionContext proxyQueryExecutionContext = this;
            synchronized (proxyQueryExecutionContext) {
                if (this.hasPrefetchedResource) {
                    ArrayList<T> result = new ArrayList<T>();
                    result.add(this.prefetchedResource);
                    result.addAll(this.queryExecutionContext.fetchNextBlock());
                    this.hasPrefetchedResource = false;
                    return result;
                }
            }
        }
        return this.queryExecutionContext.fetchNextBlock();
    }

    @Override
    public void onNotifyStop() {
        this.queryExecutionContext.onNotifyStop();
    }

    private boolean shouldCreatePipelinedQueryExecutionContext(DocumentClientException e) {
        return !(this.queryExecutionContext instanceof PipelinedQueryExecutionContext) && this.resourceType == ResourceType.Document && Document.class.equals(this.classT) && e.getStatusCode() == 400 && e.getSubStatusCode() != null && e.getSubStatusCode() == 1004;
    }
}

