/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.RequestChargeTracker;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.query.AbstractQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.DefaultDocumentProducerComparator;
import com.microsoft.azure.documentdb.internal.query.DocumentProducer;
import com.microsoft.azure.documentdb.internal.query.DocumentQueryResult;
import com.microsoft.azure.documentdb.internal.query.OrderByDocumentProducerConsumeComparator;
import com.microsoft.azure.documentdb.internal.query.OrderByDocumentProducerProduceComparator;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class ParallelQueryExecutionContext
extends AbstractQueryExecutionContext<Document> {
    private static final long MAXIMUM_TIME_TO_WAIT_IN_SECONDS = 5L;
    private static final int AUTO_MODE_TASKS_INCREMENT_FACTOR = 2;
    private static final int DEFAULT_MAX_ITEM_COUNT = 100;
    private static final int DEFAULT_ORDER_BY_PAGE_SIZE = 1000;
    private static final int MINIMUM_PAGE_SIZE = 5;
    private static final double BUFFERED_ITEM_COUNT_SLACK = 0.2;
    private static final String CONTINUATION_TOKEN = "ParallelQueryExecutionContext";
    private final List<DocumentProducer> documentProducers;
    private final PriorityBlockingQueue<DocumentProducer> documentProducerConsumePriorityQueue;
    private final PriorityBlockingQueue<DocumentProducer> documentProducerProducePriorityQueue;
    private final int maxDegreeOfParallelism;
    private final int maxBufferedItemCount;
    private final AtomicInteger totalNumberOfRunningDocumentProducers;
    private final AtomicInteger totalNumberOfRequestRoundtrips;
    private final AtomicInteger totalNumberOfDocumentProducersFinished;
    private final AtomicInteger totalBufferedItems;
    private final ReentrantLock taskSubmissionLock;
    private final Condition canSubmitTaskCondition;
    private final RequestChargeTracker chargeTracker;
    private DocumentProducer currentDocumentProducer;
    private double currentAverageNumberOfRoundTripsPerTask;
    private final Future<ParallelQueryExecutionContext> initializationFuture;
    private Future<ParallelQueryExecutionContext> schedulingFuture;
    private final ExecutorService executorService;

    public ParallelQueryExecutionContext(DocumentQueryClientInternal client, SqlQuerySpec querySpec, FeedOptions options, String resourceLink, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo) {
        super(client, ResourceType.Document, Document.class, partitionedQueryExecutionInfo.getQueryInfo().hasRewrittenQuery() ? new SqlQuerySpec(partitionedQueryExecutionInfo.getQueryInfo().getRewrittenQuery(), querySpec.getParameters()) : querySpec, options, resourceLink);
        boolean hasOrderBy = partitionedQueryExecutionInfo.getQueryInfo().hasOrderBy();
        boolean hasTop = partitionedQueryExecutionInfo.getQueryInfo().hasTop();
        Collection<PartitionKeyRange> ranges = super.getTargetPartitionKeyRanges(partitionedQueryExecutionInfo.getQueryRanges());
        this.documentProducers = new ArrayList<DocumentProducer>(ranges.size());
        this.documentProducerProducePriorityQueue = new PriorityBlockingQueue<DocumentProducer>(ranges.size(), hasOrderBy ? new OrderByDocumentProducerProduceComparator() : DefaultDocumentProducerComparator.getInstance());
        this.documentProducerConsumePriorityQueue = new PriorityBlockingQueue<DocumentProducer>(ranges.size(), hasOrderBy ? new OrderByDocumentProducerConsumeComparator(partitionedQueryExecutionInfo.getQueryInfo().getOrderBy()) : DefaultDocumentProducerComparator.getInstance());
        Integer pageSizeForOrderBy = options.getPageSize() == null || options.getPageSize() < 1 ? 1000 : Math.max(options.getPageSize(), 5);
        Class documentProducerClassT = hasOrderBy ? DocumentQueryResult.class : Document.class;
        for (PartitionKeyRange range : ranges) {
            DocumentServiceRequest request = super.createRequest(this.querySpec, range);
            if (hasOrderBy) {
                request.getHeaders().put("x-ms-max-item-count", pageSizeForOrderBy.toString());
            }
            this.documentProducers.add(new DocumentProducer(this, request, range, documentProducerClassT));
        }
        this.maxDegreeOfParallelism = Math.min(ranges.size(), options.getMaxDegreeOfParallelism());
        this.maxBufferedItemCount = hasOrderBy ? (int)((double)(ranges.size() * pageSizeForOrderBy) * 1.2) : Math.max(options.getMaxBufferedItemCount(), 100);
        this.totalNumberOfRunningDocumentProducers = new AtomicInteger();
        this.totalNumberOfRequestRoundtrips = new AtomicInteger();
        this.totalNumberOfDocumentProducersFinished = new AtomicInteger();
        this.totalBufferedItems = new AtomicInteger();
        this.taskSubmissionLock = new ReentrantLock();
        this.canSubmitTaskCondition = this.taskSubmissionLock.newCondition();
        this.chargeTracker = new RequestChargeTracker();
        this.currentAverageNumberOfRoundTripsPerTask = 1.0;
        this.executorService = client.getExecutorService();
        this.initializationFuture = this.executorService.submit(this.getInitializationCallable(hasOrderBy || !hasTop));
    }

    protected void finalize() throws Throwable {
        this.initializationFuture.cancel(true);
        if (this.schedulingFuture != null) {
            this.schedulingFuture.cancel(true);
        }
    }

    @Override
    public List<Document> fetchNextBlock() throws DocumentClientException {
        throw new UnsupportedOperationException("fetchNextBlock");
    }

    @Override
    public boolean hasNext() {
        try {
            this.initializationFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to initialize.", e);
        }
        return super.hasNextInternal();
    }

    @Override
    public Document next() {
        Document result;
        if (!this.hasNext()) {
            throw new NoSuchElementException("next");
        }
        try {
            this.initializationFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Failed to initialize.", e);
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new HashMap<String, String>();
        }
        try {
            if (this.currentDocumentProducer == null || !this.currentDocumentProducer.hasNext()) {
                this.currentDocumentProducer = this.documentProducerConsumePriorityQueue.take();
            } else if (!this.documentProducerConsumePriorityQueue.isEmpty() && this.documentProducerConsumePriorityQueue.comparator().compare(this.currentDocumentProducer, this.documentProducerConsumePriorityQueue.peek()) > 0) {
                this.documentProducerConsumePriorityQueue.put(this.currentDocumentProducer);
                this.currentDocumentProducer = this.documentProducerConsumePriorityQueue.take();
            }
            result = this.currentDocumentProducer.next();
            this.totalBufferedItems.decrementAndGet();
            ReentrantLock lock = this.taskSubmissionLock;
            lock.lockInterruptibly();
            try {
                if (this.canSubmitTask()) {
                    this.canSubmitTaskCondition.signal();
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to take from DocumentProducer consume queue.", e);
        }
        if (!this.currentDocumentProducer.hasNext() && this.documentProducerConsumePriorityQueue.isEmpty()) {
            this.onFinish();
        } else {
            this.responseHeaders.put("x-ms-continuation", CONTINUATION_TOKEN);
        }
        return result;
    }

    @Override
    public void onNotifyStop() {
        this.totalNumberOfDocumentProducersFinished.set(this.documentProducers.size());
        this.unblockProduceQueue(this.documentProducers.get(0));
        try {
            this.initializationFuture.get();
            if (this.schedulingFuture != null) {
                this.schedulingFuture.get();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to wait for Futures to finish.", e);
        }
        this.onFinish();
    }

    private void onFinish() {
        this.responseHeaders.remove("x-ms-continuation");
        this.responseHeaders.put("x-ms-request-charge", String.valueOf(this.chargeTracker.getAndResetCharge()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblockProduceQueue(DocumentProducer documentProducer) {
        if (!this.shouldProduce() && this.documentProducerProducePriorityQueue.isEmpty()) {
            PriorityBlockingQueue<DocumentProducer> priorityBlockingQueue = this.documentProducerProducePriorityQueue;
            synchronized (priorityBlockingQueue) {
                if (this.documentProducerProducePriorityQueue.isEmpty()) {
                    this.documentProducerProducePriorityQueue.put(documentProducer);
                }
            }
        }
    }

    private boolean canSubmitTask() {
        return this.totalNumberOfRunningDocumentProducers.get() < this.getNumberOfTasksToRunBasedOnCurrentState() && (double)this.totalBufferedItems.get() < (double)this.maxBufferedItemCount * 1.2 || this.totalNumberOfRunningDocumentProducers.get() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<DocumentProducer> submitTask(DocumentProducer producer) throws InterruptedException {
        ReentrantLock lock = this.taskSubmissionLock;
        lock.lockInterruptibly();
        try {
            while (!this.canSubmitTask()) {
                this.canSubmitTaskCondition.await(5L, TimeUnit.SECONDS);
            }
            this.totalNumberOfRunningDocumentProducers.incrementAndGet();
            Future<DocumentProducer> future = this.executorService.submit(this.getDocumentProducerCallable(producer));
            return future;
        }
        finally {
            lock.unlock();
        }
    }

    private Callable<ParallelQueryExecutionContext> getInitializationCallable(boolean prefetchAll) {
        return new Callable<ParallelQueryExecutionContext>(){

            @Override
            public ParallelQueryExecutionContext call() throws Exception {
                ParallelQueryExecutionContext thisContext = ParallelQueryExecutionContext.this;
                ArrayList<Future> futures = new ArrayList<Future>();
                for (DocumentProducer producer : thisContext.documentProducers) {
                    futures.add(thisContext.submitTask(producer));
                }
                thisContext.schedulingFuture = ParallelQueryExecutionContext.this.executorService.submit(thisContext.getSchedulingCallable());
                for (Future future : futures) {
                    future.get();
                }
                if (thisContext.documentProducerConsumePriorityQueue.isEmpty()) {
                    ParallelQueryExecutionContext.this.responseHeaders = new HashMap();
                }
                return thisContext;
            }
        };
    }

    private boolean shouldProduce() {
        return this.totalNumberOfDocumentProducersFinished.get() < this.documentProducers.size();
    }

    private Callable<ParallelQueryExecutionContext> getSchedulingCallable() {
        return new Callable<ParallelQueryExecutionContext>(){

            @Override
            public ParallelQueryExecutionContext call() throws Exception {
                ParallelQueryExecutionContext thisContext = ParallelQueryExecutionContext.this;
                while (thisContext.shouldProduce()) {
                    thisContext.submitTask((DocumentProducer)thisContext.documentProducerProducePriorityQueue.take());
                }
                return thisContext;
            }
        };
    }

    private int getNumberOfTasksToRunBasedOnCurrentState() {
        if (this.maxDegreeOfParallelism >= 1) {
            return this.maxDegreeOfParallelism;
        }
        int numTasksServingParallelRequests = this.totalNumberOfRunningDocumentProducers.get();
        if (numTasksServingParallelRequests == 0) {
            return 2;
        }
        int returnVal = numTasksServingParallelRequests;
        double currentAverageNumberOfRoundTripsPerTask = (double)this.totalNumberOfRequestRoundtrips.get() / (double)numTasksServingParallelRequests;
        if (currentAverageNumberOfRoundTripsPerTask > this.currentAverageNumberOfRoundTripsPerTask) {
            returnVal *= 2;
        }
        this.currentAverageNumberOfRoundTripsPerTask = currentAverageNumberOfRoundTripsPerTask;
        return Math.max(returnVal, Runtime.getRuntime().availableProcessors());
    }

    private Callable<DocumentProducer> getDocumentProducerCallable(final DocumentProducer documentProducer) {
        return new Callable<DocumentProducer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DocumentProducer call() throws Exception {
                if (documentProducer.isFinished()) {
                    return documentProducer;
                }
                ParallelQueryExecutionContext thisContext = ParallelQueryExecutionContext.this;
                boolean hasStarted = documentProducer.hasStarted();
                if (!documentProducer.produce().isFinished()) {
                    thisContext.documentProducerProducePriorityQueue.put(documentProducer);
                } else {
                    thisContext.totalNumberOfDocumentProducersFinished.incrementAndGet();
                    thisContext.unblockProduceQueue(documentProducer);
                }
                if (!hasStarted && documentProducer.hasNext()) {
                    thisContext.documentProducerConsumePriorityQueue.put(documentProducer);
                }
                thisContext.chargeTracker.addCharge(Double.parseDouble(documentProducer.getPreviousResponseHeaders().get("x-ms-request-charge")));
                thisContext.totalBufferedItems.addAndGet(documentProducer.getPreviousResponseItemCount());
                thisContext.totalNumberOfRequestRoundtrips.incrementAndGet();
                thisContext.totalNumberOfRunningDocumentProducers.decrementAndGet();
                ReentrantLock lock = thisContext.taskSubmissionLock;
                lock.lockInterruptibly();
                try {
                    if (thisContext.canSubmitTask()) {
                        thisContext.canSubmitTaskCondition.signal();
                    }
                }
                finally {
                    lock.unlock();
                }
                return documentProducer;
            }
        };
    }
}

