/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.query;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.ServiceJNIWrapper;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.query.AbstractQueryExecutionContext;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.routing.CollectionCache;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.documentdb.internal.routing.PartitionRoutingHelper;
import com.microsoft.azure.documentdb.internal.routing.Range;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

final class DefaultQueryExecutionContext<T extends Resource>
extends AbstractQueryExecutionContext<T> {
    private final Queue<T> buffer = new ArrayDeque<T>();
    private final DocumentServiceRequest request;
    private PartitionedQueryExecutionInfo queryExecutionInfo;
    private List<Range<String>> providedRanges;
    private DocumentCollection collection;

    public DefaultQueryExecutionContext(DocumentQueryClientInternal client, ResourceType resourceType, Class<T> classT, SqlQuerySpec querySpec, PartitionedQueryExecutionInfo queryExecutionInfo, FeedOptions options, String resourceLink) {
        super(client, resourceType, classT, querySpec, options, resourceLink);
        this.request = super.createRequest(querySpec, this.getPartitionKeyInternal());
        this.queryExecutionInfo = queryExecutionInfo;
    }

    @Override
    public List<T> fetchNextBlock() throws DocumentClientException {
        if (!this.hasNext()) {
            return null;
        }
        this.fillBuffer();
        ArrayList<T> result = new ArrayList<T>(this.buffer);
        this.buffer.clear();
        return result;
    }

    @Override
    public boolean hasNext() {
        return super.hasNextInternal() || !this.buffer.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next");
        }
        try {
            this.fillBuffer();
        }
        catch (DocumentClientException e) {
            throw new IllegalStateException(e);
        }
        return (T)((Resource)this.buffer.poll());
    }

    @Override
    public void onNotifyStop() {
    }

    private void fillBuffer() throws DocumentClientException {
        while (super.hasNextInternal() && this.buffer.isEmpty()) {
            DocumentServiceResponse response = this.executeOnce();
            this.responseHeaders = response.getResponseHeaders();
            this.buffer.addAll(response.getQueryResponse(this.classT));
            this.request.getHeaders().put("x-ms-continuation", super.getContinuationToken());
        }
    }

    private DocumentServiceResponse executeOnce() throws DocumentClientException {
        String partitionKey = this.request.getHeaders().get("x-ms-documentdb-partitionkey");
        if (partitionKey != null && !partitionKey.isEmpty() || !this.resourceType.isPartitioned()) {
            return this.executeRequest(this.request);
        }
        if (this.collection == null) {
            this.collection = this.client.getCollectionCache().resolveCollection(this.request);
        }
        if (!Utils.isCollectionPartitioned(this.collection).booleanValue()) {
            this.request.routeTo(new PartitionKeyRangeIdentity(this.collection.getResourceId(), "0"));
            return this.executeRequest(this.request);
        }
        if (!ServiceJNIWrapper.isServiceJNIAvailable() && this.shouldExecuteQuery()) {
            return this.executeRequest(this.request);
        }
        Range<String> rangeFromContinuationToken = PartitionRoutingHelper.extractPartitionKeyRangeFromContinuationToken(this.request.getHeaders());
        RoutingMapProvider routingMapProvider = this.client.getPartitionKeyRangeCache();
        CollectionCache collectionCache = this.client.getCollectionCache();
        this.populateProvidedRanges();
        PartitionKeyRange targetPartitionKeyRange = this.tryGetTargetPartitionKeyRange(rangeFromContinuationToken);
        if (this.request.getIsNameBased() && targetPartitionKeyRange == null) {
            this.request.setForceNameCacheRefresh(true);
            this.collection = collectionCache.resolveCollection(this.request);
            targetPartitionKeyRange = this.tryGetTargetPartitionKeyRange(rangeFromContinuationToken);
        }
        if (targetPartitionKeyRange == null) {
            throw new DocumentClientException(404, "Target range information not found.");
        }
        this.request.routeTo(new PartitionKeyRangeIdentity(this.collection.getResourceId(), targetPartitionKeyRange.getId()));
        DocumentServiceResponse response = this.executeRequest(this.request);
        if (!PartitionRoutingHelper.tryAddPartitionKeyRangeToContinuationToken(response.getResponseHeaders(), this.providedRanges, routingMapProvider, this.collection.getSelfLink(), targetPartitionKeyRange)) {
            throw new DocumentClientException(404, "Collection not found");
        }
        return response;
    }

    private PartitionKeyRange tryGetTargetPartitionKeyRange(Range<String> rangeFromContinuationToken) throws DocumentClientException {
        PartitionKeyRange targetPartitionKeyRange = PartitionRoutingHelper.tryGetTargetRangeFromContinuationTokenRange(this.providedRanges, this.client.getPartitionKeyRangeCache(), this.collection.getSelfLink(), rangeFromContinuationToken);
        return targetPartitionKeyRange;
    }

    private boolean populateProvidedRanges() throws DocumentClientException {
        if (this.providedRanges != null) {
            return false;
        }
        if (this.providedRanges == null && this.queryExecutionInfo != null) {
            this.providedRanges = this.queryExecutionInfo.getQueryRanges();
            return true;
        }
        String version = this.request.getHeaders().get("x-ms-version");
        version = version == null || version.isEmpty() ? "2016-07-11" : version;
        String enableCrossPartitionQueryHeader = this.request.getHeaders().get("x-ms-documentdb-query-enablecrosspartition");
        boolean enableCrossPartitionQuery = Boolean.parseBoolean(enableCrossPartitionQueryHeader);
        this.providedRanges = this.shouldExecuteQuery() ? PartitionRoutingHelper.getProvidedPartitionKeyRanges(this.querySpec, enableCrossPartitionQuery, false, this.collection.getPartitionKey(), this.client.getQueryPartitionProvider(), version) : new ArrayList<Range<String>>(){
            {
                this.add(new Range<String>(PartitionKeyInternal.MinimumInclusiveEffectivePartitionKey, PartitionKeyInternal.MaximumExclusiveEffectivePartitionKey, true, false));
            }
        };
        return true;
    }
}

