/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class StoreResponse {
    private int status;
    private String[] responseHeaderNames;
    private String[] responseHeaderValues;
    private String httpEntityContent;
    private InputStream httpEntityStream;

    public StoreResponse(String[] responseHeaderNames, String[] responseHeaderValues, int status, HttpEntity responseBody, boolean isMedia) {
        this.responseHeaderNames = responseHeaderNames;
        this.responseHeaderValues = responseHeaderValues;
        this.status = status;
        if (responseBody != null) {
            this.setResponseBody(responseBody, isMedia);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String[] getResponseHeaderNames() {
        return this.responseHeaderNames;
    }

    void setResponseHeaderNames(String[] responseHeaderNames) {
        this.responseHeaderNames = responseHeaderNames;
    }

    public String[] getResponseHeaderValues() {
        return this.responseHeaderValues;
    }

    void setResponseHeaderValues(String[] responseHeaderValues) {
        this.responseHeaderValues = responseHeaderValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseBody() {
        if (this.httpEntityContent == null) {
            if (this.httpEntityStream == null) {
                return null;
            }
            StoreResponse storeResponse = this;
            synchronized (storeResponse) {
                Scanner s = new Scanner(this.httpEntityStream, Charsets.UTF_8.toString()).useDelimiter("\\A");
                this.httpEntityContent = s.hasNext() ? s.next() : "";
            }
        }
        return this.httpEntityContent;
    }

    public InputStream getResponseStream() {
        return this.httpEntityStream;
    }

    private void setResponseBody(HttpEntity responseBody, boolean isMedia) {
        if (responseBody == null) {
            throw new IllegalArgumentException("responseBody");
        }
        try {
            this.httpEntityStream = isMedia && responseBody.isStreaming() ? responseBody.getContent() : new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)responseBody));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty((CharSequence)lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getContinuation() {
        return this.getHeaderValue("x-ms-continuation");
    }

    public String getHeaderValue(String attribute) {
        if (this.responseHeaderValues == null || this.responseHeaderNames.length != this.responseHeaderValues.length) {
            return null;
        }
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            if (!this.responseHeaderNames[i].equals(attribute)) continue;
            return this.responseHeaderValues[i];
        }
        return null;
    }

    public static StoreResponse fromHttpResponse(HttpResponse httpResponse, boolean isMedia) {
        Header[] allHeaders = httpResponse.getAllHeaders();
        String[] headers = new String[allHeaders.length];
        String[] values = new String[allHeaders.length];
        for (int i = 0; i < allHeaders.length; ++i) {
            headers[i] = allHeaders[i].getName();
            values[i] = allHeaders[i].getValue();
        }
        StoreResponse storeResponse = new StoreResponse(headers, values, httpResponse.getStatusLine().getStatusCode(), httpResponse.getEntity(), isMedia);
        if (!isMedia) {
            try {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to consume HttpResponse.", e);
            }
        }
        return storeResponse;
    }
}

