/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import com.microsoft.azure.documentdb.internal.SessionTokenHelper;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReadReplicaResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;

class StoreReader {
    private static final SecureRandom random = new SecureRandom();
    private final AddressCache addressCache;
    private final TransportClient transportClient;
    private final SessionContainer sessionContainer;
    private final ExecutorService executorService;
    private String lastReadAddress;

    public StoreReader(AddressCache addressCache, TransportClient transportClient, SessionContainer sessionContainer, ExecutorService executorService) {
        this.addressCache = addressCache;
        this.transportClient = transportClient;
        this.sessionContainer = sessionContainer;
        this.executorService = executorService;
    }

    private static int generateNextRandom(int maxValue) {
        if ((double)random.nextFloat() < 0.001) {
            random.setSeed(random.generateSeed(32));
        }
        return random.nextInt(maxValue);
    }

    StoreReadResult readEventual(DocumentServiceRequest request) throws DocumentClientException {
        request.getHeaders().remove("x-ms-session-token");
        ArrayList<String> resolvedEndpoints = this.getEndpointAddresses(request, true);
        if (resolvedEndpoints.size() == 0) {
            return null;
        }
        StoreReadResult result = this.readOneReplica(request, resolvedEndpoints);
        request.getRequestChargeTracker().addCharge(result.getRequestCharge());
        return result;
    }

    StoreReadResult readSession(DocumentServiceRequest request) throws DocumentClientException {
        ArrayList<String> resolvedEndpoints = this.getEndpointAddresses(request, true);
        if (resolvedEndpoints.size() == 0) {
            return null;
        }
        SessionTokenHelper.setPartitionLocalSessionToken(request, this.sessionContainer);
        long minLsnRequired = request.getSessionLsn();
        StoreReadResult readExceptionResult = null;
        while (resolvedEndpoints.size() > 0) {
            StoreReadResult replicaReadResult = this.readOneReplica(request, resolvedEndpoints);
            request.getRequestChargeTracker().addCharge(replicaReadResult.getRequestCharge());
            if (replicaReadResult.isGoneException()) {
                throw replicaReadResult.getExcetpion();
            }
            if (minLsnRequired <= 0L || replicaReadResult.getLSN() >= minLsnRequired) {
                return replicaReadResult;
            }
            if (replicaReadResult.getExcetpion() == null) continue;
            readExceptionResult = replicaReadResult;
        }
        return readExceptionResult;
    }

    StoreReadResult readPrimary(DocumentServiceRequest request, boolean requiresValidLsn) throws DocumentClientException {
        ReadReplicaResult readQuorumResult = this.readPrimaryImpl(request, requiresValidLsn);
        if (readQuorumResult.isRetryWithForceRefresh() && !request.isForceAddressRefresh()) {
            request.setForceAddressRefresh(true);
            readQuorumResult = this.readPrimaryImpl(request, requiresValidLsn);
        }
        if (readQuorumResult.getResponses().size() == 0) {
            throw new DocumentClientException(410, "The requested resource is no longer available at the server.");
        }
        return readQuorumResult.getResponses().get(0);
    }

    List<StoreReadResult> readMultipleReplica(DocumentServiceRequest request, boolean includePrimary, int replicaCountToRead) throws DocumentClientException {
        LinkedList<StoreReadResult> storeReadResults = new LinkedList<StoreReadResult>();
        ExecutorCompletionService<StoreReadResult> completionService = new ExecutorCompletionService<StoreReadResult>(this.executorService);
        ArrayList<String> resolvedEndpoints = this.getEndpointAddresses(request, includePrimary);
        if (resolvedEndpoints.size() < replicaCountToRead) {
            return storeReadResults;
        }
        request.getHeaders().remove("x-ms-session-token");
        for (int i = 0; i < replicaCountToRead; ++i) {
            int uriIndex = StoreReader.generateNextRandom(resolvedEndpoints.size());
            Callable<StoreReadResult> callable = this.getReadReplicaCallable(request, resolvedEndpoints.get(uriIndex));
            resolvedEndpoints.remove(uriIndex);
            completionService.submit(callable);
        }
        for (int received = 0; received < replicaCountToRead; ++received) {
            try {
                Future resultFuture = completionService.take();
                StoreReadResult result = (StoreReadResult)resultFuture.get();
                request.getRequestChargeTracker().addCharge(result.getRequestCharge());
                storeReadResults.add(result);
                continue;
            }
            catch (Exception e) {
                throw new DocumentClientException(500, e);
            }
        }
        return storeReadResults;
    }

    private ReadReplicaResult readPrimaryImpl(DocumentServiceRequest request, boolean requiresValidLsn) throws DocumentClientException {
        URI primaryUri = ReplicatedResourceClient.resolvePrimaryUri(request, this.addressCache);
        request.getHeaders().remove("x-ms-session-token");
        StoreReadResult storeReadResult = this.createStoreReadResult(request, primaryUri.toString());
        request.getRequestChargeTracker().addCharge(storeReadResult.getRequestCharge());
        if (storeReadResult.isGoneException()) {
            return new ReadReplicaResult(true, new ArrayList<StoreReadResult>());
        }
        return new ReadReplicaResult(false, Arrays.asList(storeReadResult));
    }

    private StoreReadResult readOneReplica(DocumentServiceRequest request, ArrayList<String> resolvedEndpoints) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        if (resolvedEndpoints == null || resolvedEndpoints.size() == 0) {
            throw new IllegalArgumentException("resolveEndpoints");
        }
        int uriIndex = StoreReader.generateNextRandom(resolvedEndpoints.size());
        String endpoint = resolvedEndpoints.get(uriIndex);
        resolvedEndpoints.remove(uriIndex);
        return this.createStoreReadResult(request, endpoint);
    }

    private ArrayList<String> getEndpointAddresses(DocumentServiceRequest request, boolean includePrimary) throws DocumentClientException {
        AddressInformation[] addresses = this.addressCache.resolve(request);
        ArrayList<String> resolvedEndpoints = new ArrayList<String>();
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i].isPrimary() && !includePrimary) continue;
            resolvedEndpoints.add(addresses[i].getPhysicalUri());
        }
        return resolvedEndpoints;
    }

    private Callable<StoreReadResult> getReadReplicaCallable(final DocumentServiceRequest request, final String endpointAddress) {
        Callable<StoreReadResult> callable = new Callable<StoreReadResult>(){

            @Override
            public StoreReadResult call() {
                return StoreReader.this.createStoreReadResult(request, endpointAddress);
            }
        };
        return callable;
    }

    private StoreReadResult createStoreReadResult(DocumentServiceRequest request, String endpointAddress) {
        String currentRequestChargeHeaderValue;
        String currentWriteQuorumHeaderValue;
        String currentReplicaSetSizeHeaderValue;
        StoreResponse storeResponse = null;
        DocumentClientException storeException = null;
        try {
            storeResponse = this.readFromStore(request, endpointAddress);
        }
        catch (DocumentClientException e) {
            storeException = e;
        }
        long quorumAckedLSN = -1L;
        int currentReplicaSetSize = -1;
        int currentWriteQuorum = -1;
        double requestCharge = 0.0;
        long lsn = -1L;
        if (storeException != null) {
            String lsnValue;
            String currentRequestChargeHeaderValue2;
            String currentReplicaSetSizeHeaderValue2;
            Map<String, String> headers = storeException.getResponseHeaders();
            if (headers == null) {
                return new StoreReadResult(storeResponse, storeException, lsn, null, quorumAckedLSN, requestCharge, currentReplicaSetSize, currentWriteQuorum, false);
            }
            String quorumAckedLsnHeaderValue = headers.get("x-ms-quorum-acked-lsn");
            if (!StringUtils.isEmpty((CharSequence)quorumAckedLsnHeaderValue)) {
                quorumAckedLSN = Long.parseLong(quorumAckedLsnHeaderValue);
            }
            if (!StringUtils.isEmpty((CharSequence)(currentReplicaSetSizeHeaderValue2 = headers.get("x-ms-current-replica-set-size")))) {
                currentReplicaSetSize = Integer.parseInt(currentReplicaSetSizeHeaderValue2);
            }
            String currentWriteQuorumHeaderValue2 = headers.get("x-ms-current-write-quorum");
            if (!StringUtils.isEmpty((CharSequence)currentReplicaSetSizeHeaderValue2)) {
                currentWriteQuorum = Integer.parseInt(currentWriteQuorumHeaderValue2);
            }
            if (!StringUtils.isEmpty((CharSequence)(currentRequestChargeHeaderValue2 = headers.get("x-ms-request-charge")))) {
                requestCharge = Double.parseDouble(currentRequestChargeHeaderValue2);
            }
            if (!StringUtils.isEmpty((CharSequence)(lsnValue = headers.get("lsn")))) {
                lsn = Long.parseLong(lsnValue);
            }
            return new StoreReadResult(storeResponse, storeException, lsn, null, quorumAckedLSN, requestCharge, currentReplicaSetSize, currentWriteQuorum, false);
        }
        String quorumAckedLsnHeaderValue = storeResponse.getHeaderValue("x-ms-quorum-acked-lsn");
        if (!StringUtils.isEmpty((CharSequence)quorumAckedLsnHeaderValue)) {
            quorumAckedLSN = Long.parseLong(quorumAckedLsnHeaderValue);
        }
        if (!StringUtils.isEmpty((CharSequence)(currentReplicaSetSizeHeaderValue = storeResponse.getHeaderValue("x-ms-current-replica-set-size")))) {
            currentReplicaSetSize = Integer.parseInt(currentReplicaSetSizeHeaderValue);
        }
        if (!StringUtils.isEmpty((CharSequence)(currentWriteQuorumHeaderValue = storeResponse.getHeaderValue("x-ms-current-write-quorum")))) {
            currentWriteQuorum = Integer.parseInt(currentWriteQuorumHeaderValue);
        }
        if (!StringUtils.isEmpty((CharSequence)(currentRequestChargeHeaderValue = storeResponse.getHeaderValue("x-ms-request-charge")))) {
            requestCharge = Double.parseDouble(currentRequestChargeHeaderValue);
        }
        lsn = storeResponse.getLSN();
        boolean isValid = true;
        return new StoreReadResult(storeResponse, storeException, lsn, storeResponse.getPartitionKeyRangeId(), quorumAckedLSN, requestCharge, currentReplicaSetSize, currentWriteQuorum, isValid);
    }

    private StoreResponse readFromStore(DocumentServiceRequest request, String address) throws DocumentClientException {
        Object parts;
        String continuation = null;
        if (request.getOperationType() == OperationType.ReadFeed || request.getOperationType() == OperationType.Query || request.getOperationType() == OperationType.SqlQuery) {
            continuation = request.getHeaders().get("x-ms-continuation");
            if (continuation != null && continuation.contains(";")) {
                parts = continuation.split(";");
                if (((String[])parts).length < 3) {
                    throw new DocumentClientException(400, "Invalid header value");
                }
                continuation = parts[0];
            }
            request.setContinuation(continuation);
        }
        try {
            parts = this.transportClient.invokeResourceOperation(new URI(address), request);
            return parts;
        }
        catch (URISyntaxException e) {
            throw new DocumentClientException(500, e);
        }
        finally {
            this.lastReadAddress = address;
        }
    }

    public String getLastReadAddress() {
        return this.lastReadAddress;
    }

    public void setLastReadAddress(String lastReadAddress) {
        this.lastReadAddress = lastReadAddress;
    }
}

