/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import com.microsoft.azure.documentdb.internal.Utils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionReadRetryPolicy
implements RetryPolicy {
    private static int maxRetryCount = 1;
    private final int retryIntervalInMS = 0;
    private final Logger logger = LoggerFactory.getLogger(SessionReadRetryPolicy.class);
    private final DocumentServiceRequest currentRequest;
    private final EndpointManager globalEndpointManager;
    private int currentAttempt = 0;

    public SessionReadRetryPolicy(EndpointManager globalEndpointManager, DocumentServiceRequest request) {
        this.globalEndpointManager = globalEndpointManager;
        this.currentRequest = request;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        this.getClass();
        return 0L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        if (this.currentAttempt >= maxRetryCount) {
            return false;
        }
        boolean shouldRetry = false;
        if (!Utils.isWriteOperation(this.currentRequest.getOperationType()) && this.currentRequest.getEndpointOverride() == null && !StringUtils.equalsIgnoreCase((CharSequence)this.globalEndpointManager.getReadEndpoint().toString(), (CharSequence)this.globalEndpointManager.getWriteEndpoint().toString())) {
            this.logger.debug("Read with session token not available in read region. Try read from write region.");
            this.currentRequest.setEndpointOverride(this.globalEndpointManager.getWriteEndpoint());
            shouldRetry = true;
            ++this.currentAttempt;
        }
        return shouldRetry;
    }
}

