/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.PathInfo;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceId;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.GatewayAddressCache;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public final class SessionContainer {
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, Long>> collectionResourceIdToSessionTokens;
    private final ConcurrentHashMap<String, Long> collectionNameToCollectionResourceId;
    private final String hostName;

    public SessionContainer(String hostName) {
        this.hostName = hostName;
        this.collectionResourceIdToSessionTokens = new ConcurrentHashMap();
        this.collectionNameToCollectionResourceId = new ConcurrentHashMap();
    }

    public String getHostName() {
        return this.hostName;
    }

    private String resolveSessionToken(boolean isNameBased, String rId, String path) {
        String result = "";
        if (!isNameBased) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)rId) && (resourceId = ResourceId.parse(rId)).getDocumentCollection() != 0) {
                result = this.getCombinedSessionToken(this.collectionResourceIdToSessionTokens.get(resourceId.getUniqueDocumentCollectionId()));
            }
        } else {
            String collectionName = Utils.getCollectionName(path);
            if (!StringUtils.isEmpty((CharSequence)collectionName) && this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                result = this.getCombinedSessionToken(this.collectionResourceIdToSessionTokens.get(this.collectionNameToCollectionResourceId.get(collectionName)));
            }
        }
        return result;
    }

    public String resolveSessionToken(DocumentServiceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request");
        }
        return this.resolveSessionToken(request.getIsNameBased(), request.getResourceId(), request.getPath());
    }

    public String resolveSessionToken(String collectionLink) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        PathInfo pathInfo = PathsHelper.parsePathSegments(collectionLink);
        if (pathInfo == null) {
            return "";
        }
        return this.resolveSessionToken(pathInfo.isNameBased, pathInfo.resourceIdOrFullName, pathInfo.resourceIdOrFullName);
    }

    public void clearToken(DocumentServiceRequest request, DocumentServiceResponse response) {
        Long collectionResourceId = null;
        if (!request.getIsNameBased()) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)request.getResourceId()) && (resourceId = ResourceId.parse(request.getResourceId())).getDocumentCollection() != 0) {
                collectionResourceId = resourceId.getUniqueDocumentCollectionId();
            }
        } else {
            String collectionName = Utils.getCollectionName(request.getPath());
            if (!StringUtils.isEmpty((CharSequence)collectionName)) {
                collectionResourceId = this.collectionNameToCollectionResourceId.get(collectionName);
                this.collectionNameToCollectionResourceId.remove(collectionName);
            }
        }
        if (collectionResourceId != null) {
            this.collectionResourceIdToSessionTokens.remove(collectionResourceId);
        }
    }

    public void setSessionToken(DocumentServiceRequest request, DocumentServiceResponse response) {
        String sessionToken;
        if (response != null && !GatewayAddressCache.isReadingFromMaster(request.getResourceType(), request.getOperationType()) && !StringUtils.isEmpty((CharSequence)(sessionToken = response.getResponseHeaders().get("x-ms-session-token")))) {
            ResourceId resourceId;
            String ownerFullName = response.getResponseHeaders().get("x-ms-alt-content-path");
            String ownerId = response.getResponseHeaders().get("x-ms-content-path");
            String collectionName = Utils.getCollectionName(ownerFullName);
            if (!request.getIsNameBased()) {
                ownerId = request.getResourceId();
            }
            if (!StringUtils.isEmpty((CharSequence)ownerId) && (resourceId = ResourceId.parse(ownerId)).getDocumentCollection() != 0 && !StringUtils.isEmpty((CharSequence)collectionName)) {
                Long uniqueDocumentCollectionId = resourceId.getUniqueDocumentCollectionId();
                this.collectionResourceIdToSessionTokens.putIfAbsent(uniqueDocumentCollectionId, new ConcurrentHashMap());
                this.compareAndSetToken(sessionToken, this.collectionResourceIdToSessionTokens.get(uniqueDocumentCollectionId));
                this.collectionNameToCollectionResourceId.putIfAbsent(collectionName, uniqueDocumentCollectionId);
            }
        }
    }

    private String getCombinedSessionToken(ConcurrentHashMap<String, Long> tokens) {
        StringBuilder result = new StringBuilder();
        if (tokens != null) {
            Iterator<Map.Entry<String, Long>> iterator = tokens.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Long> entry = iterator.next();
                result = result.append(entry.getKey()).append(":").append(entry.getValue());
                if (!iterator.hasNext()) continue;
                result = result.append(",");
            }
        }
        return result.toString();
    }

    private void compareAndSetToken(String newToken, ConcurrentHashMap<String, Long> oldTokens) {
        String[] newTokenParts;
        if (StringUtils.isNotEmpty((CharSequence)newToken) && (newTokenParts = newToken.split(":")).length == 2) {
            Boolean success;
            String range = newTokenParts[0];
            Long newLSN = Long.parseLong(newTokenParts[1]);
            do {
                Long oldLSN;
                if ((success = Boolean.valueOf((oldLSN = oldTokens.putIfAbsent(range, newLSN)) == null || newLSN < oldLSN)).booleanValue()) continue;
                success = oldTokens.replace(range, oldLSN, newLSN);
            } while (!success.booleanValue());
        }
    }
}

