/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.routing.ClientCollectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PartitionKeyMismatchRetryPolicy
implements RetryPolicy {
    private static int maxRetryCount = 1;
    private final int retryIntervalInMS = 0;
    private final Logger logger = LoggerFactory.getLogger(PartitionKeyMismatchRetryPolicy.class);
    private final ClientCollectionCache clientCollectionCache;
    private String resourcePath;
    private int currentAttempt = 0;

    public PartitionKeyMismatchRetryPolicy(String resourcePath, ClientCollectionCache clientCollectionCache) {
        this.resourcePath = resourcePath;
        this.clientCollectionCache = clientCollectionCache;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        this.getClass();
        return 0L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        if (this.currentAttempt >= maxRetryCount) {
            return false;
        }
        this.logger.debug("Partition key definition changed. Refresh partition key definition map and retry.");
        String collectionLink = Utils.getCollectionName(this.resourcePath);
        this.clientCollectionCache.refresh(collectionLink);
        ++this.currentAttempt;
        return true;
    }
}

