/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EndpointDiscoveryRetryPolicy
implements RetryPolicy {
    private static int maxRetryCount = 120;
    private final Logger logger = LoggerFactory.getLogger(EndpointDiscoveryRetryPolicy.class);
    private final int retryIntervalInMS = 1000;
    private final EndpointManager globalEndpointManager;
    private final ConnectionPolicy connectionPolicy;
    private int currentAttempt = 0;

    public EndpointDiscoveryRetryPolicy(ConnectionPolicy connectionPolicy, EndpointManager globalEndpointManager) {
        this.connectionPolicy = connectionPolicy;
        this.globalEndpointManager = globalEndpointManager;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        this.getClass();
        return 1000L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        if (!this.connectionPolicy.getEnableEndpointDiscovery()) {
            return false;
        }
        if (this.currentAttempt >= maxRetryCount) {
            return false;
        }
        this.logger.debug("Write region changed, refresh region list and retry after {} milliseconds", (Object)this.retryIntervalInMS);
        this.globalEndpointManager.refreshEndpointList();
        ++this.currentAttempt;
        return true;
    }
}

