/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.Conflict;
import com.microsoft.azure.documentdb.Database;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.Offer;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.Permission;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.StoredProcedure;
import com.microsoft.azure.documentdb.Trigger;
import com.microsoft.azure.documentdb.User;
import com.microsoft.azure.documentdb.UserDefinedFunction;
import com.microsoft.azure.documentdb.internal.directconnectivity.Address;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreResponse;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public final class DocumentServiceResponse {
    private int statusCode;
    private Map<String, String> headersMap = new HashMap<String, String>();
    private StoreResponse storeResponse;

    public DocumentServiceResponse(HttpResponse httpResponse, boolean isMedia) {
        this(StoreResponse.fromHttpResponse(httpResponse, isMedia));
    }

    public DocumentServiceResponse(StoreResponse response) {
        this.statusCode = response.getStatus();
        for (int i = 0; i < response.getResponseHeaderNames().length; ++i) {
            if (response.getResponseHeaderNames()[i].equals("lsn")) continue;
            this.headersMap.put(response.getResponseHeaderNames()[i], response.getResponseHeaderValues()[i]);
        }
        this.storeResponse = response;
    }

    public static <T extends Resource> String getResourceKey(Class<T> c) {
        if (c.equals(Attachment.class)) {
            return "Attachments";
        }
        if (c.equals(Conflict.class)) {
            return "Conflicts";
        }
        if (c.equals(Database.class)) {
            return "Databases";
        }
        if (Document.class.isAssignableFrom(c)) {
            return "Documents";
        }
        if (c.equals(DocumentCollection.class)) {
            return "DocumentCollections";
        }
        if (c.equals(Offer.class)) {
            return "Offers";
        }
        if (c.equals(PartitionKeyRange.class)) {
            return "PartitionKeyRanges";
        }
        if (c.equals(Permission.class)) {
            return "Permissions";
        }
        if (c.equals(Trigger.class)) {
            return "Triggers";
        }
        if (c.equals(StoredProcedure.class)) {
            return "StoredProcedures";
        }
        if (c.equals(User.class)) {
            return "Users";
        }
        if (c.equals(UserDefinedFunction.class)) {
            return "UserDefinedFunctions";
        }
        if (c.equals(Address.class)) {
            return "Addresss";
        }
        if (c.equals(PartitionKeyRange.class)) {
            return "PartitionKeyRanges";
        }
        throw new IllegalArgumentException("c");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.headersMap;
    }

    public String getReponseBodyAsString() {
        return this.storeResponse.getResponseBody();
    }

    public <T extends Resource> T getResource(Class<T> c) {
        String responseBody = this.getReponseBodyAsString();
        if (responseBody == null) {
            return null;
        }
        try {
            return (T)((Resource)c.getConstructor(String.class).newInstance(responseBody));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate class object.", e);
        }
    }

    public <T extends Resource> List<T> getQueryResponse(Class<T> c) {
        String responseBody = this.getReponseBodyAsString();
        if (responseBody == null) {
            return new ArrayList();
        }
        JSONObject jobject = new JSONObject(responseBody);
        String resourceKey = DocumentServiceResponse.getResourceKey(c);
        JSONArray jTokenArray = jobject.getJSONArray(resourceKey);
        ArrayList<Resource> queryResults = new ArrayList<Resource>();
        if (jTokenArray != null) {
            for (int i = 0; i < jTokenArray.length(); ++i) {
                JSONObject jToken = jTokenArray.getJSONObject(i);
                Resource resource = null;
                try {
                    resource = (Resource)c.getConstructor(String.class).newInstance(jToken.toString());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalStateException("Failed to instantiate class object.", e);
                }
                queryResults.add(resource);
            }
        }
        return queryResults;
    }

    public InputStream getContentStream() {
        return this.storeResponse.getResponseStream();
    }
}

