/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.documentdb.internal.RequestChargeTracker;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.StoreReadResult;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public final class DocumentServiceRequest {
    private String resourceId;
    private ResourceType resourceType;
    private String path;
    private String queryString;
    private HttpEntity body;
    private Map<String, String> headers;
    private String continuation;
    private boolean isMedia = false;
    private boolean isNameBased = false;
    private OperationType operationType;
    private String resourceAddress;
    private boolean forceNameCacheRefresh;
    private boolean forceAddressRefresh;
    private long sessionLsn;
    private URI endpointOverride = null;
    private String activityId;
    private RequestChargeTracker requestChargeTracker;
    private String resourceFullName;
    private StoreReadResult quorumSelectedStoreResponse;
    private long quorumSelectedLSN;
    private String resolvedCollectionRid;
    private PartitionKeyRangeIdentity partitionKeyRangeIdentity;
    private String resolvedPartitionKeyRangeId;
    private Integer defaultReplicaIndex;

    private DocumentServiceRequest(OperationType operationType, String resourceId, ResourceType resourceType, HttpEntity body, String path, Map<String, String> headers) {
        this.operationType = operationType;
        this.resourceType = resourceType;
        this.path = path;
        this.sessionLsn = -1L;
        this.body = body;
        this.headers = headers != null ? headers : new HashMap();
        this.isNameBased = Utils.isNameBased(path);
        this.activityId = UUID.randomUUID().toString();
        if (!this.isNameBased) {
            this.resourceId = resourceType == ResourceType.Media ? DocumentServiceRequest.getAttachmentIdFromMediaId(resourceId) : resourceId;
            this.resourceAddress = resourceId;
        } else {
            this.resourceAddress = this.path;
        }
    }

    private DocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, HttpEntity body, Map<String, String> headers) {
        this(operationType, DocumentServiceRequest.extractIdFromUri(path), resourceType, body, path, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, InputStream stream, Map<String, String> headers) {
        InputStreamEntity body = new InputStreamEntity(stream, -1L);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers) {
        StringEntity body = new StringEntity(resource.toJson(), StandardCharsets.UTF_8);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, String query, Map<String, String> headers) {
        StringEntity body = new StringEntity(query, StandardCharsets.UTF_8);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(ResourceType resourceType, String relativePath, SqlQuerySpec querySpec, QueryCompatibilityMode queryCompatibilityMode, Map<String, String> headers) {
        String queryText;
        OperationType operation;
        switch (queryCompatibilityMode) {
            case SqlQuery: {
                if (querySpec.getParameters() != null && querySpec.getParameters().size() > 0) {
                    throw new IllegalArgumentException(String.format("Unsupported argument in query compatibility mode '{%s}'", queryCompatibilityMode.name()));
                }
                operation = OperationType.SqlQuery;
                queryText = querySpec.getQueryText();
                break;
            }
            default: {
                operation = OperationType.Query;
                queryText = querySpec.toJson();
            }
        }
        StringEntity body = new StringEntity(queryText, StandardCharsets.UTF_8);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        return new DocumentServiceRequest(operation, resourceType, relativePath, null, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers) {
        String path = PathsHelper.generatePath(resourceType, resourceId, Utils.isFeedRequest(operation));
        return new DocumentServiceRequest(operation, resourceId, resourceType, null, path, headers);
    }

    static String extractIdFromUri(String path) {
        String[] pathParts;
        if (path.length() == 0) {
            return path;
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        if ((pathParts = (path = path + '=').split("/")).length % 2 == 0) {
            return pathParts[pathParts.length - 2];
        }
        return pathParts[pathParts.length - 3];
    }

    static String getAttachmentIdFromMediaId(String mediaId) {
        String attachmentId;
        byte[] buffer = Base64.decodeBase64((byte[])mediaId.replace('-', '/').getBytes());
        int resoureIdLength = 20;
        if (buffer.length > 20) {
            byte[] newBuffer = new byte[20];
            System.arraycopy(buffer, 0, newBuffer, 0, 20);
            attachmentId = Utils.encodeBase64String(newBuffer).replace('/', '-');
        } else {
            attachmentId = mediaId;
        }
        return attachmentId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HttpEntity getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean getIsMedia() {
        return this.isMedia;
    }

    public void setIsMedia(boolean isMedia) {
        this.isMedia = isMedia;
    }

    public boolean getIsNameBased() {
        return this.isNameBased;
    }

    void setIsNameBased(boolean isNameBased) {
        this.isNameBased = isNameBased;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public String getResourceAddress() {
        return this.resourceAddress;
    }

    public void setResourceAddress(String resourceAddress) {
        this.resourceAddress = resourceAddress;
    }

    public boolean isForceNameCacheRefresh() {
        return this.forceNameCacheRefresh;
    }

    public void setForceNameCacheRefresh(boolean forceNameCacheRefresh) {
        this.forceNameCacheRefresh = forceNameCacheRefresh;
    }

    public boolean isForceAddressRefresh() {
        return this.forceAddressRefresh;
    }

    public void setForceAddressRefresh(boolean forceAddressRefresh) {
        this.forceAddressRefresh = forceAddressRefresh;
    }

    public long getSessionLsn() {
        return this.sessionLsn;
    }

    public void setSessionLsn(long sessionLsn) {
        this.sessionLsn = sessionLsn;
    }

    public URI getEndpointOverride() {
        return this.endpointOverride;
    }

    public void setEndpointOverride(URI endpointOverride) {
        this.endpointOverride = endpointOverride;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public RequestChargeTracker getRequestChargeTracker() {
        return this.requestChargeTracker;
    }

    public void setRequestChargeTracker(RequestChargeTracker requestChargeTracker) {
        this.requestChargeTracker = requestChargeTracker;
    }

    public String getResourceFullName() {
        if (this.isNameBased) {
            String trimmedPath = Utils.trimBeginingAndEndingSlashes(this.path);
            String[] segments = trimmedPath.split("/");
            if (segments.length % 2 == 0) {
                if (Utils.IsResourceType(segments[segments.length - 2])) {
                    this.resourceFullName = trimmedPath;
                }
            } else if (Utils.IsResourceType(segments[segments.length - 1])) {
                this.resourceFullName = trimmedPath.substring(0, trimmedPath.lastIndexOf("/"));
            }
        } else {
            this.resourceFullName = this.getResourceId().toLowerCase();
        }
        return this.resourceFullName;
    }

    public String getResolvedCollectionRid() {
        return this.resolvedCollectionRid;
    }

    public void setResolvedCollectionRid(String resolvedCollectionRid) {
        this.resolvedCollectionRid = resolvedCollectionRid;
    }

    public PartitionKeyRangeIdentity getPartitionKeyRangeIdentity() {
        return this.partitionKeyRangeIdentity;
    }

    public void routeTo(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.setPartitionKeyRangeIdentity(partitionKeyRangeIdentity);
    }

    private void setPartitionKeyRangeIdentity(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        this.partitionKeyRangeIdentity = partitionKeyRangeIdentity;
        if (partitionKeyRangeIdentity != null) {
            this.headers.put("x-ms-documentdb-partitionkeyrangeid", partitionKeyRangeIdentity.toHeader());
        } else {
            this.headers.remove("x-ms-documentdb-partitionkeyrangeid");
        }
    }

    public String getResolvedPartitionKeyRangeId() {
        return this.resolvedPartitionKeyRangeId;
    }

    public void setResolvedPartitionKeyRangeId(String resolvedPartitionKeyRangeId) {
        this.resolvedPartitionKeyRangeId = resolvedPartitionKeyRangeId;
    }

    public long getQuorumSelectedLSN() {
        return this.quorumSelectedLSN;
    }

    public void setQuorumSelectedLSN(long quorumSelectedLSN) {
        this.quorumSelectedLSN = quorumSelectedLSN;
    }

    public StoreReadResult getQuorumSelectedStoreResponse() {
        return this.quorumSelectedStoreResponse;
    }

    public void setQuorumSelectedStoreResponse(StoreReadResult quorumSelectedStoreResponse) {
        this.quorumSelectedStoreResponse = quorumSelectedStoreResponse;
    }

    public void setDefaultReplicaIndex(Integer defaultReplicaIndex) {
        this.defaultReplicaIndex = defaultReplicaIndex;
    }

    public Integer getDefaultReplicaIndex() {
        return this.defaultReplicaIndex;
    }
}

