/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ResourceResponse<T extends Resource> {
    private Class<T> cls;
    private T resource;
    private DocumentServiceResponse response;
    private Map<String, Long> usageHeaders;
    private Map<String, Long> quotaHeaders;

    ResourceResponse(DocumentServiceResponse response, Class<T> cls) {
        this.response = response;
        this.usageHeaders = new HashMap<String, Long>();
        this.quotaHeaders = new HashMap<String, Long>();
        this.cls = cls;
        this.resource = this.response.getResource(this.cls);
    }

    public long getDatabaseQuota() {
        return this.getMaxQuotaHeader("databases");
    }

    public long getDatabaseUsage() {
        return this.getCurrentQuotaHeader("databases");
    }

    public long getCollectionQuota() {
        return this.getMaxQuotaHeader("collections");
    }

    public long getCollectionUsage() {
        return this.getCurrentQuotaHeader("collections");
    }

    public long getUserQuota() {
        return this.getMaxQuotaHeader("users");
    }

    public long getUserUsage() {
        return this.getCurrentQuotaHeader("users");
    }

    public long getPermissionQuota() {
        return this.getMaxQuotaHeader("permissions");
    }

    public long getPermissionUsage() {
        return this.getCurrentQuotaHeader("permissions");
    }

    public long getCollectionSizeQuota() {
        return this.getMaxQuotaHeader("collectionSize");
    }

    public long getCollectionSizeUsage() {
        return this.getCurrentQuotaHeader("collectionSize");
    }

    public long getDocumentQuota() {
        return this.getMaxQuotaHeader("documentsSize");
    }

    public long getDocumentUsage() {
        return this.getCurrentQuotaHeader("documentsSize");
    }

    public long getStoredProceduresQuota() {
        return this.getMaxQuotaHeader("storedProcedures");
    }

    public long getStoredProceduresUsage() {
        return this.getCurrentQuotaHeader("storedProcedures");
    }

    public long getTriggersQuota() {
        return this.getMaxQuotaHeader("triggers");
    }

    public long getTriggersUsage() {
        return this.getCurrentQuotaHeader("triggers");
    }

    public long getUserDefinedFunctionsQuota() {
        return this.getMaxQuotaHeader("functions");
    }

    public long getUserDefinedFunctionsUsage() {
        return this.getCurrentQuotaHeader("functions");
    }

    public String getActivityId() {
        return this.response.getResponseHeaders().get("x-ms-activity-id");
    }

    public String getSessionToken() {
        return this.response.getResponseHeaders().get("x-ms-session-token");
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getMaxResourceQuota() {
        return this.response.getResponseHeaders().get("x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return this.response.getResponseHeaders().get("x-ms-resource-usage");
    }

    public T getResource() {
        return this.resource;
    }

    public double getRequestCharge() {
        String value = this.getResponseHeaders().get("x-ms-request-charge");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0.0;
        }
        return Double.valueOf(value);
    }

    public Map<String, String> getResponseHeaders() {
        return this.response.getResponseHeaders();
    }

    public long getIndexTransformationProgress() {
        String value = this.getResponseHeaders().get("x-ms-documentdb-collection-index-transformation-progress");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    public long getLazyIndexingProgress() {
        String value = this.getResponseHeaders().get("x-ms-documentdb-collection-lazy-indexing-progress");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    @Deprecated
    public void close() {
    }

    private long getCurrentQuotaHeader(String headerName) {
        if (this.usageHeaders.size() == 0 && !this.getMaxResourceQuota().isEmpty() && !this.getCurrentResourceQuotaUsage().isEmpty()) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.usageHeaders.containsKey(headerName)) {
            return this.usageHeaders.get(headerName);
        }
        return 0L;
    }

    private long getMaxQuotaHeader(String headerName) {
        if (this.quotaHeaders.size() == 0 && !this.getMaxResourceQuota().isEmpty() && !this.getCurrentResourceQuotaUsage().isEmpty()) {
            this.populateQuotaHeader(this.getMaxResourceQuota(), this.getCurrentResourceQuotaUsage());
        }
        if (this.quotaHeaders.containsKey(headerName)) {
            return this.quotaHeaders.get(headerName);
        }
        return 0L;
    }

    private void populateQuotaHeader(String headerMaxQuota, String headerCurrentUsage) {
        String[] headerMaxQuotaWords = headerMaxQuota.split("=|;", -1);
        String[] headerCurrentUsageWords = headerCurrentUsage.split("=|;", -1);
        assert (headerMaxQuotaWords.length == headerCurrentUsageWords.length);
        for (int i = 0; i < headerMaxQuotaWords.length; ++i) {
            if (headerMaxQuotaWords[i].equalsIgnoreCase("databases")) {
                this.quotaHeaders.put("databases", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("databases", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collections")) {
                this.quotaHeaders.put("collections", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collections", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("users")) {
                this.quotaHeaders.put("users", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("users", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("permissions")) {
                this.quotaHeaders.put("permissions", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("permissions", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("collectionSize")) {
                this.quotaHeaders.put("collectionSize", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("collectionSize", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("documentsSize")) {
                this.quotaHeaders.put("documentsSize", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("documentsSize", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("storedProcedures")) {
                this.quotaHeaders.put("storedProcedures", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("storedProcedures", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (headerMaxQuotaWords[i].equalsIgnoreCase("triggers")) {
                this.quotaHeaders.put("triggers", Long.valueOf(headerMaxQuotaWords[i + 1]));
                this.usageHeaders.put("triggers", Long.valueOf(headerCurrentUsageWords[i + 1]));
                continue;
            }
            if (!headerMaxQuotaWords[i].equalsIgnoreCase("functions")) continue;
            this.quotaHeaders.put("functions", Long.valueOf(headerMaxQuotaWords[i + 1]));
            this.usageHeaders.put("functions", Long.valueOf(headerCurrentUsageWords[i + 1]));
        }
    }
}

