/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.utils;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ReturnRequestIdHeaderInterceptor
implements Interceptor {
    private static final String NAME_RETURN_CLIENT_REQUEST_ID = "x-ms-return-client-request-id";
    private static final String NAME_CLIENT_REQUEST_ID = "x-ms-client-request-id";
    private final Option option;

    public ReturnRequestIdHeaderInterceptor() {
        this(Option.NONE);
    }

    public ReturnRequestIdHeaderInterceptor(Option option) {
        this.option = option;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String clientRequestId = request.header(NAME_CLIENT_REQUEST_ID);
        if (request.header(NAME_RETURN_CLIENT_REQUEST_ID) == null) {
            request = chain.request().newBuilder().header(NAME_RETURN_CLIENT_REQUEST_ID, "true").build();
        }
        Response response = chain.proceed(request);
        if (this.option == Option.COPY_CLIENT_REQUEST_ID && clientRequestId != null && response.header(NAME_CLIENT_REQUEST_ID) == null) {
            response = response.newBuilder().addHeader(NAME_CLIENT_REQUEST_ID, clientRequestId).build();
        }
        return response;
    }

    public static enum Option {
        NONE,
        COPY_CLIENT_REQUEST_ID;

    }
}

