/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensionUpdate;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMExtensionInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMExtensionsListResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachineScaleSetVMExtensionsInner {
    private VirtualMachineScaleSetVMExtensionsService service;
    private ComputeManagementClientImpl client;

    public VirtualMachineScaleSetVMExtensionsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachineScaleSetVMExtensionsService)retrofit.create(VirtualMachineScaleSetVMExtensionsService.class);
        this.client = client;
    }

    public VirtualMachineScaleSetVMExtensionInner createOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return (VirtualMachineScaleSetVMExtensionInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).toBlocking().last()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, ServiceCallback<VirtualMachineScaleSetVMExtensionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner>(){

            public VirtualMachineScaleSetVMExtensionInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionInner> response) {
                return (VirtualMachineScaleSetVMExtensionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (extensionParameters == null) {
            throw new IllegalArgumentException("Parameter extensionParameters is required and cannot be null.");
        }
        Validator.validate((Object)extensionParameters);
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), extensionParameters, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineScaleSetVMExtensionInner>(){}.getType());
    }

    public VirtualMachineScaleSetVMExtensionInner beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return (VirtualMachineScaleSetVMExtensionInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, ServiceCallback<VirtualMachineScaleSetVMExtensionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner>(){

            public VirtualMachineScaleSetVMExtensionInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionInner> response) {
                return (VirtualMachineScaleSetVMExtensionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (extensionParameters == null) {
            throw new IllegalArgumentException("Parameter extensionParameters is required and cannot be null.");
        }
        Validator.validate((Object)extensionParameters);
        String apiVersion = "2020-12-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), extensionParameters, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>>>(){

            public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineScaleSetVMExtensionInner>(){}.getType()).register(201, new TypeToken<VirtualMachineScaleSetVMExtensionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineScaleSetVMExtensionInner update(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return (VirtualMachineScaleSetVMExtensionInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).toBlocking().last()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, ServiceCallback<VirtualMachineScaleSetVMExtensionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner>(){

            public VirtualMachineScaleSetVMExtensionInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionInner> response) {
                return (VirtualMachineScaleSetVMExtensionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> updateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (extensionParameters == null) {
            throw new IllegalArgumentException("Parameter extensionParameters is required and cannot be null.");
        }
        Validator.validate((Object)extensionParameters);
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), extensionParameters, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineScaleSetVMExtensionInner>(){}.getType());
    }

    public VirtualMachineScaleSetVMExtensionInner beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return (VirtualMachineScaleSetVMExtensionInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, ServiceCallback<VirtualMachineScaleSetVMExtensionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner>(){

            public VirtualMachineScaleSetVMExtensionInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionInner> response) {
                return (VirtualMachineScaleSetVMExtensionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (extensionParameters == null) {
            throw new IllegalArgumentException("Parameter extensionParameters is required and cannot be null.");
        }
        Validator.validate((Object)extensionParameters);
        String apiVersion = "2020-12-01";
        return this.service.beginUpdate(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), extensionParameters, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>>>(){

            public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineScaleSetVMExtensionInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineScaleSetVMExtensionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.beginDelete(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineScaleSetVMExtensionInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        return (VirtualMachineScaleSetVMExtensionInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, ServiceCallback<VirtualMachineScaleSetVMExtensionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner>(){

            public VirtualMachineScaleSetVMExtensionInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionInner> response) {
                return (VirtualMachineScaleSetVMExtensionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> getWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        return this.service.get(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>>>(){

            public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualMachineScaleSetVMExtensionInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand) {
        return (VirtualMachineScaleSetVMExtensionInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand, ServiceCallback<VirtualMachineScaleSetVMExtensionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner>(){

            public VirtualMachineScaleSetVMExtensionInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionInner> response) {
                return (VirtualMachineScaleSetVMExtensionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> getWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (vmExtensionName == null) {
            throw new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.get(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>>>(){

            public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineScaleSetVMExtensionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineScaleSetVMExtensionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineScaleSetVMExtensionsListResultInner list(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return (VirtualMachineScaleSetVMExtensionsListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionsListResultInner> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, ServiceCallback<VirtualMachineScaleSetVMExtensionsListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionsListResultInner> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>, VirtualMachineScaleSetVMExtensionsListResultInner>(){

            public VirtualMachineScaleSetVMExtensionsListResultInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner> response) {
                return (VirtualMachineScaleSetVMExtensionsListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>> listWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        String expand = null;
        return this.service.list(resourceGroupName, vmScaleSetName, instanceId, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>>>(){

            public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualMachineScaleSetVMExtensionsListResultInner list(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        return (VirtualMachineScaleSetVMExtensionsListResultInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).toBlocking().single()).body();
    }

    public ServiceFuture<VirtualMachineScaleSetVMExtensionsListResultInner> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand, ServiceCallback<VirtualMachineScaleSetVMExtensionsListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand), serviceCallback);
    }

    public Observable<VirtualMachineScaleSetVMExtensionsListResultInner> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        return this.listWithServiceResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).map((Func1)new Func1<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>, VirtualMachineScaleSetVMExtensionsListResultInner>(){

            public VirtualMachineScaleSetVMExtensionsListResultInner call(ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner> response) {
                return (VirtualMachineScaleSetVMExtensionsListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>> listWithServiceResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmScaleSetName == null) {
            throw new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null.");
        }
        if (instanceId == null) {
            throw new IllegalArgumentException("Parameter instanceId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2020-12-01";
        return this.service.list(resourceGroupName, vmScaleSetName, instanceId, this.client.subscriptionId(), expand, "2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>>>(){

            public Observable<ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachineScaleSetVMExtensionsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineScaleSetVMExtensionsListResultInner> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineScaleSetVMExtensionsListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachineScaleSetVMExtensionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineScaleSetVMExtensionInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineScaleSetVMExtensionInner var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineScaleSetVMExtensionUpdate var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Body VirtualMachineScaleSetVMExtensionUpdate var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="vmExtensionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="$expand") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachineScaleSetVMExtensions list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="vmScaleSetName") String var2, @Path(value="instanceId") String var3, @Path(value="subscriptionId") String var4, @Query(value="$expand") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

