/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.SubResource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.CachingTypes;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.HyperVGenerationTypes;
import com.microsoft.azure.management.compute.ImageDataDisk;
import com.microsoft.azure.management.compute.ImageOSDisk;
import com.microsoft.azure.management.compute.ImageStorageProfile;
import com.microsoft.azure.management.compute.OperatingSystemStateTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Snapshot;
import com.microsoft.azure.management.compute.VirtualMachine;
import com.microsoft.azure.management.compute.VirtualMachineCustomImage;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.CustomImageDataDiskImpl;
import com.microsoft.azure.management.compute.implementation.ImageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rx.Observable;

@LangDefinition
class VirtualMachineCustomImageImpl
extends GroupableResourceImpl<VirtualMachineCustomImage, ImageInner, VirtualMachineCustomImageImpl, ComputeManager>
implements VirtualMachineCustomImage,
VirtualMachineCustomImage.Definition {
    VirtualMachineCustomImageImpl(String name, ImageInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
        ((ImageInner)((Object)this.inner())).withHyperVGeneration(HyperVGenerationTypes.V1);
    }

    @Override
    public boolean isCreatedFromVirtualMachine() {
        return this.sourceVirtualMachineId() != null;
    }

    @Override
    public HyperVGenerationTypes hyperVGeneration() {
        return ((ImageInner)((Object)this.inner())).hyperVGeneration();
    }

    @Override
    public String sourceVirtualMachineId() {
        if (((ImageInner)((Object)this.inner())).sourceVirtualMachine() == null) {
            return null;
        }
        return ((ImageInner)((Object)this.inner())).sourceVirtualMachine().id();
    }

    @Override
    public ImageOSDisk osDiskImage() {
        if (((ImageInner)((Object)this.inner())).storageProfile() == null) {
            return null;
        }
        return ((ImageInner)((Object)this.inner())).storageProfile().osDisk();
    }

    @Override
    public Map<Integer, ImageDataDisk> dataDiskImages() {
        if (((ImageInner)((Object)this.inner())).storageProfile() == null || ((ImageInner)((Object)this.inner())).storageProfile().dataDisks() == null) {
            return Collections.unmodifiableMap(new HashMap());
        }
        HashMap<Integer, ImageDataDisk> diskImages = new HashMap<Integer, ImageDataDisk>();
        for (ImageDataDisk dataDisk : ((ImageInner)((Object)this.inner())).storageProfile().dataDisks()) {
            diskImages.put(dataDisk.lun(), dataDisk);
        }
        return Collections.unmodifiableMap(diskImages);
    }

    @Override
    public VirtualMachineCustomImageImpl fromVirtualMachine(String virtualMachineId) {
        ((ImageInner)((Object)this.inner())).withSourceVirtualMachine(new SubResource().withId(virtualMachineId));
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl fromVirtualMachine(VirtualMachine virtualMachine) {
        return this.fromVirtualMachine(virtualMachine.id());
    }

    @Override
    public VirtualMachineCustomImageImpl withWindowsFromVhd(String sourceVhdUrl, OperatingSystemStateTypes osState) {
        this.ensureOsDiskImage().withOsState(osState).withOsType(OperatingSystemTypes.WINDOWS).withBlobUri(sourceVhdUrl);
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withLinuxFromVhd(String sourceVhdUrl, OperatingSystemStateTypes osState) {
        this.ensureOsDiskImage().withOsState(osState).withOsType(OperatingSystemTypes.LINUX).withBlobUri(sourceVhdUrl);
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withWindowsFromSnapshot(String sourceSnapshotId, OperatingSystemStateTypes osState) {
        this.ensureOsDiskImage().withOsState(osState).withOsType(OperatingSystemTypes.WINDOWS).withSnapshot(new SubResource().withId(sourceSnapshotId));
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withLinuxFromSnapshot(String sourceSnapshotId, OperatingSystemStateTypes osState) {
        this.ensureOsDiskImage().withOsState(osState).withOsType(OperatingSystemTypes.LINUX).withSnapshot(new SubResource().withId(sourceSnapshotId));
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withWindowsFromSnapshot(Snapshot sourceSnapshot, OperatingSystemStateTypes osState) {
        return this.withWindowsFromSnapshot(sourceSnapshot.id(), osState);
    }

    @Override
    public VirtualMachineCustomImageImpl withLinuxFromSnapshot(Snapshot sourceSnapshot, OperatingSystemStateTypes osState) {
        return this.withLinuxFromSnapshot(sourceSnapshot.id(), osState);
    }

    @Override
    public VirtualMachineCustomImageImpl withWindowsFromDisk(String sourceManagedDiskId, OperatingSystemStateTypes osState) {
        this.ensureOsDiskImage().withOsState(osState).withOsType(OperatingSystemTypes.WINDOWS).withManagedDisk(new SubResource().withId(sourceManagedDiskId));
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withLinuxFromDisk(String sourceManagedDiskId, OperatingSystemStateTypes osState) {
        this.ensureOsDiskImage().withOsState(osState).withOsType(OperatingSystemTypes.LINUX).withManagedDisk(new SubResource().withId(sourceManagedDiskId));
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withWindowsFromDisk(Disk sourceManagedDisk, OperatingSystemStateTypes osState) {
        return this.withWindowsFromDisk(sourceManagedDisk.id(), osState);
    }

    @Override
    public VirtualMachineCustomImageImpl withLinuxFromDisk(Disk sourceManagedDisk, OperatingSystemStateTypes osState) {
        return this.withLinuxFromDisk(sourceManagedDisk.id(), osState);
    }

    @Override
    public VirtualMachineCustomImageImpl withDataDiskImageFromVhd(String sourceVhdUrl) {
        this.defineDataDiskImage().withLun(-1).fromVhd(sourceVhdUrl).attach();
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withDataDiskImageFromSnapshot(String sourceSnapshotId) {
        this.defineDataDiskImage().withLun(-1).fromSnapshot(sourceSnapshotId).attach();
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withDataDiskImageFromManagedDisk(String sourceManagedDiskId) {
        this.defineDataDiskImage().withLun(-1).fromManagedDisk(sourceManagedDiskId).attach();
        return this;
    }

    public CustomImageDataDiskImpl defineDataDiskImage() {
        return new CustomImageDataDiskImpl(new ImageDataDisk(), this);
    }

    @Override
    public VirtualMachineCustomImageImpl withOSDiskSizeInGB(int diskSizeGB) {
        this.ensureOsDiskImage().withDiskSizeGB(diskSizeGB);
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withOSDiskCaching(CachingTypes cachingType) {
        this.ensureOsDiskImage().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineCustomImageImpl withZoneResilient() {
        this.ensureStorageProfile().withZoneResilient(true);
        return this;
    }

    public Observable<VirtualMachineCustomImage> createResourceAsync() {
        this.ensureDefaultLuns();
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).images().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ImageInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ImageInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).images().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private ImageOSDisk ensureOsDiskImage() {
        this.ensureStorageProfile();
        if (((ImageInner)((Object)this.inner())).storageProfile().osDisk() == null) {
            ((ImageInner)((Object)this.inner())).storageProfile().withOsDisk(new ImageOSDisk());
        }
        return ((ImageInner)((Object)this.inner())).storageProfile().osDisk();
    }

    private ImageStorageProfile ensureStorageProfile() {
        if (((ImageInner)((Object)this.inner())).storageProfile() == null) {
            ((ImageInner)((Object)this.inner())).withStorageProfile(new ImageStorageProfile());
        }
        return ((ImageInner)((Object)this.inner())).storageProfile();
    }

    private void ensureDefaultLuns() {
        if (((ImageInner)((Object)this.inner())).storageProfile() != null && ((ImageInner)((Object)this.inner())).storageProfile().dataDisks() != null) {
            List<ImageDataDisk> imageDisks = ((ImageInner)((Object)this.inner())).storageProfile().dataDisks();
            ArrayList<Integer> usedLuns = new ArrayList<Integer>();
            for (ImageDataDisk imageDisk : imageDisks) {
                if (imageDisk.lun() == -1) continue;
                usedLuns.add(imageDisk.lun());
            }
            if (usedLuns.size() == imageDisks.size()) {
                return;
            }
            for (ImageDataDisk imageDisk : imageDisks) {
                if (imageDisk.lun() != -1) continue;
                Integer i = 0;
                while (usedLuns.contains(i)) {
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                imageDisk.withLun(i);
                usedLuns.add(i);
            }
        }
    }

    VirtualMachineCustomImageImpl withCustomImageDataDisk(CustomImageDataDiskImpl customImageDataDisk) {
        if (((ImageInner)((Object)this.inner())).storageProfile() == null) {
            ((ImageInner)((Object)this.inner())).withStorageProfile(new ImageStorageProfile());
        }
        if (((ImageInner)((Object)this.inner())).storageProfile().dataDisks() == null) {
            ((ImageInner)((Object)this.inner())).storageProfile().withDataDisks(new ArrayList<ImageDataDisk>());
        }
        ((ImageInner)((Object)this.inner())).storageProfile().dataDisks().add((ImageDataDisk)customImageDataDisk.inner());
        return this;
    }

    @Override
    public VirtualMachineCustomImage.DefinitionStages.WithOSDiskImageSourceAltVirtualMachineSource withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        ((ImageInner)((Object)this.inner())).withHyperVGeneration(hyperVGeneration);
        return this;
    }
}

