/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeOperationValueInner;
import com.microsoft.azure.management.compute.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class OperationsInner {
    private OperationsService service;
    private ComputeManagementClientImpl client;

    public OperationsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (OperationsService)retrofit.create(OperationsService.class);
        this.client = client;
    }

    public List<ComputeOperationValueInner> list() {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<ComputeOperationValueInner>> listAsync(ServiceCallback<List<ComputeOperationValueInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<List<ComputeOperationValueInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<ComputeOperationValueInner>>, List<ComputeOperationValueInner>>(){

            public List<ComputeOperationValueInner> call(ServiceResponse<List<ComputeOperationValueInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ComputeOperationValueInner>>> listWithServiceResponseAsync() {
        String apiVersion = "2020-12-01";
        return this.service.list("2020-12-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ComputeOperationValueInner>>>>(){

            public Observable<ServiceResponse<List<ComputeOperationValueInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = OperationsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ComputeOperationValueInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ComputeOperationValueInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface OperationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.Operations list"})
        @GET(value="providers/Microsoft.Compute/operations")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

