/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PrivateLinkResourceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PrivateLinkResourcesInner {
    private PrivateLinkResourcesService service;
    private CosmosDBImpl client;

    public PrivateLinkResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (PrivateLinkResourcesService)retrofit.create(PrivateLinkResourcesService.class);
        this.client = client;
    }

    public List<PrivateLinkResourceInner> listByDatabaseAccount(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listByDatabaseAccountWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<PrivateLinkResourceInner>> listByDatabaseAccountAsync(String resourceGroupName, String accountName, ServiceCallback<List<PrivateLinkResourceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByDatabaseAccountWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<PrivateLinkResourceInner>> listByDatabaseAccountAsync(String resourceGroupName, String accountName) {
        return this.listByDatabaseAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<PrivateLinkResourceInner>>, List<PrivateLinkResourceInner>>(){

            public List<PrivateLinkResourceInner> call(ServiceResponse<List<PrivateLinkResourceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<PrivateLinkResourceInner>>> listByDatabaseAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01-preview";
        return this.service.listByDatabaseAccount(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<List<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkResourcesInner.this.listByDatabaseAccountDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkResourceInner>> listByDatabaseAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateLinkResourceInner get(String resourceGroupName, String accountName, String groupName) {
        return (PrivateLinkResourceInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, groupName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateLinkResourceInner> getAsync(String resourceGroupName, String accountName, String groupName, ServiceCallback<PrivateLinkResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, groupName), serviceCallback);
    }

    public Observable<PrivateLinkResourceInner> getAsync(String resourceGroupName, String accountName, String groupName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, groupName).map((Func1)new Func1<ServiceResponse<PrivateLinkResourceInner>, PrivateLinkResourceInner>(){

            public PrivateLinkResourceInner call(ServiceResponse<PrivateLinkResourceInner> response) {
                return (PrivateLinkResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkResourceInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String groupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("Parameter groupName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01-preview";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, groupName, "2019-08-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceInner>>>(){

            public Observable<ServiceResponse<PrivateLinkResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkResourcesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkResourceInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.PrivateLinkResources listByDatabaseAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/privateLinkResources")
        public Observable<Response<ResponseBody>> listByDatabaseAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.PrivateLinkResources get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/privateLinkResources/{groupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="groupName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

