/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.implementation.ApplicationStackResourceInner;
import com.microsoft.azure.management.appservice.implementation.CsmOperationDescriptionInner;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ProvidersInner {
    private ProvidersService service;
    private WebSiteManagementClientImpl client;

    public ProvidersInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (ProvidersService)retrofit.create(ProvidersService.class);
        this.client = client;
    }

    public PagedList<ApplicationStackResourceInner> getAvailableStacks() {
        ServiceResponse response = (ServiceResponse)this.getAvailableStacksSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>((Page)response.body()){

            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationStackResourceInner>> getAvailableStacksAsync(ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getAvailableStacksSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                return ProvidersInner.this.getAvailableStacksNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationStackResourceInner>> getAvailableStacksAsync() {
        return this.getAvailableStacksWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>(){

            public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksWithServiceResponseAsync() {
        return this.getAvailableStacksSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.getAvailableStacksNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String osTypeSelected = null;
        return this.service.getAvailableStacks(osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.getAvailableStacksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ApplicationStackResourceInner> getAvailableStacks(String osTypeSelected) {
        ServiceResponse response = (ServiceResponse)this.getAvailableStacksSinglePageAsync(osTypeSelected).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>((Page)response.body()){

            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationStackResourceInner>> getAvailableStacksAsync(String osTypeSelected, ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getAvailableStacksSinglePageAsync(osTypeSelected), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                return ProvidersInner.this.getAvailableStacksNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationStackResourceInner>> getAvailableStacksAsync(String osTypeSelected) {
        return this.getAvailableStacksWithServiceResponseAsync(osTypeSelected).map((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>(){

            public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksWithServiceResponseAsync(String osTypeSelected) {
        return this.getAvailableStacksSinglePageAsync(osTypeSelected).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.getAvailableStacksNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksSinglePageAsync(String osTypeSelected) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAvailableStacks(osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.getAvailableStacksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> getAvailableStacksDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<CsmOperationDescriptionInner> listOperations() {
        ServiceResponse response = (ServiceResponse)this.listOperationsSinglePageAsync().toBlocking().single();
        return new PagedList<CsmOperationDescriptionInner>((Page)response.body()){

            public Page<CsmOperationDescriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CsmOperationDescriptionInner>> listOperationsAsync(ListOperationCallback<CsmOperationDescriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOperationsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CsmOperationDescriptionInner>> listOperationsAsync() {
        return this.listOperationsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Page<CsmOperationDescriptionInner>>(){

            public Page<CsmOperationDescriptionInner> call(ServiceResponse<Page<CsmOperationDescriptionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsWithServiceResponseAsync() {
        return this.listOperationsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(ServiceResponse<Page<CsmOperationDescriptionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listOperationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listOperations(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listOperationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CsmOperationDescriptionInner>> listOperationsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CsmOperationDescriptionInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ApplicationStackResourceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>((Page)response.body()){

            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationStackResourceInner>> listAsync(ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationStackResourceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>(){

            public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String osTypeSelected = null;
        return this.service.list(this.client.subscriptionId(), osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ApplicationStackResourceInner> list(String osTypeSelected) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(osTypeSelected).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>((Page)response.body()){

            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationStackResourceInner>> listAsync(String osTypeSelected, ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(osTypeSelected), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationStackResourceInner>> listAsync(String osTypeSelected) {
        return this.listWithServiceResponseAsync(osTypeSelected).map((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>(){

            public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listWithServiceResponseAsync(String osTypeSelected) {
        return this.listSinglePageAsync(osTypeSelected).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listSinglePageAsync(String osTypeSelected) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), osTypeSelected, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ApplicationStackResourceInner> getAvailableStacksNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>((Page)response.body()){

            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.getAvailableStacksNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationStackResourceInner>> getAvailableStacksNextAsync(String nextPageLink, ServiceFuture<List<ApplicationStackResourceInner>> serviceFuture, ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.getAvailableStacksNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                return ProvidersInner.this.getAvailableStacksNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationStackResourceInner>> getAvailableStacksNextAsync(String nextPageLink) {
        return this.getAvailableStacksNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>(){

            public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksNextWithServiceResponseAsync(String nextPageLink) {
        return this.getAvailableStacksNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.getAvailableStacksNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> getAvailableStacksNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.getAvailableStacksNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.getAvailableStacksNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> getAvailableStacksNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<CsmOperationDescriptionInner> listOperationsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CsmOperationDescriptionInner>((Page)response.body()){

            public Page<CsmOperationDescriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CsmOperationDescriptionInner>> listOperationsNextAsync(String nextPageLink, ServiceFuture<List<CsmOperationDescriptionInner>> serviceFuture, ListOperationCallback<CsmOperationDescriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOperationsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CsmOperationDescriptionInner>> listOperationsNextAsync(String nextPageLink) {
        return this.listOperationsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Page<CsmOperationDescriptionInner>>(){

            public Page<CsmOperationDescriptionInner> call(ServiceResponse<Page<CsmOperationDescriptionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listOperationsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(ServiceResponse<Page<CsmOperationDescriptionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listOperationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listOperationsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listOperationsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CsmOperationDescriptionInner>> listOperationsNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CsmOperationDescriptionInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<ApplicationStackResourceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationStackResourceInner>((Page)response.body()){

            public Page<ApplicationStackResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationStackResourceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationStackResourceInner>> serviceFuture, ListOperationCallback<ApplicationStackResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationStackResourceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Page<ApplicationStackResourceInner>>(){

            public Page<ApplicationStackResourceInner> call(ServiceResponse<Page<ApplicationStackResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationStackResourceInner>>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(ServiceResponse<Page<ApplicationStackResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationStackResourceInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationStackResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationStackResourceInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationStackResourceInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    static interface ProvidersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacks"})
        @GET(value="providers/Microsoft.Web/availableStacks")
        public Observable<Response<ResponseBody>> getAvailableStacks(@Query(value="osTypeSelected") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listOperations"})
        @GET(value="providers/Microsoft.Web/operations")
        public Observable<Response<ResponseBody>> listOperations(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="osTypeSelected") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacksNext"})
        @GET
        public Observable<Response<ResponseBody>> getAvailableStacksNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listOperationsNext"})
        @GET
        public Observable<Response<ResponseBody>> listOperationsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

