/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.management.appservice.DeployType;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseBuilder;
import com.microsoft.rest.protocol.ResponseBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.Streaming;
import rx.Completable;
import rx.Emitter;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;

class KuduClient {
    private final RestClient restClient;
    private final KuduService service;

    KuduClient(WebAppBase webAppBase) {
        if (webAppBase.defaultHostName() == null) {
            throw new UnsupportedOperationException("Cannot initialize kudu client before web app is created");
        }
        String host = webAppBase.defaultHostName().toLowerCase().replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = Joiner.on((char)'.').join((Object)parts[0], (Object)"scm", new Object[]{parts[1]});
        this.restClient = ((AppServiceManager)((Object)webAppBase.manager())).restClient().newBuilder().withBaseUrl("https://" + host).withConnectionTimeout(3L, TimeUnit.MINUTES).withReadTimeout(3L, TimeUnit.MINUTES).build();
        this.service = (KuduService)this.restClient.retrofit().create(KuduService.class);
    }

    Observable<String> streamApplicationLogsAsync() {
        return this.service.streamApplicationLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamHttpLogsAsync() {
        return this.service.streamHttpLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamTraceLogsAsync() {
        return this.service.streamTraceLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamDeploymentLogsAsync() {
        return this.service.streamDeploymentLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    Observable<String> streamAllLogsAsync() {
        return this.service.streamAllLogs().flatMap((Func1)new Func1<ResponseBody, Observable<String>>(){

            public Observable<String> call(ResponseBody responseBody) {
                BufferedSource source = responseBody.source();
                return KuduClient.this.streamFromBufferedSource(source);
            }
        });
    }

    private Observable<String> streamFromBufferedSource(final BufferedSource source) {
        return Observable.create((Action1)new Action1<Emitter<String>>(){

            public void call(Emitter<String> stringEmitter) {
                try {
                    while (!source.exhausted()) {
                        stringEmitter.onNext((Object)source.readUtf8Line());
                    }
                    stringEmitter.onCompleted();
                }
                catch (IOException e) {
                    stringEmitter.onError((Throwable)e);
                }
            }
        }, (Emitter.BackpressureMode)Emitter.BackpressureMode.BUFFER);
    }

    Completable warDeployAsync(InputStream warFile, String appName) {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])ByteStreams.toByteArray((InputStream)warFile));
            Observable<ServiceResponse<Void>> response = this.retryOnError(this.handleResponse(this.service.warDeploy(body, appName)));
            return response.toCompletable();
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    Completable zipDeployAsync(InputStream zipFile) {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])ByteStreams.toByteArray((InputStream)zipFile));
            Observable<ServiceResponse<Void>> response = this.retryOnError(this.handleResponse(this.service.zipDeploy(body)));
            return response.toCompletable();
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    Completable deployAsync(DeployType type, InputStream file, String path, Boolean restart, Boolean clean) {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])ByteStreams.toByteArray((InputStream)file));
            Observable<ServiceResponse<Void>> response = this.retryOnError(this.handleResponse(this.service.deploy(body, type, path, restart, clean)));
            return response.toCompletable();
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    Observable<Map<String, String>> settings() {
        return this.retryOnError(this.service.settings().flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Map<String, String>>>>(){

            public Observable<ServiceResponse<Map<String, String>>> call(Response<ResponseBody> response) {
                try {
                    ResponseBuilder responseBuilder = KuduClient.this.restClient.responseBuilderFactory().newInstance(KuduClient.this.restClient.serializerAdapter());
                    if (responseBuilder instanceof AzureResponseBuilder) {
                        ((AzureResponseBuilder)responseBuilder).withThrowOnGet404(true);
                    } else if (responseBuilder instanceof ServiceResponseBuilder) {
                        ((ServiceResponseBuilder)responseBuilder).withThrowOnGet404(true);
                    }
                    ServiceResponse clientResponse = responseBuilder.register(200, new TypeToken<Map<String, String>>(){}.getType()).registerError(RestException.class).build(response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        }).map((Func1)new Func1<ServiceResponse<Map<String, String>>, Map<String, String>>(){

            public Map<String, String> call(ServiceResponse<Map<String, String>> response) {
                return (Map)response.body();
            }
        }));
    }

    private Observable<ServiceResponse<Void>> handleResponse(Observable<Response<ResponseBody>> observable) {
        return observable.flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    String errorBody;
                    if (response.isSuccessful()) {
                        return Observable.just((Object)new ServiceResponse(null, response));
                    }
                    String errorMessage = "Status code " + response.code();
                    if (response.errorBody() != null && response.errorBody().contentType() != null && Objects.equals("text", response.errorBody().contentType().type()) && !(errorBody = response.errorBody().string()).isEmpty()) {
                        errorMessage = errorBody;
                    }
                    return Observable.error((Throwable)new RestException(errorMessage, response));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private <T> Observable<T> retryOnError(Observable<T> observable) {
        int retryCount = 6;
        return observable.retryWhen(new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Throwable> observable) {
                return observable.zipWith(Observable.range((int)1, (int)6), (Func2)new Func2<Throwable, Integer, Integer>(){

                    public Integer call(Throwable throwable, Integer integer) {
                        if (integer < 6 && (throwable instanceof SocketTimeoutException || throwable instanceof RestException && ((RestException)throwable).response().code() == 502)) {
                            return integer;
                        }
                        throw Exceptions.propagate((Throwable)throwable);
                    }
                }).flatMap(new Func1<Integer, Observable<?>>(){

                    public Observable<?> call(Integer i) {
                        return Observable.timer((long)(i * 10), (TimeUnit)TimeUnit.SECONDS);
                    }
                });
            }
        });
    }

    private static interface KuduService {
        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamApplicationLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/application")
        @Streaming
        public Observable<ResponseBody> streamApplicationLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamHttpLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/http")
        @Streaming
        public Observable<ResponseBody> streamHttpLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamTraceLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/kudu/trace")
        @Streaming
        public Observable<ResponseBody> streamTraceLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamDeploymentLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream/kudu/deployment")
        @Streaming
        public Observable<ResponseBody> streamDeploymentLogs();

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps streamAllLogs", "x-ms-body-logging: false"})
        @GET(value="api/logstream")
        @Streaming
        public Observable<ResponseBody> streamAllLogs();

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps warDeploy", "x-ms-body-logging: false"})
        @POST(value="api/wardeploy")
        public Observable<Response<ResponseBody>> warDeploy(@Body RequestBody var1, @Query(value="name") String var2);

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps zipDeploy", "x-ms-body-logging: false"})
        @POST(value="api/zipdeploy")
        public Observable<Response<ResponseBody>> zipDeploy(@Body RequestBody var1);

        @Headers(value={"Content-Type: application/octet-stream", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps publish", "x-ms-body-logging: false"})
        @POST(value="api/publish")
        public Observable<Response<ResponseBody>> deploy(@Body RequestBody var1, @Query(value="type") DeployType var2, @Query(value="path") String var3, @Query(value="restart") Boolean var4, @Query(value="clean") Boolean var5);

        @Headers(value={"x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps settings"})
        @GET(value="api/settings")
        public Observable<Response<ResponseBody>> settings();
    }
}

