/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlot;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlots;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.FunctionAppImpl;
import com.microsoft.azure.management.appservice.implementation.FunctionDeploymentSlotImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionDeploymentSlotsImpl
extends IndependentChildResourcesImpl<FunctionDeploymentSlot, FunctionDeploymentSlotImpl, SiteInner, WebAppsInner, AppServiceManager, FunctionApp>
implements FunctionDeploymentSlots {
    private final PagedListConverter<SiteInner, FunctionDeploymentSlot> converter;
    private final FunctionAppImpl parent;

    FunctionDeploymentSlotsImpl(final FunctionAppImpl parent) {
        super((Object)((WebSiteManagementClientImpl)((Object)((AppServiceManager)parent.manager()).inner())).webApps(), parent.manager());
        this.parent = parent;
        final WebAppsInner innerCollection = (WebAppsInner)this.inner();
        this.converter = new PagedListConverter<SiteInner, FunctionDeploymentSlot>(){

            public Observable<FunctionDeploymentSlot> typeConvertAsync(final SiteInner siteInner) {
                return Observable.zip(innerCollection.getConfigurationSlotAsync(siteInner.resourceGroup(), parent.name(), siteInner.name().replaceAll(".*/", "")), innerCollection.getDiagnosticLogsConfigurationSlotAsync(siteInner.resourceGroup(), parent.name(), siteInner.name().replaceAll(".*/", "")), (Func2)new Func2<SiteConfigResourceInner, SiteLogsConfigInner, FunctionDeploymentSlot>(){

                    public FunctionDeploymentSlot call(SiteConfigResourceInner siteConfigResourceInner, SiteLogsConfigInner logsConfigInner) {
                        return FunctionDeploymentSlotsImpl.this.wrapModel(siteInner, siteConfigResourceInner, logsConfigInner);
                    }
                });
            }
        };
    }

    protected FunctionDeploymentSlotImpl wrapModel(String name) {
        return (FunctionDeploymentSlotImpl)((FunctionDeploymentSlotImpl)new FunctionDeploymentSlotImpl(name, new SiteInner(), null, null, this.parent).withRegion(this.parent.regionName())).withExistingResourceGroup(this.parent.resourceGroupName());
    }

    protected FunctionDeploymentSlotImpl wrapModel(SiteInner inner) {
        if (inner == null) {
            return null;
        }
        return this.wrapModel(inner, null, null);
    }

    protected PagedList<FunctionDeploymentSlot> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public FunctionDeploymentSlotImpl define(String name) {
        return this.wrapModel(name);
    }

    public Observable<FunctionDeploymentSlot> getByParentAsync(final String resourceGroup, final String parentName, final String name) {
        return ((WebAppsInner)this.innerCollection).getSlotAsync(resourceGroup, parentName, name).flatMap((Func1)new Func1<SiteInner, Observable<FunctionDeploymentSlot>>(){

            public Observable<FunctionDeploymentSlot> call(final SiteInner siteInner) {
                if (siteInner == null) {
                    return Observable.just(null);
                }
                return Observable.zip(((WebAppsInner)FunctionDeploymentSlotsImpl.this.innerCollection).getConfigurationSlotAsync(resourceGroup, parentName, name.replaceAll(".*/", "")), ((WebAppsInner)FunctionDeploymentSlotsImpl.this.innerCollection).getDiagnosticLogsConfigurationSlotAsync(resourceGroup, parentName, name.replaceAll(".*/", "")), (Func2)new Func2<SiteConfigResourceInner, SiteLogsConfigInner, FunctionDeploymentSlot>(){

                    public FunctionDeploymentSlot call(SiteConfigResourceInner siteConfigResourceInner, SiteLogsConfigInner logsConfigInner) {
                        return FunctionDeploymentSlotsImpl.this.wrapModel(siteInner, siteConfigResourceInner, logsConfigInner);
                    }
                });
            }
        });
    }

    public PagedList<FunctionDeploymentSlot> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((WebAppsInner)this.innerCollection).listSlots(resourceGroupName, parentName));
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        return ((WebAppsInner)this.innerCollection).deleteSlotAsync(groupName, parentName, name).toCompletable();
    }

    public void deleteByName(String name) {
        this.deleteByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public PagedList<FunctionDeploymentSlot> list() {
        return this.listByParent(this.parent.resourceGroupName(), this.parent.name());
    }

    public FunctionDeploymentSlot getByName(String name) {
        return (FunctionDeploymentSlot)this.getByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public FunctionApp parent() {
        return this.parent;
    }

    public Observable<FunctionDeploymentSlot> listAsync() {
        return FunctionDeploymentSlotsImpl.convertPageToInnerAsync(((WebAppsInner)this.innerCollection).listSlotsAsync(this.parent.resourceGroupName(), this.parent.name())).flatMap((Func1)new Func1<SiteInner, Observable<FunctionDeploymentSlot>>(){

            public Observable<FunctionDeploymentSlot> call(SiteInner siteInner) {
                return FunctionDeploymentSlotsImpl.this.converter.typeConvertAsync((Object)siteInner);
            }
        });
    }

    private FunctionDeploymentSlotImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new FunctionDeploymentSlotImpl(inner.name(), inner, siteConfig, logConfig, this.parent);
    }
}

