/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.DeployOptions;
import com.microsoft.azure.management.appservice.DeployType;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.DeploymentSlotBaseImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import rx.Completable;
import rx.exceptions.Exceptions;
import rx.functions.Action0;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class DeploymentSlotImpl
extends DeploymentSlotBaseImpl<DeploymentSlot, DeploymentSlotImpl, WebAppImpl, DeploymentSlot.DefinitionStages.WithCreate, DeploymentSlot.Update>
implements DeploymentSlot,
DeploymentSlot.Definition,
DeploymentSlot.Update {
    DeploymentSlotImpl(String name, SiteInner innerObject, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig, WebAppImpl parent) {
        super(name, innerObject, siteConfig, logConfig, parent);
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromParent() {
        return this.withConfigurationFromWebApp((WebApp)this.parent());
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromWebApp(WebApp webApp) {
        this.siteConfig = ((WebAppBaseImpl)((Object)webApp)).siteConfig;
        this.configurationSource = webApp;
        return this;
    }

    @Override
    public Completable warDeployAsync(File warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(File warFile) {
        this.warDeployAsync(warFile).await();
    }

    @Override
    public Completable warDeployAsync(InputStream warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(InputStream warFile) {
        this.warDeployAsync(warFile).await();
    }

    @Override
    public Completable warDeployAsync(File warFile, String appName) {
        try {
            final FileInputStream is = new FileInputStream(warFile);
            return this.warDeployAsync(new FileInputStream(warFile), appName).doAfterTerminate(new Action0(){

                public void call() {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Exceptions.propagate((Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void warDeploy(File warFile, String appName) {
        this.warDeployAsync(warFile, appName).await();
    }

    @Override
    public Completable warDeployAsync(InputStream warFile, String appName) {
        return this.kuduClient.warDeployAsync(warFile, appName);
    }

    @Override
    public void warDeploy(InputStream warFile, String appName) {
        this.warDeployAsync(warFile, appName).await();
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    public void zipDeploy(InputStream zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    public Completable zipDeployAsync(InputStream zipFile) {
        return this.kuduClient.zipDeployAsync(zipFile).concatWith(this.stopAsync()).concatWith(this.startAsync());
    }

    @Override
    public Completable zipDeployAsync(File zipFile) {
        try {
            final FileInputStream is = new FileInputStream(zipFile);
            return this.zipDeployAsync(new FileInputStream(zipFile)).doAfterTerminate(new Action0(){

                public void call() {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Exceptions.propagate((Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void deploy(DeployType type, File file) {
        this.deployAsync(type, file).await();
    }

    @Override
    public Completable deployAsync(DeployType type, File file) {
        return this.deployAsync(type, file, new DeployOptions());
    }

    @Override
    public void deploy(DeployType type, File file, DeployOptions deployOptions) {
        this.deployAsync(type, file, deployOptions).await();
    }

    @Override
    public Completable deployAsync(DeployType type, File file, DeployOptions deployOptions) {
        Objects.requireNonNull(file);
        try {
            final FileInputStream is = new FileInputStream(file);
            return this.deployAsync(type, new FileInputStream(file), deployOptions).doAfterTerminate(new Action0(){

                public void call() {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Exceptions.propagate((Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void deploy(DeployType type, InputStream file) {
        this.deployAsync(type, file).await();
    }

    @Override
    public Completable deployAsync(DeployType type, InputStream file) {
        return this.kuduClient.deployAsync(type, file, null, null, null);
    }

    @Override
    public void deploy(DeployType type, InputStream file, DeployOptions deployOptions) {
        this.deployAsync(type, file, deployOptions).await();
    }

    @Override
    public Completable deployAsync(DeployType type, InputStream file, DeployOptions deployOptions) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(file);
        if (deployOptions == null) {
            deployOptions = new DeployOptions();
        }
        return this.kuduClient.deployAsync(type, file, deployOptions.path(), deployOptions.restartSite(), deployOptions.cleanDeployment());
    }
}

