/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.appservice.Contact;
import com.microsoft.azure.management.appservice.DnsType;
import com.microsoft.azure.management.appservice.DomainContact;
import com.microsoft.azure.management.appservice.DomainPurchaseConsent;
import com.microsoft.azure.management.appservice.DomainStatus;
import com.microsoft.azure.management.appservice.HostName;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.DomainInner;
import com.microsoft.azure.management.dns.DnsZone;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasName;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import rx.Completable;

@Fluent(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
@Beta
public interface AppServiceDomain
extends GroupableResource<AppServiceManager, DomainInner>,
HasName,
Refreshable<AppServiceDomain>,
Updatable<Update> {
    public Contact adminContact();

    public Contact billingContact();

    public Contact registrantContact();

    public Contact techContact();

    public DomainStatus registrationStatus();

    public List<String> nameServers();

    public boolean privacy();

    public DateTime createdTime();

    public DateTime expirationTime();

    public DateTime lastRenewedTime();

    public boolean autoRenew();

    public boolean readyForDnsRecordManagement();

    public Map<String, HostName> managedHostNames();

    public DomainPurchaseConsent consent();

    public DnsType dnsType();

    public String dnsZoneId();

    public void verifyDomainOwnership(String var1, String var2);

    public Completable verifyDomainOwnershipAsync(String var1, String var2);

    public static interface Update
    extends Appliable<AppServiceDomain>,
    UpdateStages.WithAdminContact,
    UpdateStages.WithBillingContact,
    UpdateStages.WithTechContact,
    UpdateStages.WithAutoRenew,
    UpdateStages.WithDomainPrivacy,
    UpdateStages.WithDnsZone,
    Resource.UpdateWithTags<Update> {
    }

    public static interface UpdateStages {

        public static interface WithDnsZone {
            public Update withNewDnsZone(String var1);

            public Update withNewDnsZone(Creatable<DnsZone> var1);

            public Update withExistingDnsZone(String var1);

            public Update withExistingDnsZone(DnsZone var1);
        }

        public static interface WithAutoRenew {
            public Update withAutoRenewEnabled(boolean var1);
        }

        public static interface WithDomainPrivacy {
            public Update withDomainPrivacyEnabled(boolean var1);
        }

        public static interface WithTechContact {
            public Update withTechContact(Contact var1);
        }

        public static interface WithBillingContact {
            public Update withBillingContact(Contact var1);
        }

        public static interface WithAdminContact {
            public Update withAdminContact(Contact var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithDomainPrivacy,
        WithAutoRenew,
        WithAdminContact,
        WithBillingContact,
        WithTechContact,
        WithDnsZone,
        Creatable<AppServiceDomain>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithDnsZone {
            public WithCreate withNewDnsZone(String var1);

            public WithCreate withNewDnsZone(Creatable<DnsZone> var1);

            public WithCreate withExistingDnsZone(String var1);

            public WithCreate withExistingDnsZone(DnsZone var1);
        }

        public static interface WithAutoRenew {
            public WithCreate withAutoRenewEnabled(boolean var1);
        }

        public static interface WithDomainPrivacy {
            public WithCreate withDomainPrivacyEnabled(boolean var1);
        }

        public static interface WithTechContact {
            public WithCreate withTechContact(Contact var1);
        }

        public static interface WithRegistrantContact {
            public WithCreate withRegistrantContact(Contact var1);

            @Method
            public DomainContact.DefinitionStages.Blank<WithCreate> defineRegistrantContact();
        }

        public static interface WithBillingContact {
            public WithCreate withBillingContact(Contact var1);
        }

        public static interface WithAdminContact {
            public WithCreate withAdminContact(Contact var1);
        }

        public static interface Blank
        extends GroupableResource.DefinitionStages.WithExistingResourceGroup<WithRegistrantContact> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithAdminContact,
    DefinitionStages.WithBillingContact,
    DefinitionStages.WithRegistrantContact,
    DefinitionStages.WithTechContact,
    DefinitionStages.WithCreate {
    }
}

