/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.sql.VirtualClusterUpdate;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.VirtualClusterInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualClustersInner
implements InnerSupportsGet<VirtualClusterInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VirtualClusterInner> {
    private VirtualClustersService service;
    private SqlManagementClientImpl client;

    public VirtualClustersInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (VirtualClustersService)retrofit.create(VirtualClustersService.class);
        this.client = client;
    }

    public PagedList<VirtualClusterInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualClusterInner>((Page)response.body()){

            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualClusterInner>> listAsync(ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                return VirtualClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualClusterInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>(){

            public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.list(this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualClustersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualClusterInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualClusterInner>((Page)response.body()){

            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualClusterInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                return VirtualClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualClusterInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>(){

            public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualClustersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualClusterInner getByResourceGroup(String resourceGroupName, String virtualClusterName) {
        return (VirtualClusterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualClusterName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualClusterInner> getByResourceGroupAsync(String resourceGroupName, String virtualClusterName, ServiceCallback<VirtualClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualClusterName), serviceCallback);
    }

    public Observable<VirtualClusterInner> getByResourceGroupAsync(String resourceGroupName, String virtualClusterName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualClusterName).map((Func1)new Func1<ServiceResponse<VirtualClusterInner>, VirtualClusterInner>(){

            public VirtualClusterInner call(ServiceResponse<VirtualClusterInner> response) {
                return (VirtualClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualClusterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualClusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.getByResourceGroup(resourceGroupName, virtualClusterName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualClusterInner>>>(){

            public Observable<ServiceResponse<VirtualClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualClustersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualClusterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String virtualClusterName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualClusterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualClusterName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualClusterName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualClusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, virtualClusterName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualClusterName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualClusterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualClusterName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualClusterName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualClusterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualClusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2015-05-01-preview";
        return this.service.beginDelete(resourceGroupName, virtualClusterName, this.client.subscriptionId(), "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualClustersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualClusterInner update(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return (VirtualClusterInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualClusterInner> updateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters, ServiceCallback<VirtualClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters), serviceCallback);
    }

    public Observable<VirtualClusterInner> updateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).map((Func1)new Func1<ServiceResponse<VirtualClusterInner>, VirtualClusterInner>(){

            public VirtualClusterInner call(ServiceResponse<VirtualClusterInner> response) {
                return (VirtualClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualClusterInner>> updateWithServiceResponseAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, virtualClusterName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualClusterInner>(){}.getType());
    }

    public VirtualClusterInner beginUpdate(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return (VirtualClusterInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualClusterInner> beginUpdateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters, ServiceCallback<VirtualClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters), serviceCallback);
    }

    public Observable<VirtualClusterInner> beginUpdateAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, virtualClusterName, parameters).map((Func1)new Func1<ServiceResponse<VirtualClusterInner>, VirtualClusterInner>(){

            public VirtualClusterInner call(ServiceResponse<VirtualClusterInner> response) {
                return (VirtualClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualClusterInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String virtualClusterName, VirtualClusterUpdate parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualClusterName == null) {
            throw new IllegalArgumentException("Parameter virtualClusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2015-05-01-preview";
        return this.service.beginUpdate(resourceGroupName, virtualClusterName, this.client.subscriptionId(), parameters, "2015-05-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualClusterInner>>>(){

            public Observable<ServiceResponse<VirtualClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualClustersInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualClusterInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualClusterInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualClusterInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualClusterInner>((Page)response.body()){

            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualClusterInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualClusterInner>> serviceFuture, ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                return VirtualClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualClusterInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>(){

            public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualClustersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualClusterInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualClusterInner>((Page)response.body()){

            public Page<VirtualClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualClusterInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualClusterInner>> serviceFuture, ListOperationCallback<VirtualClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(String nextPageLink) {
                return VirtualClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualClusterInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Page<VirtualClusterInner>>(){

            public Page<VirtualClusterInner> call(ServiceResponse<Page<VirtualClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualClusterInner>>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(ServiceResponse<Page<VirtualClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualClusterInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualClusterInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualClustersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualClusterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualClustersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Sql/virtualClusters")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="virtualClusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="virtualClusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="virtualClusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="virtualClusterName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualClusterUpdate var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/virtualClusters/{virtualClusterName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualClusterName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualClusterUpdate var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.VirtualClusters listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

