/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.sql.implementation.PageImpl;
import com.microsoft.azure.management.sql.implementation.ServiceObjectiveInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ServiceObjectivesInner {
    private ServiceObjectivesService service;
    private SqlManagementClientImpl client;

    public ServiceObjectivesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServiceObjectivesService)retrofit.create(ServiceObjectivesService.class);
        this.client = client;
    }

    public ServiceObjectiveInner get(String resourceGroupName, String serverName, String serviceObjectiveName) {
        return (ServiceObjectiveInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, serviceObjectiveName).toBlocking().single()).body());
    }

    public ServiceFuture<ServiceObjectiveInner> getAsync(String resourceGroupName, String serverName, String serviceObjectiveName, ServiceCallback<ServiceObjectiveInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, serviceObjectiveName), serviceCallback);
    }

    public Observable<ServiceObjectiveInner> getAsync(String resourceGroupName, String serverName, String serviceObjectiveName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, serviceObjectiveName).map((Func1)new Func1<ServiceResponse<ServiceObjectiveInner>, ServiceObjectiveInner>(){

            public ServiceObjectiveInner call(ServiceResponse<ServiceObjectiveInner> response) {
                return (ServiceObjectiveInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServiceObjectiveInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String serviceObjectiveName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (serviceObjectiveName == null) {
            throw new IllegalArgumentException("Parameter serviceObjectiveName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, serverName, serviceObjectiveName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServiceObjectiveInner>>>(){

            public Observable<ServiceResponse<ServiceObjectiveInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServiceObjectivesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServiceObjectiveInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServiceObjectiveInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ServiceObjectiveInner> listByServer(String resourceGroupName, String serverName) {
        return (List)((ServiceResponse)this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ServiceObjectiveInner>> listByServerAsync(String resourceGroupName, String serverName, ServiceCallback<List<ServiceObjectiveInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByServerWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<List<ServiceObjectiveInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<List<ServiceObjectiveInner>>, List<ServiceObjectiveInner>>(){

            public List<ServiceObjectiveInner> call(ServiceResponse<List<ServiceObjectiveInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ServiceObjectiveInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        String apiVersion = "2014-04-01";
        return this.service.listByServer(this.client.subscriptionId(), resourceGroupName, serverName, "2014-04-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ServiceObjectiveInner>>>>(){

            public Observable<ServiceResponse<List<ServiceObjectiveInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServiceObjectivesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ServiceObjectiveInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ServiceObjectiveInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServiceObjectivesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServiceObjectives get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/serviceObjectives/{serviceObjectiveName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Path(value="serviceObjectiveName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServiceObjectives listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/serviceObjectives")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="serverName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

