/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.ServerSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ServerSecurityAlertPoliciesInner {
    private ServerSecurityAlertPoliciesService service;
    private SqlManagementClientImpl client;

    public ServerSecurityAlertPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ServerSecurityAlertPoliciesService)retrofit.create(ServerSecurityAlertPoliciesService.class);
        this.client = client;
    }

    public ServerSecurityAlertPolicyInner get(String resourceGroupName, String serverName) {
        return (ServerSecurityAlertPolicyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName).toBlocking().single()).body());
    }

    public ServiceFuture<ServerSecurityAlertPolicyInner> getAsync(String resourceGroupName, String serverName, ServiceCallback<ServerSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName), serviceCallback);
    }

    public Observable<ServerSecurityAlertPolicyInner> getAsync(String resourceGroupName, String serverName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<ServerSecurityAlertPolicyInner>, ServerSecurityAlertPolicyInner>(){

            public ServerSecurityAlertPolicyInner call(ServiceResponse<ServerSecurityAlertPolicyInner> response) {
                return (ServerSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerSecurityAlertPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String securityAlertPolicyName = "Default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, "Default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerSecurityAlertPolicyInner>>>(){

            public Observable<ServiceResponse<ServerSecurityAlertPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerSecurityAlertPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerSecurityAlertPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerSecurityAlertPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ServerSecurityAlertPolicyInner createOrUpdate(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters) {
        return (ServerSecurityAlertPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ServerSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters, ServiceCallback<ServerSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ServerSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ServerSecurityAlertPolicyInner>, ServerSecurityAlertPolicyInner>(){

            public ServerSecurityAlertPolicyInner call(ServiceResponse<ServerSecurityAlertPolicyInner> response) {
                return (ServerSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerSecurityAlertPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String securityAlertPolicyName = "Default";
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, "Default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ServerSecurityAlertPolicyInner>(){}.getType());
    }

    public ServerSecurityAlertPolicyInner beginCreateOrUpdate(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters) {
        return (ServerSecurityAlertPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ServerSecurityAlertPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters, ServiceCallback<ServerSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters), serviceCallback);
    }

    public Observable<ServerSecurityAlertPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, parameters).map((Func1)new Func1<ServiceResponse<ServerSecurityAlertPolicyInner>, ServerSecurityAlertPolicyInner>(){

            public ServerSecurityAlertPolicyInner call(ServiceResponse<ServerSecurityAlertPolicyInner> response) {
                return (ServerSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ServerSecurityAlertPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, ServerSecurityAlertPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String securityAlertPolicyName = "Default";
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, "Default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ServerSecurityAlertPolicyInner>>>(){

            public Observable<ServiceResponse<ServerSecurityAlertPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ServerSecurityAlertPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ServerSecurityAlertPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ServerSecurityAlertPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerSecurityAlertPolicyInner> listByServer(String resourceGroupName, String serverName) {
        ServiceResponse response = (ServiceResponse)this.listByServerSinglePageAsync(resourceGroupName, serverName).toBlocking().single();
        return new PagedList<ServerSecurityAlertPolicyInner>((Page)response.body()){

            public Page<ServerSecurityAlertPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerSecurityAlertPoliciesInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerSecurityAlertPolicyInner>> listByServerAsync(String resourceGroupName, String serverName, ListOperationCallback<ServerSecurityAlertPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerSinglePageAsync(resourceGroupName, serverName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> call(String nextPageLink) {
                return ServerSecurityAlertPoliciesInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerSecurityAlertPolicyInner>> listByServerAsync(String resourceGroupName, String serverName) {
        return this.listByServerWithServiceResponseAsync(resourceGroupName, serverName).map((Func1)new Func1<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>, Page<ServerSecurityAlertPolicyInner>>(){

            public Page<ServerSecurityAlertPolicyInner> call(ServiceResponse<Page<ServerSecurityAlertPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> listByServerWithServiceResponseAsync(String resourceGroupName, String serverName) {
        return this.listByServerSinglePageAsync(resourceGroupName, serverName).concatMap((Func1)new Func1<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>, Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> call(ServiceResponse<Page<ServerSecurityAlertPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerSecurityAlertPoliciesInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByServer(resourceGroupName, serverName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerSecurityAlertPoliciesInner.this.listByServerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerSecurityAlertPolicyInner>> listByServerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerSecurityAlertPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ServerSecurityAlertPolicyInner> listByServerNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ServerSecurityAlertPolicyInner>((Page)response.body()){

            public Page<ServerSecurityAlertPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ServerSecurityAlertPoliciesInner.this.listByServerNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ServerSecurityAlertPolicyInner>> listByServerNextAsync(String nextPageLink, ServiceFuture<List<ServerSecurityAlertPolicyInner>> serviceFuture, ListOperationCallback<ServerSecurityAlertPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByServerNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> call(String nextPageLink) {
                return ServerSecurityAlertPoliciesInner.this.listByServerNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ServerSecurityAlertPolicyInner>> listByServerNextAsync(String nextPageLink) {
        return this.listByServerNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>, Page<ServerSecurityAlertPolicyInner>>(){

            public Page<ServerSecurityAlertPolicyInner> call(ServiceResponse<Page<ServerSecurityAlertPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> listByServerNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByServerNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>, Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> call(ServiceResponse<Page<ServerSecurityAlertPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ServerSecurityAlertPoliciesInner.this.listByServerNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> listByServerNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByServerNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ServerSecurityAlertPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ServerSecurityAlertPoliciesInner.this.listByServerNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ServerSecurityAlertPolicyInner>> listByServerNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ServerSecurityAlertPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ServerSecurityAlertPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerSecurityAlertPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="securityAlertPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerSecurityAlertPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="securityAlertPolicyName") String var3, @Path(value="subscriptionId") String var4, @Body ServerSecurityAlertPolicyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerSecurityAlertPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="securityAlertPolicyName") String var3, @Path(value="subscriptionId") String var4, @Body ServerSecurityAlertPolicyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerSecurityAlertPolicies listByServer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/securityAlertPolicies")
        public Observable<Response<ResponseBody>> listByServer(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ServerSecurityAlertPolicies listByServerNext"})
        @GET
        public Observable<Response<ResponseBody>> listByServerNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

