/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.ManagedServerSecurityAlertPolicyInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ManagedServerSecurityAlertPoliciesInner {
    private ManagedServerSecurityAlertPoliciesService service;
    private SqlManagementClientImpl client;

    public ManagedServerSecurityAlertPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (ManagedServerSecurityAlertPoliciesService)retrofit.create(ManagedServerSecurityAlertPoliciesService.class);
        this.client = client;
    }

    public ManagedServerSecurityAlertPolicyInner get(String resourceGroupName, String managedInstanceName) {
        return (ManagedServerSecurityAlertPolicyInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedServerSecurityAlertPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, ServiceCallback<ManagedServerSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName), serviceCallback);
    }

    public Observable<ManagedServerSecurityAlertPolicyInner> getAsync(String resourceGroupName, String managedInstanceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<ManagedServerSecurityAlertPolicyInner>, ManagedServerSecurityAlertPolicyInner>(){

            public ManagedServerSecurityAlertPolicyInner call(ServiceResponse<ManagedServerSecurityAlertPolicyInner> response) {
                return (ManagedServerSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String securityAlertPolicyName = "Default";
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, managedInstanceName, "Default", this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedServerSecurityAlertPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedServerSecurityAlertPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedServerSecurityAlertPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ManagedServerSecurityAlertPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters) {
        return (ManagedServerSecurityAlertPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ManagedServerSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters, ServiceCallback<ManagedServerSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedServerSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedServerSecurityAlertPolicyInner>, ManagedServerSecurityAlertPolicyInner>(){

            public ManagedServerSecurityAlertPolicyInner call(ServiceResponse<ManagedServerSecurityAlertPolicyInner> response) {
                return (ManagedServerSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String securityAlertPolicyName = "Default";
        String apiVersion = "2017-03-01-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, managedInstanceName, "Default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ManagedServerSecurityAlertPolicyInner>(){}.getType());
    }

    public ManagedServerSecurityAlertPolicyInner beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters) {
        return (ManagedServerSecurityAlertPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ManagedServerSecurityAlertPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters, ServiceCallback<ManagedServerSecurityAlertPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters), serviceCallback);
    }

    public Observable<ManagedServerSecurityAlertPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, managedInstanceName, parameters).map((Func1)new Func1<ServiceResponse<ManagedServerSecurityAlertPolicyInner>, ManagedServerSecurityAlertPolicyInner>(){

            public ManagedServerSecurityAlertPolicyInner call(ServiceResponse<ManagedServerSecurityAlertPolicyInner> response) {
                return (ManagedServerSecurityAlertPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String managedInstanceName, ManagedServerSecurityAlertPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String securityAlertPolicyName = "Default";
        String apiVersion = "2017-03-01-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, managedInstanceName, "Default", this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>>>(){

            public Observable<ServiceResponse<ManagedServerSecurityAlertPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ManagedServerSecurityAlertPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ManagedServerSecurityAlertPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ManagedServerSecurityAlertPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedServerSecurityAlertPolicyInner> listByInstance(String resourceGroupName, String managedInstanceName) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).toBlocking().single();
        return new PagedList<ManagedServerSecurityAlertPolicyInner>((Page)response.body()){

            public Page<ManagedServerSecurityAlertPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedServerSecurityAlertPolicyInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName, ListOperationCallback<ManagedServerSecurityAlertPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> call(String nextPageLink) {
                return ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedServerSecurityAlertPolicyInner>> listByInstanceAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceWithServiceResponseAsync(resourceGroupName, managedInstanceName).map((Func1)new Func1<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>, Page<ManagedServerSecurityAlertPolicyInner>>(){

            public Page<ManagedServerSecurityAlertPolicyInner> call(ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> listByInstanceWithServiceResponseAsync(String resourceGroupName, String managedInstanceName) {
        return this.listByInstanceSinglePageAsync(resourceGroupName, managedInstanceName).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>, Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> call(ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> listByInstanceSinglePageAsync(String resourceGroupName, String managedInstanceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (managedInstanceName == null) {
            throw new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByInstance(resourceGroupName, managedInstanceName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedServerSecurityAlertPoliciesInner.this.listByInstanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedServerSecurityAlertPolicyInner>> listByInstanceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedServerSecurityAlertPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ManagedServerSecurityAlertPolicyInner> listByInstanceNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ManagedServerSecurityAlertPolicyInner>((Page)response.body()){

            public Page<ManagedServerSecurityAlertPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ManagedServerSecurityAlertPolicyInner>> listByInstanceNextAsync(String nextPageLink, ServiceFuture<List<ManagedServerSecurityAlertPolicyInner>> serviceFuture, ListOperationCallback<ManagedServerSecurityAlertPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByInstanceNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> call(String nextPageLink) {
                return ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ManagedServerSecurityAlertPolicyInner>> listByInstanceNextAsync(String nextPageLink) {
        return this.listByInstanceNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>, Page<ManagedServerSecurityAlertPolicyInner>>(){

            public Page<ManagedServerSecurityAlertPolicyInner> call(ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> listByInstanceNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByInstanceNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>, Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> call(ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> listByInstanceNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByInstanceNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<ManagedServerSecurityAlertPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ManagedServerSecurityAlertPoliciesInner.this.listByInstanceNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ManagedServerSecurityAlertPolicyInner>> listByInstanceNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ManagedServerSecurityAlertPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ManagedServerSecurityAlertPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedServerSecurityAlertPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="securityAlertPolicyName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedServerSecurityAlertPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="securityAlertPolicyName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedServerSecurityAlertPolicyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedServerSecurityAlertPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/securityAlertPolicies/{securityAlertPolicyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="securityAlertPolicyName") String var3, @Path(value="subscriptionId") String var4, @Body ManagedServerSecurityAlertPolicyInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedServerSecurityAlertPolicies listByInstance"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/securityAlertPolicies")
        public Observable<Response<ResponseBody>> listByInstance(@Path(value="resourceGroupName") String var1, @Path(value="managedInstanceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.ManagedServerSecurityAlertPolicies listByInstanceNext"})
        @GET
        public Observable<Response<ResponseBody>> listByInstanceNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

