/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Credentials;

@ApiModel(description="Hyper-V node domain.")
public class WindowsDomain {
    @SerializedName(value="domain_credential")
    private Credentials domainCredential = null;
    @SerializedName(value="domain_name")
    private String domainName = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="name_prefix")
    private String namePrefix = null;
    @SerializedName(value="name_server_ip")
    private String nameServerIp = null;
    @SerializedName(value="organization_unit_path")
    private String organizationUnitPath = null;

    public WindowsDomain domainCredential(Credentials domainCredential) {
        this.domainCredential = domainCredential;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public Credentials getDomainCredential() {
        return this.domainCredential;
    }

    public void setDomainCredential(Credentials domainCredential) {
        this.domainCredential = domainCredential;
    }

    public WindowsDomain domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(example="null", value="Full name of domain.")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public WindowsDomain name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the node to be renamed to during domain-join. If not given, a new name will be automatically assigned. ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WindowsDomain namePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    @ApiModelProperty(example="null", value="The name prefix in the domain in case of CPS deployment.")
    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public WindowsDomain nameServerIp(String nameServerIp) {
        this.nameServerIp = nameServerIp;
        return this;
    }

    @ApiModelProperty(example="null", value="The ip of name server that can resolve the domain name. Required during joining domain. ")
    public String getNameServerIp() {
        return this.nameServerIp;
    }

    public void setNameServerIp(String nameServerIp) {
        this.nameServerIp = nameServerIp;
    }

    public WindowsDomain organizationUnitPath(String organizationUnitPath) {
        this.organizationUnitPath = organizationUnitPath;
        return this;
    }

    @ApiModelProperty(example="null", value="Path to organization unit in the domain.")
    public String getOrganizationUnitPath() {
        return this.organizationUnitPath;
    }

    public void setOrganizationUnitPath(String organizationUnitPath) {
        this.organizationUnitPath = organizationUnitPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowsDomain windowsDomain = (WindowsDomain)o;
        return Objects.equals(this.domainCredential, windowsDomain.domainCredential) && Objects.equals(this.domainName, windowsDomain.domainName) && Objects.equals(this.name, windowsDomain.name) && Objects.equals(this.namePrefix, windowsDomain.namePrefix) && Objects.equals(this.nameServerIp, windowsDomain.nameServerIp) && Objects.equals(this.organizationUnitPath, windowsDomain.organizationUnitPath);
    }

    public int hashCode() {
        return Objects.hash(this.domainCredential, this.domainName, this.name, this.namePrefix, this.nameServerIp, this.organizationUnitPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WindowsDomain {\n");
        sb.append("    domainCredential: ").append(this.toIndentedString(this.domainCredential)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namePrefix: ").append(this.toIndentedString(this.namePrefix)).append("\n");
        sb.append("    nameServerIp: ").append(this.toIndentedString(this.nameServerIp)).append("\n");
        sb.append("    organizationUnitPath: ").append(this.toIndentedString(this.organizationUnitPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

