/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.WebhookResourcesCredentials;

@ApiModel(description="Webhook resources.")
public class WebhookResources {
    @SerializedName(value="credentials")
    private WebhookResourcesCredentials credentials = null;
    @SerializedName(value="events_filter_list")
    private List<String> eventsFilterList = new ArrayList<String>();
    @SerializedName(value="post_url")
    private String postUrl = null;

    public WebhookResources credentials(WebhookResourcesCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public WebhookResourcesCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(WebhookResourcesCredentials credentials) {
        this.credentials = credentials;
    }

    public WebhookResources eventsFilterList(List<String> eventsFilterList) {
        this.eventsFilterList = eventsFilterList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of events subscribed to by the webhook.")
    public List<String> getEventsFilterList() {
        return this.eventsFilterList;
    }

    public void setEventsFilterList(List<String> eventsFilterList) {
        this.eventsFilterList = eventsFilterList;
    }

    public WebhookResources postUrl(String postUrl) {
        this.postUrl = postUrl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="URL for the webhook.")
    public String getPostUrl() {
        return this.postUrl;
    }

    public void setPostUrl(String postUrl) {
        this.postUrl = postUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookResources webhookResources = (WebhookResources)o;
        return Objects.equals(this.credentials, webhookResources.credentials) && Objects.equals(this.eventsFilterList, webhookResources.eventsFilterList) && Objects.equals(this.postUrl, webhookResources.postUrl);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.eventsFilterList, this.postUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookResources {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    eventsFilterList: ").append(this.toIndentedString(this.eventsFilterList)).append("\n");
        sb.append("    postUrl: ").append(this.toIndentedString(this.postUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

