/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Reference;

@ApiModel(description="Data sent in the webhook.")
public class WebhookPostData {
    @SerializedName(value="data")
    private Object data = null;
    @SerializedName(value="entity_reference")
    private Reference entityReference = null;
    @SerializedName(value="event_type")
    private String eventType = null;
    @SerializedName(value="version")
    private String version = "1.0";

    public WebhookPostData data(Object data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entity object.")
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public WebhookPostData entityReference(Reference entityReference) {
        this.entityReference = entityReference;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entity reference.")
    public Reference getEntityReference() {
        return this.entityReference;
    }

    public void setEntityReference(Reference entityReference) {
        this.entityReference = entityReference;
    }

    public WebhookPostData eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Event type")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public WebhookPostData version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the webhook data.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookPostData webhookPostData = (WebhookPostData)o;
        return Objects.equals(this.data, webhookPostData.data) && Objects.equals(this.entityReference, webhookPostData.entityReference) && Objects.equals(this.eventType, webhookPostData.eventType) && Objects.equals(this.version, webhookPostData.version);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.entityReference, this.eventType, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookPostData {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    entityReference: ").append(this.toIndentedString(this.entityReference)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

