/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.AttachmentReference;
import nutanix.model.VolumeDiskResource;

@ApiModel(description="Volume group resources.")
public class VolumeGroupResources {
    @SerializedName(value="attachment_list")
    private List<AttachmentReference> attachmentList = new ArrayList<AttachmentReference>();
    @SerializedName(value="disk_list")
    private List<VolumeDiskResource> diskList = new ArrayList<VolumeDiskResource>();
    @SerializedName(value="file_system_type")
    private String fileSystemType = null;
    @SerializedName(value="iscsi_target_name")
    private String iscsiTargetName = null;
    @SerializedName(value="iscsi_target_prefix")
    private String iscsiTargetPrefix = null;
    @SerializedName(value="sharing_status")
    private String sharingStatus = null;
    @SerializedName(value="size_mib")
    private Long sizeMib = null;

    public VolumeGroupResources attachmentList(List<AttachmentReference> attachmentList) {
        this.attachmentList = attachmentList;
        return this;
    }

    @ApiModelProperty(example="null", value="VMs attached to volume group.")
    public List<AttachmentReference> getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(List<AttachmentReference> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public VolumeGroupResources diskList(List<VolumeDiskResource> diskList) {
        this.diskList = diskList;
        return this;
    }

    @ApiModelProperty(example="null", value="Volume group disk specification.")
    public List<VolumeDiskResource> getDiskList() {
        return this.diskList;
    }

    public void setDiskList(List<VolumeDiskResource> diskList) {
        this.diskList = diskList;
    }

    public VolumeGroupResources fileSystemType(String fileSystemType) {
        this.fileSystemType = fileSystemType;
        return this;
    }

    @ApiModelProperty(example="null", value="File system to be used for volume")
    public String getFileSystemType() {
        return this.fileSystemType;
    }

    public void setFileSystemType(String fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public VolumeGroupResources iscsiTargetName(String iscsiTargetName) {
        this.iscsiTargetName = iscsiTargetName;
        return this;
    }

    @ApiModelProperty(example="null", value="iSCSI target full name")
    public String getIscsiTargetName() {
        return this.iscsiTargetName;
    }

    public void setIscsiTargetName(String iscsiTargetName) {
        this.iscsiTargetName = iscsiTargetName;
    }

    public VolumeGroupResources iscsiTargetPrefix(String iscsiTargetPrefix) {
        this.iscsiTargetPrefix = iscsiTargetPrefix;
        return this;
    }

    @ApiModelProperty(example="null", value="iSCSI target prefix-name.")
    public String getIscsiTargetPrefix() {
        return this.iscsiTargetPrefix;
    }

    public void setIscsiTargetPrefix(String iscsiTargetPrefix) {
        this.iscsiTargetPrefix = iscsiTargetPrefix;
    }

    public VolumeGroupResources sharingStatus(String sharingStatus) {
        this.sharingStatus = sharingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the volume group can be shared across multiple iSCSI initiators. ")
    public String getSharingStatus() {
        return this.sharingStatus;
    }

    public void setSharingStatus(String sharingStatus) {
        this.sharingStatus = sharingStatus;
    }

    @ApiModelProperty(example="null", value="The total size of the Volume Group.")
    public Long getSizeMib() {
        return this.sizeMib;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeGroupResources volumeGroupResources = (VolumeGroupResources)o;
        return Objects.equals(this.attachmentList, volumeGroupResources.attachmentList) && Objects.equals(this.diskList, volumeGroupResources.diskList) && Objects.equals(this.fileSystemType, volumeGroupResources.fileSystemType) && Objects.equals(this.iscsiTargetName, volumeGroupResources.iscsiTargetName) && Objects.equals(this.iscsiTargetPrefix, volumeGroupResources.iscsiTargetPrefix) && Objects.equals(this.sharingStatus, volumeGroupResources.sharingStatus) && Objects.equals(this.sizeMib, volumeGroupResources.sizeMib);
    }

    public int hashCode() {
        return Objects.hash(this.attachmentList, this.diskList, this.fileSystemType, this.iscsiTargetName, this.iscsiTargetPrefix, this.sharingStatus, this.sizeMib);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VolumeGroupResources {\n");
        sb.append("    attachmentList: ").append(this.toIndentedString(this.attachmentList)).append("\n");
        sb.append("    diskList: ").append(this.toIndentedString(this.diskList)).append("\n");
        sb.append("    fileSystemType: ").append(this.toIndentedString(this.fileSystemType)).append("\n");
        sb.append("    iscsiTargetName: ").append(this.toIndentedString(this.iscsiTargetName)).append("\n");
        sb.append("    iscsiTargetPrefix: ").append(this.toIndentedString(this.iscsiTargetPrefix)).append("\n");
        sb.append("    sharingStatus: ").append(this.toIndentedString(this.sharingStatus)).append("\n");
        sb.append("    sizeMib: ").append(this.toIndentedString(this.sizeMib)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

