/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.Reference;

@ApiModel(description="Volume disk configuration.")
public class VolumeDiskResource {
    @SerializedName(value="data_source_reference")
    private Reference dataSourceReference = null;
    @SerializedName(value="disk_size_mib")
    private Long diskSizeMib = null;
    @SerializedName(value="index")
    private Integer index = null;
    @SerializedName(value="storage_container_uuid")
    private String storageContainerUuid = null;

    public VolumeDiskResource dataSourceReference(Reference dataSourceReference) {
        this.dataSourceReference = dataSourceReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Reference getDataSourceReference() {
        return this.dataSourceReference;
    }

    public void setDataSourceReference(Reference dataSourceReference) {
        this.dataSourceReference = dataSourceReference;
    }

    public VolumeDiskResource diskSizeMib(Long diskSizeMib) {
        this.diskSizeMib = diskSizeMib;
        return this;
    }

    @ApiModelProperty(example="null", value="Size of the disk in MiB.")
    public Long getDiskSizeMib() {
        return this.diskSizeMib;
    }

    public void setDiskSizeMib(Long diskSizeMib) {
        this.diskSizeMib = diskSizeMib;
    }

    public VolumeDiskResource index(Integer index) {
        this.index = index;
        return this;
    }

    @ApiModelProperty(example="null", value="Index of the volume disk in the group.")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public VolumeDiskResource storageContainerUuid(String storageContainerUuid) {
        this.storageContainerUuid = storageContainerUuid;
        return this;
    }

    @ApiModelProperty(example="null", value="Container UUID on which to create the disk.")
    public String getStorageContainerUuid() {
        return this.storageContainerUuid;
    }

    public void setStorageContainerUuid(String storageContainerUuid) {
        this.storageContainerUuid = storageContainerUuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeDiskResource volumeDiskResource = (VolumeDiskResource)o;
        return Objects.equals(this.dataSourceReference, volumeDiskResource.dataSourceReference) && Objects.equals(this.diskSizeMib, volumeDiskResource.diskSizeMib) && Objects.equals(this.index, volumeDiskResource.index) && Objects.equals(this.storageContainerUuid, volumeDiskResource.storageContainerUuid);
    }

    public int hashCode() {
        return Objects.hash(this.dataSourceReference, this.diskSizeMib, this.index, this.storageContainerUuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VolumeDiskResource {\n");
        sb.append("    dataSourceReference: ").append(this.toIndentedString(this.dataSourceReference)).append("\n");
        sb.append("    diskSizeMib: ").append(this.toIndentedString(this.diskSizeMib)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    storageContainerUuid: ").append(this.toIndentedString(this.storageContainerUuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

