/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import nutanix.model.UserReference;
import nutanix.model.VmReference;
import org.joda.time.DateTime;

@ApiModel(description="The vm snapshot kind metadata")
public class VmSnapshotMetadata {
    @SerializedName(value="creation_time")
    private DateTime creationTime = null;
    @SerializedName(value="kind")
    private String kind = "vm_snapshot";
    @SerializedName(value="last_update_time")
    private DateTime lastUpdateTime = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="owner_reference")
    private UserReference ownerReference = null;
    @SerializedName(value="parent_reference")
    private VmReference parentReference = null;
    @SerializedName(value="spec_version")
    private Integer specVersion = null;
    @SerializedName(value="uuid")
    private String uuid = null;

    public VmSnapshotMetadata creationTime(DateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time when vm snapshot was created")
    public DateTime getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(DateTime creationTime) {
        this.creationTime = creationTime;
    }

    @ApiModelProperty(example="null", value="The kind snapshot name")
    public String getKind() {
        return this.kind;
    }

    public VmSnapshotMetadata lastUpdateTime(DateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time when vm snapshot was last updated")
    public DateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(DateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public VmSnapshotMetadata name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="vm snapshot name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VmSnapshotMetadata ownerReference(UserReference ownerReference) {
        this.ownerReference = ownerReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public UserReference getOwnerReference() {
        return this.ownerReference;
    }

    public void setOwnerReference(UserReference ownerReference) {
        this.ownerReference = ownerReference;
    }

    public VmSnapshotMetadata parentReference(VmReference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmReference getParentReference() {
        return this.parentReference;
    }

    public void setParentReference(VmReference parentReference) {
        this.parentReference = parentReference;
    }

    public VmSnapshotMetadata specVersion(Integer specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="Version number of the latest spec")
    public Integer getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(Integer specVersion) {
        this.specVersion = specVersion;
    }

    public VmSnapshotMetadata uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(example="null", value="vm snapshot UUID")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmSnapshotMetadata vmSnapshotMetadata = (VmSnapshotMetadata)o;
        return Objects.equals(this.creationTime, vmSnapshotMetadata.creationTime) && Objects.equals(this.kind, vmSnapshotMetadata.kind) && Objects.equals(this.lastUpdateTime, vmSnapshotMetadata.lastUpdateTime) && Objects.equals(this.name, vmSnapshotMetadata.name) && Objects.equals(this.ownerReference, vmSnapshotMetadata.ownerReference) && Objects.equals(this.parentReference, vmSnapshotMetadata.parentReference) && Objects.equals(this.specVersion, vmSnapshotMetadata.specVersion) && Objects.equals(this.uuid, vmSnapshotMetadata.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.kind, this.lastUpdateTime, this.name, this.ownerReference, this.parentReference, this.specVersion, this.uuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmSnapshotMetadata {\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    lastUpdateTime: ").append(this.toIndentedString(this.lastUpdateTime)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerReference: ").append(this.toIndentedString(this.ownerReference)).append("\n");
        sb.append("    parentReference: ").append(this.toIndentedString(this.parentReference)).append("\n");
        sb.append("    specVersion: ").append(this.toIndentedString(this.specVersion)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

