/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.MessageResource;
import nutanix.model.VmSnapshotDefStatusSnapshotFileList;
import nutanix.model.VmSnapshotResources;

@ApiModel(description="The output object that defines a vm snapshot")
public class VmSnapshotDefStatus {
    @SerializedName(value="message_list")
    private List<MessageResource> messageList = new ArrayList<MessageResource>();
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="resources")
    private VmSnapshotResources resources = null;
    @SerializedName(value="snapshot_file_list")
    private List<VmSnapshotDefStatusSnapshotFileList> snapshotFileList = new ArrayList<VmSnapshotDefStatusSnapshotFileList>();
    @SerializedName(value="snapshot_type")
    private String snapshotType = null;
    @SerializedName(value="state")
    private String state = null;

    public VmSnapshotDefStatus messageList(List<MessageResource> messageList) {
        this.messageList = messageList;
        return this;
    }

    @ApiModelProperty(example="null", value="Any error messages for the vm, if in an error state.")
    public List<MessageResource> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<MessageResource> messageList) {
        this.messageList = messageList;
    }

    public VmSnapshotDefStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the snapshot.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VmSnapshotDefStatus resources(VmSnapshotResources resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmSnapshotResources getResources() {
        return this.resources;
    }

    public void setResources(VmSnapshotResources resources) {
        this.resources = resources;
    }

    public VmSnapshotDefStatus snapshotFileList(List<VmSnapshotDefStatusSnapshotFileList> snapshotFileList) {
        this.snapshotFileList = snapshotFileList;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Describes the files that are included in the snapshot. ")
    public List<VmSnapshotDefStatusSnapshotFileList> getSnapshotFileList() {
        return this.snapshotFileList;
    }

    public void setSnapshotFileList(List<VmSnapshotDefStatusSnapshotFileList> snapshotFileList) {
        this.snapshotFileList = snapshotFileList;
    }

    public VmSnapshotDefStatus snapshotType(String snapshotType) {
        this.snapshotType = snapshotType;
        return this;
    }

    @ApiModelProperty(example="null", value="The consistency level desired while creating the snapshot.")
    public String getSnapshotType() {
        return this.snapshotType;
    }

    public void setSnapshotType(String snapshotType) {
        this.snapshotType = snapshotType;
    }

    public VmSnapshotDefStatus state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the vm entity.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmSnapshotDefStatus vmSnapshotDefStatus = (VmSnapshotDefStatus)o;
        return Objects.equals(this.messageList, vmSnapshotDefStatus.messageList) && Objects.equals(this.name, vmSnapshotDefStatus.name) && Objects.equals(this.resources, vmSnapshotDefStatus.resources) && Objects.equals(this.snapshotFileList, vmSnapshotDefStatus.snapshotFileList) && Objects.equals(this.snapshotType, vmSnapshotDefStatus.snapshotType) && Objects.equals(this.state, vmSnapshotDefStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.messageList, this.name, this.resources, this.snapshotFileList, this.snapshotType, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmSnapshotDefStatus {\n");
        sb.append("    messageList: ").append(this.toIndentedString(this.messageList)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    snapshotFileList: ").append(this.toIndentedString(this.snapshotFileList)).append("\n");
        sb.append("    snapshotType: ").append(this.toIndentedString(this.snapshotType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

