/*
 * Decompiled with CFR 0.152.
 */
package nutanix.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nutanix.model.GuestCustomization;
import nutanix.model.Reference;
import nutanix.model.VmBootConfig;
import nutanix.model.VmDisk;
import nutanix.model.VmGpu;
import nutanix.model.VmNic;
import nutanix.model.VmPowerStateMechanism;

public class VmResources {
    @SerializedName(value="boot_config")
    private VmBootConfig bootConfig = null;
    @SerializedName(value="disk_list")
    private List<VmDisk> diskList = new ArrayList<VmDisk>();
    @SerializedName(value="gpu_list")
    private List<VmGpu> gpuList = new ArrayList<VmGpu>();
    @SerializedName(value="guest_customization")
    private GuestCustomization guestCustomization = null;
    @SerializedName(value="memory_size_mib")
    private Integer memorySizeMib = null;
    @SerializedName(value="nic_list")
    private List<VmNic> nicList = new ArrayList<VmNic>();
    @SerializedName(value="num_sockets")
    private Integer numSockets = null;
    @SerializedName(value="num_vcpus_per_socket")
    private Integer numVcpusPerSocket = null;
    @SerializedName(value="parent_reference")
    private Reference parentReference = null;
    @SerializedName(value="power_state")
    private String powerState = null;
    @SerializedName(value="power_state_mechanism")
    private VmPowerStateMechanism powerStateMechanism = null;

    public VmResources bootConfig(VmBootConfig bootConfig) {
        this.bootConfig = bootConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates which device the VM should boot from.")
    public VmBootConfig getBootConfig() {
        return this.bootConfig;
    }

    public void setBootConfig(VmBootConfig bootConfig) {
        this.bootConfig = bootConfig;
    }

    public VmResources diskList(List<VmDisk> diskList) {
        this.diskList = diskList;
        return this;
    }

    @ApiModelProperty(example="null", value="Disks attached to the VM.")
    public List<VmDisk> getDiskList() {
        return this.diskList;
    }

    public void setDiskList(List<VmDisk> diskList) {
        this.diskList = diskList;
    }

    public VmResources gpuList(List<VmGpu> gpuList) {
        this.gpuList = gpuList;
        return this;
    }

    @ApiModelProperty(example="null", value="GPUs attached to the VM.")
    public List<VmGpu> getGpuList() {
        return this.gpuList;
    }

    public void setGpuList(List<VmGpu> gpuList) {
        this.gpuList = gpuList;
    }

    public VmResources guestCustomization(GuestCustomization guestCustomization) {
        this.guestCustomization = guestCustomization;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public GuestCustomization getGuestCustomization() {
        return this.guestCustomization;
    }

    public void setGuestCustomization(GuestCustomization guestCustomization) {
        this.guestCustomization = guestCustomization;
    }

    public VmResources memorySizeMib(Integer memorySizeMib) {
        this.memorySizeMib = memorySizeMib;
        return this;
    }

    @ApiModelProperty(example="null", value="Memory size in MiB.")
    public Integer getMemorySizeMib() {
        return this.memorySizeMib;
    }

    public void setMemorySizeMib(Integer memorySizeMib) {
        this.memorySizeMib = memorySizeMib;
    }

    public VmResources nicList(List<VmNic> nicList) {
        this.nicList = nicList;
        return this;
    }

    @ApiModelProperty(example="null", value="NICs attached to the VM.")
    public List<VmNic> getNicList() {
        return this.nicList;
    }

    public void setNicList(List<VmNic> nicList) {
        this.nicList = nicList;
    }

    public VmResources numSockets(Integer numSockets) {
        this.numSockets = numSockets;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of vCPU sockets.")
    public Integer getNumSockets() {
        return this.numSockets;
    }

    public void setNumSockets(Integer numSockets) {
        this.numSockets = numSockets;
    }

    public VmResources numVcpusPerSocket(Integer numVcpusPerSocket) {
        this.numVcpusPerSocket = numVcpusPerSocket;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of vCPUs per socket.")
    public Integer getNumVcpusPerSocket() {
        return this.numVcpusPerSocket;
    }

    public void setNumVcpusPerSocket(Integer numVcpusPerSocket) {
        this.numVcpusPerSocket = numVcpusPerSocket;
    }

    public VmResources parentReference(Reference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    @ApiModelProperty(example="null", value="Reference to an entity that the VM should be cloned from. ")
    public Reference getParentReference() {
        return this.parentReference;
    }

    public void setParentReference(Reference parentReference) {
        this.parentReference = parentReference;
    }

    public VmResources powerState(String powerState) {
        this.powerState = powerState;
        return this;
    }

    @ApiModelProperty(example="null", value="The current or desired power state of the VM.")
    public String getPowerState() {
        return this.powerState;
    }

    public void setPowerState(String powerState) {
        this.powerState = powerState;
    }

    public VmResources powerStateMechanism(VmPowerStateMechanism powerStateMechanism) {
        this.powerStateMechanism = powerStateMechanism;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public VmPowerStateMechanism getPowerStateMechanism() {
        return this.powerStateMechanism;
    }

    public void setPowerStateMechanism(VmPowerStateMechanism powerStateMechanism) {
        this.powerStateMechanism = powerStateMechanism;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmResources vmResources = (VmResources)o;
        return Objects.equals(this.bootConfig, vmResources.bootConfig) && Objects.equals(this.diskList, vmResources.diskList) && Objects.equals(this.gpuList, vmResources.gpuList) && Objects.equals(this.guestCustomization, vmResources.guestCustomization) && Objects.equals(this.memorySizeMib, vmResources.memorySizeMib) && Objects.equals(this.nicList, vmResources.nicList) && Objects.equals(this.numSockets, vmResources.numSockets) && Objects.equals(this.numVcpusPerSocket, vmResources.numVcpusPerSocket) && Objects.equals(this.parentReference, vmResources.parentReference) && Objects.equals(this.powerState, vmResources.powerState) && Objects.equals(this.powerStateMechanism, vmResources.powerStateMechanism);
    }

    public int hashCode() {
        return Objects.hash(this.bootConfig, this.diskList, this.gpuList, this.guestCustomization, this.memorySizeMib, this.nicList, this.numSockets, this.numVcpusPerSocket, this.parentReference, this.powerState, this.powerStateMechanism);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VmResources {\n");
        sb.append("    bootConfig: ").append(this.toIndentedString(this.bootConfig)).append("\n");
        sb.append("    diskList: ").append(this.toIndentedString(this.diskList)).append("\n");
        sb.append("    gpuList: ").append(this.toIndentedString(this.gpuList)).append("\n");
        sb.append("    guestCustomization: ").append(this.toIndentedString(this.guestCustomization)).append("\n");
        sb.append("    memorySizeMib: ").append(this.toIndentedString(this.memorySizeMib)).append("\n");
        sb.append("    nicList: ").append(this.toIndentedString(this.nicList)).append("\n");
        sb.append("    numSockets: ").append(this.toIndentedString(this.numSockets)).append("\n");
        sb.append("    numVcpusPerSocket: ").append(this.toIndentedString(this.numVcpusPerSocket)).append("\n");
        sb.append("    parentReference: ").append(this.toIndentedString(this.parentReference)).append("\n");
        sb.append("    powerState: ").append(this.toIndentedString(this.powerState)).append("\n");
        sb.append("    powerStateMechanism: ").append(this.toIndentedString(this.powerStateMechanism)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

